/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.cache.CacheUtils;
import org.apache.cxf.sts.claims.ClaimsAttributeStatementProvider;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.token.provider.AbstractSAMLTokenProvider;
import org.apache.cxf.sts.token.provider.ActAsAttributeStatementProvider;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.AuthDecisionStatementProvider;
import org.apache.cxf.sts.token.provider.AuthenticationStatementProvider;
import org.apache.cxf.sts.token.provider.ConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultAttributeStatementProvider;
import org.apache.cxf.sts.token.provider.DefaultConditionsProvider;
import org.apache.cxf.sts.token.provider.DefaultSubjectProvider;
import org.apache.cxf.sts.token.provider.SamlCallbackHandler;
import org.apache.cxf.sts.token.provider.SamlCustomHandler;
import org.apache.cxf.sts.token.provider.SubjectProvider;
import org.apache.cxf.sts.token.provider.SubjectProviderParameters;
import org.apache.cxf.sts.token.provider.SymmetricKeyHandler;
import org.apache.cxf.sts.token.provider.TokenProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.sts.token.provider.TokenProviderResponse;
import org.apache.cxf.sts.token.provider.TokenProviderUtils;
import org.apache.cxf.sts.token.realm.RealmProperties;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthDecisionStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.joda.time.DateTime;
import org.opensaml.saml.common.SAMLVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLTokenProvider
extends AbstractSAMLTokenProvider
implements TokenProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(SAMLTokenProvider.class);
    private List<AttributeStatementProvider> attributeStatementProviders;
    private List<AuthenticationStatementProvider> authenticationStatementProviders;
    private List<AuthDecisionStatementProvider> authDecisionStatementProviders;
    private SubjectProvider subjectProvider = new DefaultSubjectProvider();
    private ConditionsProvider conditionsProvider = new DefaultConditionsProvider();
    private boolean signToken = true;
    private Map<String, RealmProperties> realmMap = new HashMap<String, RealmProperties>();
    private SamlCustomHandler samlCustomHandler;

    @Override
    public boolean canHandleToken(String tokenType) {
        return this.canHandleToken(tokenType, null);
    }

    @Override
    public boolean canHandleToken(String tokenType, String realm) {
        if (realm != null && !this.realmMap.containsKey(realm)) {
            return false;
        }
        return "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType) || "urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType);
    }

    @Override
    public TokenProviderResponse createToken(TokenProviderParameters tokenParameters) {
        this.testKeyType(tokenParameters);
        KeyRequirements keyRequirements = tokenParameters.getKeyRequirements();
        TokenRequirements tokenRequirements = tokenParameters.getTokenRequirements();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Handling token of type: " + tokenRequirements.getTokenType());
        }
        byte[] secret = null;
        byte[] entropyBytes = null;
        long keySize = 0L;
        boolean computedKey = false;
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyRequirements.getKeyType())) {
            SymmetricKeyHandler keyHandler = new SymmetricKeyHandler(tokenParameters);
            keyHandler.createSymmetricKey();
            secret = keyHandler.getSecret();
            entropyBytes = keyHandler.getEntropyBytes();
            keySize = keyHandler.getKeySize();
            computedKey = keyHandler.isComputedKey();
        }
        try {
            Document doc = DOMUtils.createDocument();
            SamlAssertionWrapper assertion = this.createSamlToken(tokenParameters, secret, doc);
            Element token = assertion.toDOM(doc);
            byte[] signatureValue = assertion.getSignatureValue();
            if (tokenParameters.getTokenStore() != null && signatureValue != null && signatureValue.length > 0) {
                DateTime validTill = null;
                validTill = assertion.getSamlVersion().equals(SAMLVersion.VERSION_20) ? assertion.getSaml2().getConditions().getNotOnOrAfter() : assertion.getSaml1().getConditions().getNotOnOrAfter();
                SecurityToken securityToken = CacheUtils.createSecurityTokenForStorage(token, assertion.getId(), validTill.toDate(), tokenParameters.getPrincipal(), tokenParameters.getRealm(), tokenParameters.getTokenRequirements().getRenewing());
                CacheUtils.storeTokenInCache(securityToken, tokenParameters.getTokenStore(), signatureValue);
            }
            TokenProviderResponse response = new TokenProviderResponse();
            String tokenType = tokenRequirements.getTokenType();
            if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
                response.setTokenId(token.getAttributeNS(null, "ID"));
            } else {
                response.setTokenId(token.getAttributeNS(null, "AssertionID"));
            }
            if (tokenParameters.isEncryptToken()) {
                token = TokenProviderUtils.encryptToken(token, response.getTokenId(), tokenParameters.getStsProperties(), tokenParameters.getEncryptionProperties(), keyRequirements, tokenParameters.getMessageContext());
            }
            response.setToken(token);
            DateTime validFrom = null;
            DateTime validTill = null;
            if (assertion.getSamlVersion().equals(SAMLVersion.VERSION_20)) {
                validFrom = assertion.getSaml2().getConditions().getNotBefore();
                validTill = assertion.getSaml2().getConditions().getNotOnOrAfter();
            } else {
                validFrom = assertion.getSaml1().getConditions().getNotBefore();
                validTill = assertion.getSaml1().getConditions().getNotOnOrAfter();
            }
            response.setCreated(validFrom.toDate());
            response.setExpires(validTill.toDate());
            response.setEntropy(entropyBytes);
            if (keySize > 0L) {
                response.setKeySize(keySize);
            }
            response.setComputedKey(computedKey);
            LOG.fine("SAML Token successfully created");
            return response;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "", e);
            throw new STSException("Can't serialize SAML assertion", (Throwable)e, STSException.REQUEST_FAILED);
        }
    }

    public void setAttributeStatementProviders(List<AttributeStatementProvider> attributeStatementProviders) {
        this.attributeStatementProviders = attributeStatementProviders;
    }

    public List<AttributeStatementProvider> getAttributeStatementProviders() {
        return this.attributeStatementProviders;
    }

    public void setAuthenticationStatementProviders(List<AuthenticationStatementProvider> authnStatementProviders) {
        this.authenticationStatementProviders = authnStatementProviders;
    }

    public List<AuthenticationStatementProvider> getAuthenticationStatementProviders() {
        return this.authenticationStatementProviders;
    }

    public void setAuthDecisionStatementProviders(List<AuthDecisionStatementProvider> authDecisionStatementProviders) {
        this.authDecisionStatementProviders = authDecisionStatementProviders;
    }

    public List<AuthDecisionStatementProvider> getAuthDecisionStatementProviders() {
        return this.authDecisionStatementProviders;
    }

    public void setSubjectProvider(SubjectProvider subjectProvider) {
        this.subjectProvider = subjectProvider;
    }

    public SubjectProvider getSubjectProvider() {
        return this.subjectProvider;
    }

    public void setConditionsProvider(ConditionsProvider conditionsProvider) {
        this.conditionsProvider = conditionsProvider;
    }

    public ConditionsProvider getConditionsProvider() {
        return this.conditionsProvider;
    }

    public boolean isSignToken() {
        return this.signToken;
    }

    public void setSignToken(boolean signToken) {
        this.signToken = signToken;
    }

    public void setRealmMap(Map<String, ? extends RealmProperties> realms) {
        this.realmMap.clear();
        if (realms != null) {
            this.realmMap.putAll(realms);
        }
    }

    public Map<String, RealmProperties> getRealmMap() {
        return Collections.unmodifiableMap(this.realmMap);
    }

    public void setSamlCustomHandler(SamlCustomHandler samlCustomHandler) {
        this.samlCustomHandler = samlCustomHandler;
    }

    private SamlAssertionWrapper createSamlToken(TokenProviderParameters tokenParameters, byte[] secret, Document doc) throws Exception {
        String realm = tokenParameters.getRealm();
        RealmProperties samlRealm = null;
        if (realm != null && this.realmMap.containsKey(realm)) {
            samlRealm = this.realmMap.get(realm);
        }
        SamlCallbackHandler handler = this.createCallbackHandler(tokenParameters, secret, samlRealm, doc);
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)handler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
        if (this.samlCustomHandler != null) {
            this.samlCustomHandler.handle(assertion, tokenParameters);
        }
        if (this.signToken) {
            STSPropertiesMBean stsProperties = tokenParameters.getStsProperties();
            this.signToken(assertion, samlRealm, stsProperties, tokenParameters.getKeyRequirements());
        }
        return assertion;
    }

    /*
     * WARNING - void declaration
     */
    public SamlCallbackHandler createCallbackHandler(TokenProviderParameters tokenParameters, byte[] secret, RealmProperties samlRealm, Document doc) throws Exception {
        void var8_13;
        boolean statementAdded = false;
        ArrayList<AttributeStatementBean> attrBeanList = null;
        if (this.attributeStatementProviders != null && this.attributeStatementProviders.size() > 0) {
            attrBeanList = new ArrayList<AttributeStatementBean>();
            for (AttributeStatementProvider attributeStatementProvider : this.attributeStatementProviders) {
                AttributeStatementBean attributeStatementBean = attributeStatementProvider.getStatement(tokenParameters);
                if (attributeStatementBean == null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("AttributeStatements " + attributeStatementBean.toString() + " returned by AttributeStatementProvider " + attributeStatementProvider.getClass().getName());
                }
                attrBeanList.add(attributeStatementBean);
                statementAdded = true;
            }
        }
        ArrayList<AuthenticationStatementBean> authBeanList = null;
        if (this.authenticationStatementProviders != null && this.authenticationStatementProviders.size() > 0) {
            authBeanList = new ArrayList<AuthenticationStatementBean>();
            for (AuthenticationStatementProvider authenticationStatementProvider : this.authenticationStatementProviders) {
                AuthenticationStatementBean statementBean = authenticationStatementProvider.getStatement(tokenParameters);
                if (statementBean == null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("AuthenticationStatement " + statementBean.toString() + " returned by AuthenticationStatementProvider " + authenticationStatementProvider.getClass().getName());
                }
                authBeanList.add(statementBean);
                statementAdded = true;
            }
        }
        Object var8_11 = null;
        if (this.authDecisionStatementProviders != null && this.authDecisionStatementProviders.size() > 0) {
            ArrayList<AuthDecisionStatementBean> arrayList = new ArrayList<AuthDecisionStatementBean>();
            for (AuthDecisionStatementProvider statementProvider : this.authDecisionStatementProviders) {
                AuthDecisionStatementBean statementBean = statementProvider.getStatement(tokenParameters);
                if (statementBean == null) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("AuthDecisionStatement " + statementBean.toString() + " returned by AuthDecisionStatementProvider " + statementProvider.getClass().getName());
                }
                arrayList.add(statementBean);
                statementAdded = true;
            }
        }
        if (!statementAdded) {
            attrBeanList = new ArrayList();
            ClaimsAttributeStatementProvider claimsAttributeStatementProvider = new ClaimsAttributeStatementProvider();
            AttributeStatementBean attributeBean = claimsAttributeStatementProvider.getStatement(tokenParameters);
            if (attributeBean != null && attributeBean.getSamlAttributes() != null && !attributeBean.getSamlAttributes().isEmpty()) {
                attrBeanList.add(attributeBean);
            } else {
                DefaultAttributeStatementProvider defaultAttributeStatementProvider = new DefaultAttributeStatementProvider();
                attributeBean = defaultAttributeStatementProvider.getStatement(tokenParameters);
                attrBeanList.add(attributeBean);
            }
            ActAsAttributeStatementProvider actAsAttributeStatementProvider = new ActAsAttributeStatementProvider();
            attributeBean = actAsAttributeStatementProvider.getStatement(tokenParameters);
            if (attributeBean != null && attributeBean.getSamlAttributes() != null && !attributeBean.getSamlAttributes().isEmpty()) {
                attrBeanList.add(attributeBean);
            }
        }
        SubjectProviderParameters subjectProviderParameters = new SubjectProviderParameters();
        subjectProviderParameters.setProviderParameters(tokenParameters);
        subjectProviderParameters.setDoc(doc);
        subjectProviderParameters.setSecret(secret);
        subjectProviderParameters.setAttrBeanList(attrBeanList);
        subjectProviderParameters.setAuthBeanList(authBeanList);
        subjectProviderParameters.setAuthDecisionBeanList((List<AuthDecisionStatementBean>)var8_13);
        SubjectBean subjectBean = this.subjectProvider.getSubject(subjectProviderParameters);
        ConditionsBean conditionsBean = this.conditionsProvider.getConditions(tokenParameters);
        SamlCallbackHandler handler = new SamlCallbackHandler();
        handler.setTokenProviderParameters(tokenParameters);
        handler.setSubjectBean(subjectBean);
        handler.setConditionsBean(conditionsBean);
        handler.setAttributeBeans(attrBeanList);
        handler.setAuthenticationBeans(authBeanList);
        handler.setAuthDecisionStatementBeans((List<AuthDecisionStatementBean>)var8_13);
        if (samlRealm != null) {
            handler.setIssuer(samlRealm.getIssuer());
        }
        return handler;
    }

    private void testKeyType(TokenProviderParameters tokenParameters) {
        KeyRequirements keyRequirements = tokenParameters.getKeyRequirements();
        String keyType = keyRequirements.getKeyType();
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            if (keyRequirements.getReceivedKey() == null || keyRequirements.getReceivedKey().getX509Cert() == null && keyRequirements.getReceivedKey().getPublicKey() == null) {
                LOG.log(Level.WARNING, "A PublicKey Keytype is requested, but no certificate is provided");
                throw new STSException("No client certificate for PublicKey KeyType", STSException.INVALID_REQUEST);
            }
        } else if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType) && !"http://docs.oasis-open.org/ws-sx/ws-trust/200512/Bearer".equals(keyType) && keyType != null) {
            LOG.log(Level.WARNING, "An unknown KeyType was requested: " + keyType);
            throw new STSException("Unknown KeyType", STSException.INVALID_REQUEST);
        }
    }
}

