/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;

@Path(value="oauth-authorization-server")
public class AuthorizationMetadataService {
    private String issuer;
    private boolean stripPathFromIssuerUri = true;
    private String authorizationEndpointAddress;
    private boolean tokenEndpointNotAvailable;
    private String tokenEndpointAddress;
    private boolean tokenRevocationEndpointNotAvailable;
    private String tokenRevocationEndpointAddress;
    private boolean jwkEndpointNotAvailable;
    private String jwkEndpointAddress;
    private boolean dynamicRegistrationEndpointNotAvailable;
    private String dynamicRegistrationEndpointAddress;

    @GET
    @Produces(value={"application/json"})
    public String getConfiguration(@Context UriInfo ui) {
        LinkedHashMap<String, Object> cfg = new LinkedHashMap<String, Object>();
        String baseUri = this.getBaseUri(ui);
        this.prepareConfigurationData(cfg, baseUri);
        JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();
        writer.setFormat(true);
        return writer.toJson(cfg);
    }

    protected void prepareConfigurationData(Map<String, Object> cfg, String baseUri) {
        cfg.put("issuer", this.buildIssuerUri(baseUri));
        String theAuthorizationEndpointAddress = AuthorizationMetadataService.calculateEndpointAddress(this.authorizationEndpointAddress, baseUri, "/idp/authorize");
        cfg.put("authorization_endpoint", theAuthorizationEndpointAddress);
        if (!this.isTokenEndpointNotAvailable()) {
            String theTokenEndpointAddress = AuthorizationMetadataService.calculateEndpointAddress(this.tokenEndpointAddress, baseUri, "/oauth2/token");
            cfg.put("token_endpoint", theTokenEndpointAddress);
        }
        if (!this.isTokenRevocationEndpointNotAvailable()) {
            String theTokenRevocationEndpointAddress = AuthorizationMetadataService.calculateEndpointAddress(this.tokenRevocationEndpointAddress, baseUri, "/oauth2/revoke");
            cfg.put("revocation_endpoint", theTokenRevocationEndpointAddress);
        }
        if (!this.isJwkEndpointNotAvailable()) {
            String theJwkEndpointAddress = AuthorizationMetadataService.calculateEndpointAddress(this.jwkEndpointAddress, baseUri, "/jwk/keys");
            cfg.put("jwks_uri", theJwkEndpointAddress);
        }
        if (!this.isDynamicRegistrationEndpointNotAvailable()) {
            String theDynamicRegistrationEndpointAddress = AuthorizationMetadataService.calculateEndpointAddress(this.dynamicRegistrationEndpointAddress, baseUri, "/dynamic/register");
            cfg.put("registration_endpoint", theDynamicRegistrationEndpointAddress);
        }
    }

    protected static String calculateEndpointAddress(String endpointAddress, String baseUri, String defRelAddress) {
        String string = endpointAddress = endpointAddress != null ? endpointAddress : defRelAddress;
        if (AuthorizationMetadataService.isAbsoluteUri(endpointAddress)) {
            return endpointAddress;
        }
        URI uri = UriBuilder.fromUri((String)baseUri).path(endpointAddress).build(new Object[0]);
        return AuthorizationMetadataService.removeDefaultPort(uri).toString();
    }

    private static boolean isAbsoluteUri(String endpointAddress) {
        if (endpointAddress == null) {
            return false;
        }
        return endpointAddress.startsWith("http://") || endpointAddress.startsWith("https://");
    }

    private String getBaseUri(UriInfo ui) {
        String requestUri = ui.getRequestUri().toString();
        int ind = requestUri.lastIndexOf(".well-known");
        if (ind != -1) {
            requestUri = requestUri.substring(0, ind);
        }
        return requestUri;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setAuthorizationEndpointAddress(String authorizationEndpointAddress) {
        this.authorizationEndpointAddress = authorizationEndpointAddress;
    }

    public void setTokenEndpointAddress(String tokenEndpointAddress) {
        this.tokenEndpointAddress = tokenEndpointAddress;
    }

    public void setJwkEndpointAddress(String jwkEndpointAddress) {
        this.jwkEndpointAddress = jwkEndpointAddress;
    }

    public void setTokenRevocationEndpointAddress(String tokenRevocationEndpointAddress) {
        this.tokenRevocationEndpointAddress = tokenRevocationEndpointAddress;
    }

    public void setTokenRevocationEndpointNotAvailable(boolean tokenRevocationEndpointNotAvailable) {
        this.tokenRevocationEndpointNotAvailable = tokenRevocationEndpointNotAvailable;
    }

    public boolean isTokenRevocationEndpointNotAvailable() {
        return this.tokenRevocationEndpointNotAvailable;
    }

    public void setJwkEndpointNotAvailable(boolean jwkEndpointNotAvailable) {
        this.jwkEndpointNotAvailable = jwkEndpointNotAvailable;
    }

    public boolean isJwkEndpointNotAvailable() {
        return this.jwkEndpointNotAvailable;
    }

    public boolean isTokenEndpointNotAvailable() {
        return this.tokenEndpointNotAvailable;
    }

    public void setTokenEndpointNotAvailable(boolean tokenEndpointNotAvailable) {
        this.tokenEndpointNotAvailable = tokenEndpointNotAvailable;
    }

    public boolean isDynamicRegistrationEndpointNotAvailable() {
        return this.dynamicRegistrationEndpointNotAvailable;
    }

    public void setDynamicRegistrationEndpointNotAvailable(boolean dynamicRegistrationEndpointNotAvailable) {
        this.dynamicRegistrationEndpointNotAvailable = dynamicRegistrationEndpointNotAvailable;
    }

    public String getDynamicRegistrationEndpointAddress() {
        return this.dynamicRegistrationEndpointAddress;
    }

    public void setDynamicRegistrationEndpointAddress(String dynamicRegistrationEndpointAddress) {
        this.dynamicRegistrationEndpointAddress = dynamicRegistrationEndpointAddress;
    }

    private String buildIssuerUri(String baseUri) {
        URI uri = AuthorizationMetadataService.isAbsoluteUri(this.issuer) ? UriBuilder.fromUri((String)this.issuer).build(new Object[0]) : (this.issuer == null || !this.issuer.startsWith("/") ? URI.create(baseUri) : UriBuilder.fromUri((String)baseUri).path(this.issuer).build(new Object[0]));
        uri = AuthorizationMetadataService.removeDefaultPort(uri);
        if (this.stripPathFromIssuerUri) {
            StringBuilder sb = new StringBuilder();
            sb.append(uri.getScheme()).append("://").append(uri.getHost());
            if (uri.getPort() != -1) {
                sb.append(':').append(uri.getPort());
            }
            return sb.toString();
        }
        return uri.toString();
    }

    private static URI removeDefaultPort(URI uri) {
        if (uri.getPort() == 80 && "http".equals(uri.getScheme()) || uri.getPort() == 443 && "https".equals(uri.getScheme())) {
            try {
                URI newURI = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), -1, uri.getPath(), uri.getQuery(), uri.getFragment());
                return newURI;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Invalid URI " + uri + " : " + e.toString(), e);
            }
        }
        return uri;
    }

    public void setStripPathFromIssuerUri(boolean stripPathFromIssuerUri) {
        this.stripPathFromIssuerUri = stripPathFromIssuerUri;
    }
}

