/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.ClientIdProvider;
import org.apache.cxf.rs.security.oauth2.provider.ClientSecretVerifier;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.AbstractOAuthService;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;

public class AbstractTokenService
extends AbstractOAuthService {
    private boolean canSupportPublicClients;
    private boolean writeCustomErrors;
    private ClientIdProvider clientIdProvider;
    private ClientSecretVerifier clientSecretVerifier;

    protected Client authenticateClientIfNeeded(MultivaluedMap<String, String> params) {
        Client client = null;
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        Principal principal = sc.getUserPrincipal();
        if (principal == null) {
            String clientId = this.retrieveClientId(params);
            if (clientId != null) {
                String clientSecret = (String)params.getFirst((Object)"client_secret");
                if (clientSecret != null) {
                    client = this.getAndValidateClientFromIdAndSecret(clientId, clientSecret, params);
                    this.validateClientAuthenticationMethod(client, "client_secret_post");
                } else if (OAuthUtils.isMutualTls(sc, this.getTlsSessionInfo())) {
                    client = this.getClient(clientId, params);
                    this.checkCertificateBinding(client, this.getTlsSessionInfo());
                    this.validateClientAuthenticationMethod(client, "tls_client_auth");
                } else if (this.canSupportPublicClients) {
                    client = this.getValidClient(clientId, params);
                    if (!this.isValidPublicClient(client, clientId)) {
                        client = null;
                    } else {
                        this.validateClientAuthenticationMethod(client, "none");
                    }
                }
            }
        } else {
            String clientId = this.retrieveClientId(params);
            if (clientId != null) {
                if (clientId.equals(principal.getName())) {
                    client = (Client)this.getMessageContext().get((Object)Client.class.getName());
                }
                if (client == null) {
                    client = this.getClient(clientId, params);
                }
            } else if (principal.getName() != null) {
                client = this.getClient(principal.getName(), params);
            }
        }
        if (client == null && (client = this.getClientFromTLSCertificates(sc, this.getTlsSessionInfo(), params)) == null) {
            client = this.getClientFromBasicAuthScheme(params);
        }
        if (client == null) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected void validateClientAuthenticationMethod(Client c, String authMethod) {
        if (c != null && c.getTokenEndpointAuthMethod() != null && !c.getTokenEndpointAuthMethod().equals(authMethod)) {
            this.reportInvalidClient(new OAuthError("unauthorized_client"));
        }
    }

    protected String retrieveClientId(MultivaluedMap<String, String> params) {
        String clientId = (String)params.getFirst((Object)"client_id");
        if (clientId == null) {
            clientId = (String)this.getMessageContext().get((Object)"client_id");
        }
        if (clientId == null && this.clientIdProvider != null) {
            clientId = this.clientIdProvider.getClientId(this.getMessageContext());
        }
        return clientId;
    }

    protected Client getAndValidateClientFromIdAndSecret(String clientId, String providedClientSecret, MultivaluedMap<String, String> params) {
        Client client = this.getClient(clientId, providedClientSecret, params);
        if (!client.getClientId().equals(clientId)) {
            this.reportInvalidClient();
        }
        if (!client.isConfidential() || !this.isConfidenatialClientSecretValid(client, providedClientSecret)) {
            this.reportInvalidClient();
        }
        return client;
    }

    protected boolean isConfidenatialClientSecretValid(Client client, String providedClientSecret) {
        if (this.clientSecretVerifier != null) {
            return this.clientSecretVerifier.validateClientSecret(client, providedClientSecret);
        }
        return client.getClientSecret() != null && providedClientSecret != null && client.getClientSecret().equals(providedClientSecret);
    }

    protected boolean isValidPublicClient(Client client, String clientId) {
        return this.canSupportPublicClients && !client.isConfidential() && client.getClientSecret() == null;
    }

    protected Client getClientFromBasicAuthScheme(MultivaluedMap<String, String> params) {
        Client client = null;
        String[] userInfo = AuthorizationUtils.getBasicAuthUserInfo(this.getMessageContext());
        if (userInfo != null && userInfo.length == 2) {
            client = this.getAndValidateClientFromIdAndSecret(userInfo[0], userInfo[1], params);
        }
        this.validateClientAuthenticationMethod(client, "client_secret_basic");
        return client;
    }

    protected void checkCertificateBinding(Client client, TLSSessionInfo tlsSessionInfo) {
        String issuerDn;
        String subjectDn = client.getProperties().get("tls_client_auth_subject_dn");
        if (subjectDn == null && client.getApplicationCertificates().isEmpty()) {
            LOG.warning("Client \"" + client.getClientId() + "\" can not be bound to the TLS certificate");
            this.reportInvalidClient();
        }
        X509Certificate cert = OAuthUtils.getRootTLSCertificate(tlsSessionInfo);
        if (subjectDn != null && !subjectDn.equals(OAuthUtils.getSubjectDnFromTLSCertificates(cert))) {
            LOG.warning("Client \"" + client.getClientId() + "\" can not be bound to the TLS certificate");
            this.reportInvalidClient();
        }
        if ((issuerDn = client.getProperties().get("tls_client_auth_root_dn")) != null && !issuerDn.equals(OAuthUtils.getIssuerDnFromTLSCertificates(cert))) {
            LOG.warning("Client \"" + client.getClientId() + "\" can not be bound to the TLS certificate");
            this.reportInvalidClient();
        }
        if (!client.getApplicationCertificates().isEmpty()) {
            this.compareTlsCertificates(tlsSessionInfo, client.getApplicationCertificates());
        }
        OAuthUtils.setCertificateThumbprintConfirmation(this.getMessageContext(), cert);
    }

    private TLSSessionInfo getTlsSessionInfo() {
        return (TLSSessionInfo)this.getMessageContext().get((Object)TLSSessionInfo.class.getName());
    }

    protected Client getClientFromTLSCertificates(SecurityContext sc, TLSSessionInfo tlsSessionInfo, MultivaluedMap<String, String> params) {
        X509Certificate cert;
        String subjectDn;
        Client client = null;
        if (OAuthUtils.isMutualTls(sc, tlsSessionInfo) && !StringUtils.isEmpty((String)(subjectDn = OAuthUtils.getSubjectDnFromTLSCertificates(cert = OAuthUtils.getRootTLSCertificate(tlsSessionInfo))))) {
            client = this.getClient(subjectDn, params);
            this.validateClientAuthenticationMethod(client, "tls_client_auth");
            this.compareTlsCertificates(tlsSessionInfo, client.getApplicationCertificates());
            OAuthUtils.setCertificateThumbprintConfirmation(this.getMessageContext(), cert);
        }
        return client;
    }

    protected void compareTlsCertificates(TLSSessionInfo tlsInfo, List<String> base64EncodedCerts) {
        if (!OAuthUtils.compareTlsCertificates(tlsInfo, base64EncodedCerts)) {
            this.reportInvalidClient();
        }
    }

    protected Response handleException(OAuthServiceException ex, String error) {
        OAuthError customError = ex.getError();
        if (this.writeCustomErrors && customError != null) {
            return this.createErrorResponseFromBean(customError);
        }
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponse(MultivaluedMap<String, String> params, String error) {
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponseFromErrorCode(String error) {
        return this.createErrorResponseFromBean(new OAuthError(error));
    }

    protected Response createErrorResponseFromBean(OAuthError errorBean) {
        return JAXRSUtils.toResponseBuilder((int)400).entity((Object)errorBean).build();
    }

    protected Client getClient(String clientId, MultivaluedMap<String, String> params) {
        return this.getClient(clientId, (String)params.getFirst((Object)"client_secret"), params);
    }

    protected Client getClient(String clientId, String clientSecret, MultivaluedMap<String, String> params) {
        Client client;
        block4: {
            if (clientId == null) {
                this.reportInvalidRequestError("Client ID is null");
                return null;
            }
            client = null;
            try {
                client = this.getValidClient(clientId, clientSecret, params);
            }
            catch (OAuthServiceException ex) {
                LOG.warning("No valid client found for clientId: " + clientId);
                if (ex.getError() == null) break block4;
                this.reportInvalidClient(ex.getError());
                return null;
            }
        }
        if (client == null) {
            LOG.warning("No valid client found for clientId: " + clientId);
            this.reportInvalidClient();
        }
        return client;
    }

    protected void reportInvalidClient() {
        this.reportInvalidClient(new OAuthError("invalid_client"));
    }

    protected void reportInvalidClient(OAuthError error) {
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder((int)401);
        throw ExceptionUtils.toNotAuthorizedException(null, (Response)rb.type(MediaType.APPLICATION_JSON_TYPE).entity((Object)error).build());
    }

    public void setCanSupportPublicClients(boolean support) {
        this.canSupportPublicClients = support;
    }

    public boolean isCanSupportPublicClients() {
        return this.canSupportPublicClients;
    }

    public void setWriteCustomErrors(boolean writeCustomErrors) {
        this.writeCustomErrors = writeCustomErrors;
    }

    public void setClientIdProvider(ClientIdProvider clientIdProvider) {
        this.clientIdProvider = clientIdProvider;
    }

    public void setClientSecretVerifier(ClientSecretVerifier clientSecretVerifier) {
        this.clientSecretVerifier = clientSecretVerifier;
    }
}

