/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.xjc.javadoc;

import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.tools.xjc.reader.xmlschema.Messages;
import com.sun.xml.xsom.XSComponent;
import java.util.Collection;
import org.apache.cxf.xjc.javadoc.PropertyJavadoc;
import org.apache.cxf.xjc.javadoc.XSComponentHelper;
import org.xml.sax.ErrorHandler;

public class JavadocInserter {
    private Outline outline;
    private Options options;

    public JavadocInserter(Outline outline, Options opt, ErrorHandler errorHandler) {
        this.outline = outline;
        this.options = opt;
    }

    public boolean addJavadocs() {
        this.addJavadocsToClasses();
        this.addJavadocsToEnums();
        return false;
    }

    private void addJavadocsToClasses() {
        for (ClassOutline classOutline : this.outline.getClasses()) {
            this.addJavadocs(classOutline);
        }
    }

    private void addJavadocs(ClassOutline classOutline) {
        FieldOutline[] declaredFields;
        for (FieldOutline fieldOutline : declaredFields = classOutline.getDeclaredFields()) {
            PropertyJavadoc propertyJavadoc = new PropertyJavadoc(this.outline.getCodeModel(), this.options, classOutline, fieldOutline);
            propertyJavadoc.addJavadocs();
        }
    }

    private void addJavadocsToEnums() {
        Collection enums = this.outline.getEnums();
        for (EnumOutline enumOutline : enums) {
            this.addJavadoc(enumOutline);
        }
    }

    private void addJavadoc(EnumOutline enumOutline) {
        if (this.isCustomBindingApplied(enumOutline)) {
            return;
        }
        XSComponent schemaComponent = enumOutline.target.getSchemaComponent();
        String documentation = XSComponentHelper.getDocumentation(schemaComponent);
        if (documentation == null || "".equals(documentation)) {
            return;
        }
        enumOutline.clazz.javadoc().add(0, (Object)(documentation + "\n\n"));
    }

    private boolean isCustomBindingApplied(EnumOutline enumOutline) {
        String defaultComment = Messages.format((String)"ClassSelector.JavadocHeading", (Object[])new Object[]{enumOutline.target.getTypeName().getLocalPart()});
        return !enumOutline.target.javadoc.startsWith(defaultComment);
    }
}

