/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;

public class SamlSSOAssertionValidator
extends SamlAssertionValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(SamlSSOAssertionValidator.class);
    private final boolean signedResponse;

    public SamlSSOAssertionValidator(boolean signedResponse) {
        this.signedResponse = signedResponse;
    }

    protected void verifySubjectConfirmationMethod(SamlAssertionWrapper samlAssertion) throws WSSecurityException {
        List methods = samlAssertion.getConfirmationMethods();
        if (methods == null || methods.isEmpty()) {
            if (super.getRequiredSubjectConfirmationMethod() != null) {
                LOG.fine("A required subject confirmation method was not present");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
            if (super.isRequireStandardSubjectConfirmationMethod()) {
                LOG.fine("A standard subject confirmation method was not present");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
        }
        boolean signed = samlAssertion.isSigned();
        boolean requiredMethodFound = false;
        boolean standardMethodFound = false;
        for (String method : methods) {
            if (OpenSAMLUtil.isMethodHolderOfKey((String)method)) {
                if (samlAssertion.getSubjectKeyInfo() == null) {
                    LOG.fine("There is no Subject KeyInfo to match the holder-of-key subject conf method");
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noKeyInSAMLToken");
                }
                if (!signed) {
                    LOG.fine("A holder-of-key assertion must be signed");
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
                }
                standardMethodFound = true;
            }
            if (method == null) continue;
            if (method.equals(super.getRequiredSubjectConfirmationMethod())) {
                requiredMethodFound = true;
            }
            if ("urn:oasis:names:tc:SAML:2.0:cm:bearer".equals(method) || "urn:oasis:names:tc:SAML:1.0:cm:bearer".equals(method)) {
                standardMethodFound = true;
                if (!super.isRequireBearerSignature() || signed || this.signedResponse) continue;
                LOG.fine("A Bearer Assertion was not signed");
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
            }
            if (!"urn:oasis:names:tc:SAML:2.0:cm:sender-vouches".equals(method) && !"urn:oasis:names:tc:SAML:1.0:cm:sender-vouches".equals(method)) continue;
            standardMethodFound = true;
        }
        if (!requiredMethodFound && super.getRequiredSubjectConfirmationMethod() != null) {
            LOG.fine("A required subject confirmation method was not present");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
        if (!standardMethodFound && super.isRequireStandardSubjectConfirmationMethod()) {
            LOG.fine("A standard subject confirmation method was not present");
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "invalidSAMLsecurity");
        }
    }
}

