/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso;

import java.util.Collections;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.sso.AuthnRequestBuilder;
import org.apache.cxf.rs.security.saml.sso.SamlpRequestComponentBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;

public class DefaultAuthnRequestBuilder
implements AuthnRequestBuilder {
    private boolean forceAuthn;
    private boolean isPassive;
    private String protocolBinding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private String nameIDFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";

    @Override
    public AuthnRequest createAuthnRequest(Message message, String issuerId, String assertionConsumerServiceAddress) throws Exception {
        Issuer issuer = SamlpRequestComponentBuilder.createIssuer(issuerId);
        NameIDPolicy nameIDPolicy = SamlpRequestComponentBuilder.createNameIDPolicy(true, this.nameIDFormat, issuerId);
        AuthnContextClassRef authnCtxClassRef = SamlpRequestComponentBuilder.createAuthnCtxClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        RequestedAuthnContext authnCtx = SamlpRequestComponentBuilder.createRequestedAuthnCtxPolicy(AuthnContextComparisonTypeEnumeration.EXACT, Collections.singletonList(authnCtxClassRef), null);
        return SamlpRequestComponentBuilder.createAuthnRequest(assertionConsumerServiceAddress, this.forceAuthn, this.isPassive, this.protocolBinding, SAMLVersion.VERSION_20, issuer, nameIDPolicy, authnCtx);
    }

    public boolean isForceAuthn() {
        return this.forceAuthn;
    }

    public void setForceAuthn(boolean forceAuthn) {
        this.forceAuthn = forceAuthn;
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public void setPassive(boolean isPassive) {
        this.isPassive = isPassive;
    }

    public String getProtocolBinding() {
        return this.protocolBinding;
    }

    public void setProtocolBinding(String protocolBinding) {
        this.protocolBinding = protocolBinding;
    }

    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    public void setNameIDFormat(String nameIDFormat) {
        this.nameIDFormat = nameIDFormat;
    }
}

