/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwt;

import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;

public class JwtToken {
    private JwsHeaders jwsHeaders;
    private JweHeaders jweHeaders;
    private JwtClaims claims;

    public JwtToken(JwtClaims claims) {
        this(new JwsHeaders(){}, new JweHeaders(){}, claims);
    }

    public JwtToken(JwsHeaders jwsHeaders, JwtClaims claims) {
        this(jwsHeaders, new JweHeaders(){}, claims);
    }

    public JwtToken(JweHeaders jweHeaders, JwtClaims claims) {
        this(new JwsHeaders(){}, jweHeaders, claims);
    }

    public JwtToken(JwsHeaders jwsHeaders, JweHeaders jweHeaders, JwtClaims claims) {
        this.jwsHeaders = jwsHeaders;
        this.jweHeaders = jweHeaders;
        this.claims = claims;
    }

    public JwsHeaders getJwsHeaders() {
        return this.jwsHeaders;
    }

    public JweHeaders getJweHeaders() {
        return this.jweHeaders;
    }

    public JwtClaims getClaims() {
        return this.claims;
    }

    public Object getJwsHeader(String name) {
        return this.jwsHeaders.getHeader(name);
    }

    public Object getJweHeader(String name) {
        return this.jweHeaders.getHeader(name);
    }

    public Object getClaim(String name) {
        return this.claims.getClaim(name);
    }

    public int hashCode() {
        return this.jwsHeaders.hashCode() + 37 * this.claims.hashCode() + 37 * this.jweHeaders.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JwtToken && ((JwtToken)obj).jwsHeaders.equals((Object)this.jwsHeaders) && ((JwtToken)obj).jweHeaders.equals((Object)this.jweHeaders) && ((JwtToken)obj).claims.equals((Object)this.claims);
    }
}

