/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.provider;

import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.request.KeyRequirements;
import org.apache.cxf.sts.request.ReceivedKey;
import org.apache.cxf.sts.request.ReceivedToken;
import org.apache.cxf.sts.request.TokenRequirements;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.provider.SubjectProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.UsernameTokenPrincipal;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSubjectProvider
implements SubjectProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(DefaultSubjectProvider.class);
    private String subjectNameQualifier = "http://cxf.apache.org/sts";
    private String subjectNameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";

    public void setSubjectNameQualifier(String subjectNameQualifier) {
        this.subjectNameQualifier = subjectNameQualifier;
        LOG.fine("Setting Subject Name Qualifier: " + subjectNameQualifier);
    }

    public void setSubjectNameIDFormat(String subjectNameIDFormat) {
        this.subjectNameIDFormat = subjectNameIDFormat;
        LOG.fine("Setting Subject Name format: " + subjectNameIDFormat);
    }

    @Override
    public SubjectBean getSubject(TokenProviderParameters providerParameters, Document doc, byte[] secret) {
        Principal principal = this.getPrincipal(providerParameters);
        if (principal == null) {
            LOG.fine("Error in getting principal");
            throw new STSException("Error in getting principal", STSException.REQUEST_FAILED);
        }
        SubjectBean subjectBean = this.createSubjectBean(principal, providerParameters);
        KeyInfoBean keyInfo = this.createKeyInfo(providerParameters, doc, secret);
        subjectBean.setKeyInfo(keyInfo);
        return subjectBean;
    }

    protected Principal getPrincipal(TokenProviderParameters providerParameters) {
        Principal principal = null;
        if (providerParameters.getTokenRequirements().getOnBehalfOf() != null) {
            ReceivedToken receivedToken = providerParameters.getTokenRequirements().getOnBehalfOf();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else if (providerParameters.getTokenRequirements().getValidateTarget() != null) {
            ReceivedToken receivedToken = providerParameters.getTokenRequirements().getValidateTarget();
            if (receivedToken.getState().equals((Object)ReceivedToken.STATE.VALID)) {
                principal = receivedToken.getPrincipal();
            }
        } else {
            principal = providerParameters.getPrincipal();
        }
        return principal;
    }

    protected SubjectBean createSubjectBean(Principal principal, TokenProviderParameters providerParameters) {
        TokenRequirements tokenRequirements = providerParameters.getTokenRequirements();
        KeyRequirements keyRequirements = providerParameters.getKeyRequirements();
        String tokenType = tokenRequirements.getTokenType();
        String keyType = keyRequirements.getKeyType();
        String confirmationMethod = this.getSubjectConfirmationMethod(tokenType, keyType);
        String subjectName = principal.getName();
        String localSubjectNameIDFormat = this.subjectNameIDFormat;
        if ("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(localSubjectNameIDFormat) && principal instanceof X500Principal) {
            try {
                LdapName ln = new LdapName(principal.getName());
                for (Rdn rdn : ln.getRdns()) {
                    if (!"CN".equalsIgnoreCase(rdn.getType()) || !(rdn.getValue() instanceof String)) continue;
                    subjectName = (String)rdn.getValue();
                }
            }
            catch (Throwable ex) {
                subjectName = principal.getName();
            }
        } else if (!"urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(localSubjectNameIDFormat)) {
            if (principal instanceof UsernameTokenPrincipal) {
                localSubjectNameIDFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:persistent";
            } else if (principal instanceof X500Principal) {
                localSubjectNameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
            } else if (principal instanceof KerberosPrincipal) {
                localSubjectNameIDFormat = "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos";
            } else if (localSubjectNameIDFormat == null) {
                localSubjectNameIDFormat = "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified";
            }
        }
        SubjectBean subjectBean = new SubjectBean(subjectName, this.subjectNameQualifier, confirmationMethod);
        LOG.fine("Creating new subject with principal name: " + principal.getName());
        subjectBean.setSubjectNameIDFormat(localSubjectNameIDFormat);
        return subjectBean;
    }

    protected KeyInfoBean createKeyInfo(TokenProviderParameters providerParameters, Document doc, byte[] secret) {
        KeyRequirements keyRequirements = providerParameters.getKeyRequirements();
        STSPropertiesMBean stsProperties = providerParameters.getStsProperties();
        String keyType = keyRequirements.getKeyType();
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType)) {
            Crypto crypto = stsProperties.getEncryptionCrypto();
            EncryptionProperties encryptionProperties = providerParameters.getEncryptionProperties();
            String encryptionName = encryptionProperties.getEncryptionName();
            if (encryptionName == null) {
                encryptionName = stsProperties.getEncryptionUsername();
            }
            if (encryptionName == null) {
                LOG.fine("No encryption Name is configured for Symmetric KeyType");
                throw new STSException("No Encryption Name is configured", STSException.REQUEST_FAILED);
            }
            CryptoType cryptoType = null;
            if ("useEndpointAsCertAlias".equals(encryptionName)) {
                if (providerParameters.getAppliesToAddress() == null) {
                    throw new STSException("AppliesTo is not initilaized for encryption name useEndpointAsCertAlias");
                }
                cryptoType = new CryptoType(CryptoType.TYPE.ENDPOINT);
                cryptoType.setEndpoint(providerParameters.getAppliesToAddress());
            } else {
                cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
                cryptoType.setAlias(encryptionName);
            }
            try {
                X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
                if (certs == null || certs.length == 0) {
                    throw new STSException("Encryption certificate is not found for alias: " + encryptionName);
                }
                KeyInfoBean keyInfo = DefaultSubjectProvider.createEncryptedKeyKeyInfo(certs[0], secret, doc, encryptionProperties, crypto);
                return keyInfo;
            }
            catch (WSSecurityException ex) {
                LOG.log(Level.WARNING, "", ex);
                throw new STSException(ex.getMessage(), (Throwable)ex);
            }
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            ReceivedKey receivedKey = keyRequirements.getReceivedKey();
            if (stsProperties.isValidateUseKey() && stsProperties.getSignatureCrypto() != null) {
                if (receivedKey.getX509Cert() != null) {
                    try {
                        List constraints = Collections.emptyList();
                        stsProperties.getSignatureCrypto().verifyTrust(new X509Certificate[]{receivedKey.getX509Cert()}, false, constraints);
                    }
                    catch (WSSecurityException e) {
                        LOG.log(Level.FINE, "Error in trust validation of UseKey: ", e);
                        throw new STSException("Error in trust validation of UseKey", STSException.REQUEST_FAILED);
                    }
                }
                if (receivedKey.getPublicKey() != null) {
                    try {
                        stsProperties.getSignatureCrypto().verifyTrust(receivedKey.getPublicKey());
                    }
                    catch (WSSecurityException e) {
                        LOG.log(Level.FINE, "Error in trust validation of UseKey: ", e);
                        throw new STSException("Error in trust validation of UseKey", STSException.REQUEST_FAILED);
                    }
                }
            }
            return DefaultSubjectProvider.createPublicKeyKeyInfo(receivedKey.getX509Cert(), receivedKey.getPublicKey());
        }
        return null;
    }

    protected String getSubjectConfirmationMethod(String tokenType, String keyType) {
        if ("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
                return "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
            }
            return "urn:oasis:names:tc:SAML:2.0:cm:bearer";
        }
        if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey".equals(keyType) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512/PublicKey".equals(keyType)) {
            return "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
        }
        return "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    }

    protected static KeyInfoBean createPublicKeyKeyInfo(X509Certificate certificate, PublicKey publicKey) {
        KeyInfoBean keyInfo = new KeyInfoBean();
        if (certificate != null) {
            keyInfo.setCertificate(certificate);
            keyInfo.setCertIdentifer(KeyInfoBean.CERT_IDENTIFIER.X509_CERT);
        } else if (publicKey != null) {
            keyInfo.setPublicKey(publicKey);
            keyInfo.setCertIdentifer(KeyInfoBean.CERT_IDENTIFIER.KEY_VALUE);
        }
        return keyInfo;
    }

    protected static KeyInfoBean createEncryptedKeyKeyInfo(X509Certificate certificate, byte[] secret, Document doc, EncryptionProperties encryptionProperties, Crypto encryptionCrypto) throws WSSecurityException {
        KeyInfoBean keyInfo = new KeyInfoBean();
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey();
        encrKey.setKeyIdentifierType(encryptionProperties.getKeyIdentifierType());
        encrKey.setEphemeralKey(secret);
        encrKey.setSymmetricEncAlgorithm(encryptionProperties.getEncryptionAlgorithm());
        encrKey.setUseThisCert(certificate);
        encrKey.setKeyEncAlgo(encryptionProperties.getKeyWrapAlgorithm());
        encrKey.prepare(doc, encryptionCrypto);
        Element encryptedKeyElement = encrKey.getEncryptedKeyElement();
        Element keyInfoElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
        keyInfoElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
        keyInfoElement.appendChild(encryptedKeyElement);
        keyInfo.setElement(keyInfoElement);
        return keyInfo;
    }
}

