/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.sts.token.realm.RelationshipResolver;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;

public class StaticSTSProperties
implements STSPropertiesMBean {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticSTSProperties.class);
    private CallbackHandler callbackHandler;
    private String callbackHandlerClass;
    private Crypto signatureCrypto;
    private Object signatureCryptoProperties;
    private String signatureUsername;
    private Crypto encryptionCrypto;
    private Object encryptionCryptoProperties;
    private String encryptionUsername;
    private String issuer;
    private SignatureProperties signatureProperties = new SignatureProperties();
    private EncryptionProperties encryptionProperties = new EncryptionProperties();
    private RealmParser realmParser;
    private IdentityMapper identityMapper;
    private List<Relationship> relationships;
    private RelationshipResolver relationshipResolver;
    private SAMLRealmCodec samlRealmCodec;
    private Bus bus;
    private boolean validateUseKey = true;

    @Override
    public void configureProperties() throws STSException {
        if (this.signatureCrypto == null && this.signatureCryptoProperties != null) {
            Properties sigProperties = StaticSTSProperties.getProps(this.signatureCryptoProperties, this.bus);
            if (sigProperties == null) {
                LOG.fine("Cannot load signature properties using: " + this.signatureCryptoProperties);
                throw new STSException("Configuration error: cannot load signature properties");
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the signature Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        if (this.encryptionCrypto == null && this.encryptionCryptoProperties != null) {
            Properties encrProperties = StaticSTSProperties.getProps(this.encryptionCryptoProperties, this.bus);
            if (encrProperties == null) {
                LOG.fine("Cannot load encryption properties using: " + this.encryptionCryptoProperties);
                throw new STSException("Configuration error: cannot load encryption properties");
            }
            try {
                this.encryptionCrypto = CryptoFactory.getInstance((Properties)encrProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the encryption Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            this.callbackHandler = this.getCallbackHandler(this.callbackHandlerClass);
            if (this.callbackHandler == null) {
                LOG.fine("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                throw new STSException("Configuration error: cannot load callback handler");
            }
        }
        WSSConfig.init();
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        LOG.fine("Setting callbackHandler: " + callbackHandler);
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setSignatureCrypto(Crypto signatureCrypto) {
        this.signatureCrypto = signatureCrypto;
    }

    @Deprecated
    public void setSignaturePropertiesFile(String signaturePropertiesFile) {
        this.setSignatureCryptoProperties(signaturePropertiesFile);
    }

    public void setSignatureCryptoProperties(Object signatureCryptoProperties) {
        this.signatureCryptoProperties = signatureCryptoProperties;
        LOG.fine("Setting signature crypto properties: " + signatureCryptoProperties);
    }

    @Override
    public Crypto getSignatureCrypto() {
        return this.signatureCrypto;
    }

    @Override
    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
        LOG.fine("Setting signatureUsername: " + signatureUsername);
    }

    @Override
    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    @Override
    public void setEncryptionCrypto(Crypto encryptionCrypto) {
        this.encryptionCrypto = encryptionCrypto;
    }

    @Deprecated
    public void setEncryptionPropertiesFile(String encryptionPropertiesFile) {
        this.setEncryptionCryptoProperties(encryptionPropertiesFile);
    }

    public void setEncryptionCryptoProperties(Object encryptionCryptoProperties) {
        this.encryptionCryptoProperties = encryptionCryptoProperties;
        LOG.fine("Setting encryptionProperties: " + encryptionCryptoProperties);
    }

    @Override
    public Crypto getEncryptionCrypto() {
        return this.encryptionCrypto;
    }

    @Override
    public void setEncryptionUsername(String encryptionUsername) {
        this.encryptionUsername = encryptionUsername;
        LOG.fine("Setting encryptionUsername: " + encryptionUsername);
    }

    @Override
    public String getEncryptionUsername() {
        return this.encryptionUsername;
    }

    @Override
    public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
    }

    @Override
    public EncryptionProperties getEncryptionProperties() {
        return this.encryptionProperties;
    }

    @Override
    public void setIssuer(String issuer) {
        this.issuer = issuer;
        LOG.fine("Setting issuer: " + issuer);
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public void setSignatureProperties(SignatureProperties signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    @Override
    public SignatureProperties getSignatureProperties() {
        return this.signatureProperties;
    }

    @Override
    public void setRealmParser(RealmParser realmParser) {
        this.realmParser = realmParser;
    }

    @Override
    public RealmParser getRealmParser() {
        return this.realmParser;
    }

    @Override
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    @Override
    public IdentityMapper getIdentityMapper() {
        return this.identityMapper;
    }

    private static Properties getProps(Object o, Bus bus) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            URL url = null;
            Bus b = bus;
            if (b == null) {
                b = BusFactory.getThreadDefaultBus();
            }
            ResourceManager rm = (ResourceManager)b.getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), StaticSTSProperties.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                if (url != null) {
                    properties = new Properties();
                    InputStream ins = url.openStream();
                    properties.load(ins);
                    ins.close();
                }
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        } else if (o instanceof URL) {
            properties = new Properties();
            try {
                InputStream ins = ((URL)o).openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                LOG.fine(e.getMessage());
                properties = null;
            }
        }
        return properties;
    }

    private CallbackHandler getCallbackHandler(Object o) {
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), this.getClass()).newInstance();
            }
            catch (Exception e) {
                LOG.fine(e.getMessage());
                handler = null;
            }
        }
        return handler;
    }

    @Override
    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
        this.relationshipResolver = new RelationshipResolver(this.relationships);
    }

    @Override
    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    @Override
    public RelationshipResolver getRelationshipResolver() {
        return this.relationshipResolver;
    }

    @Override
    public SAMLRealmCodec getSamlRealmCodec() {
        return this.samlRealmCodec;
    }

    @Override
    public void setSamlRealmCodec(SAMLRealmCodec samlRealmCodec) {
        this.samlRealmCodec = samlRealmCodec;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @Override
    public boolean isValidateUseKey() {
        return this.validateUseKey;
    }

    @Override
    public void setValidateUseKey(boolean validateUseKey) {
        this.validateUseKey = validateUseKey;
    }
}

