/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.LicenseFamilySetFactory;

public class LicenseSetFactory {
    private final SortedSet<ILicense> licenses;
    private final Collection<String> approvedLicenses;

    public LicenseSetFactory(SortedSet<ILicense> licenses, Collection<String> approvedLicenses) {
        this.licenses = licenses;
        this.approvedLicenses = approvedLicenses;
    }

    public static SortedSet<ILicense> emptyLicenseSet() {
        return new TreeSet<ILicense>(ILicense.getComparator());
    }

    private static SortedSet<ILicenseFamily> extractFamily(Collection<ILicense> licenses) {
        TreeSet<ILicenseFamily> result = new TreeSet<ILicenseFamily>();
        licenses.stream().map(ILicense::getLicenseFamily).forEach(result::add);
        return result;
    }

    public SortedSet<ILicense> getLicenses(LicenseFilter filter) {
        switch (filter) {
            case all: {
                return Collections.unmodifiableSortedSet(this.licenses);
            }
            case approved: {
                SortedSet<ILicense> result = LicenseSetFactory.emptyLicenseSet();
                this.licenses.stream().filter(x -> this.approvedLicenses.contains(x.getLicenseFamily().getFamilyCategory())).forEach(result::add);
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<ILicenseFamily> getLicenseFamilies(LicenseFilter filter) {
        switch (filter) {
            case all: {
                return LicenseSetFactory.extractFamily(this.licenses);
            }
            case approved: {
                SortedSet<ILicenseFamily> result = LicenseFamilySetFactory.emptyLicenseFamilySet();
                this.licenses.stream().map(ILicense::getLicenseFamily).filter(x -> this.approvedLicenses.contains(x.getFamilyCategory())).forEach(result::add);
                return result;
            }
        }
        return Collections.emptySortedSet();
    }

    public SortedSet<String> getLicenseFamilyIds(LicenseFilter filter) {
        TreeSet<String> result = new TreeSet<String>();
        switch (filter) {
            case all: {
                this.licenses.stream().map(x -> x.getLicenseFamily().getFamilyCategory()).forEach(result::add);
                break;
            }
            case approved: {
                result.addAll(this.approvedLicenses);
                break;
            }
        }
        return result;
    }

    public static ILicense search(final String licenseId, SortedSet<ILicense> licenses) {
        final ILicenseFamily searchFamily = ILicenseFamily.builder().setLicenseFamilyCategory(licenseId).setLicenseFamilyName("searching proxy").build();
        ILicense target = new ILicense(){

            @Override
            public String getId() {
                return licenseId;
            }

            @Override
            public void reset() {
            }

            @Override
            public IHeaderMatcher.State matches(String line) {
                return IHeaderMatcher.State.f;
            }

            @Override
            public int compareTo(ILicense arg0) {
                return searchFamily.compareTo(arg0.getLicenseFamily());
            }

            @Override
            public ILicenseFamily getLicenseFamily() {
                return searchFamily;
            }

            @Override
            public String getNotes() {
                return null;
            }

            @Override
            public String derivedFrom() {
                return null;
            }

            @Override
            public String getName() {
                return searchFamily.getFamilyName();
            }

            @Override
            public IHeaderMatcher.State finalizeState() {
                return IHeaderMatcher.State.f;
            }

            @Override
            public IHeaderMatcher.State currentState() {
                return IHeaderMatcher.State.f;
            }
        };
        return LicenseSetFactory.search(target, licenses);
    }

    public static ILicense search(ILicense target, SortedSet<ILicense> licenses) {
        SortedSet<ILicense> part = licenses.tailSet(target);
        return !part.isEmpty() && part.first().compareTo(target) == 0 ? part.first() : null;
    }

    public static enum LicenseFilter {
        all,
        approved,
        none;

    }
}

