/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.document.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.document.impl.DocumentImplUtils;

public class ArchiveEntryDocument
implements Document {
    private final byte[] contents;
    private final String name;
    private final MetaData metaData = new MetaData();

    public ArchiveEntryDocument(File file, byte[] contents) throws RatException {
        this.name = DocumentImplUtils.toName(file);
        this.contents = contents;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream inputStream() throws IOException {
        return new ByteArrayInputStream(this.contents);
    }

    @Override
    public boolean isComposite() {
        return DocumentImplUtils.isZipStream(new ByteArrayInputStream(this.contents));
    }

    @Override
    public Reader reader() throws IOException {
        return new InputStreamReader(new ByteArrayInputStream(this.contents));
    }

    public String toString() {
        return "TarEntryDocument ( name = " + this.name + " metaData = " + this.metaData + "  )";
    }
}

