/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration.builders;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.FullTextMatcher;
import org.apache.rat.analysis.matchers.SimpleTextMatcher;
import org.apache.rat.configuration.builders.AbstractBuilder;
import org.apache.rat.configuration.builders.TextCaptureBuilder;

public class TextBuilder
extends AbstractBuilder
implements TextCaptureBuilder {
    private String text;

    public TextBuilder setText(String text) {
        Objects.requireNonNull(text, "text may not be null");
        this.text = text;
        return this;
    }

    @Override
    public IHeaderMatcher build() {
        if (StringUtils.isBlank(this.text)) {
            throw new ConfigurationException("text value is required");
        }
        boolean complex = this.text.contains(" ") | this.text.contains("\\t") | this.text.contains("\\n") | this.text.contains("\\r") | this.text.contains("\\f") | this.text.contains("\\v");
        return complex ? new FullTextMatcher(this.getId(), this.text) : new SimpleTextMatcher(this.getId(), this.text);
    }

    @Override
    public String toString() {
        if (this.text.length() > 20) {
            return "TextBuilder: " + this.text.substring(0, 20) + "...";
        }
        return "TextBuilder: " + this.text;
    }
}

