/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.util.Collection;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.DocumentHeaderAnalyser;
import org.apache.rat.analysis.LicenseCollection;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.document.impl.guesser.ArchiveGuesser;
import org.apache.rat.document.impl.guesser.BinaryGuesser;
import org.apache.rat.document.impl.guesser.NoteGuesser;
import org.apache.rat.license.ILicense;

public class DefaultAnalyserFactory {
    public static IDocumentAnalyser createDefaultAnalyser(Collection<ILicense> licenses) {
        if (licenses.isEmpty()) {
            throw new ConfigurationException("At least one license must be defined");
        }
        return new DefaultAnalyser(new LicenseCollection(licenses));
    }

    private static final class DefaultAnalyser
    implements IDocumentAnalyser {
        private final ILicense license;

        public DefaultAnalyser(ILicense license) {
            this.license = license;
        }

        @Override
        public void analyse(Document document) throws RatDocumentAnalysisException {
            MetaData.Datum documentCategory;
            if (NoteGuesser.isNote(document)) {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_NOTICE;
            } else if (ArchiveGuesser.isArchive(document)) {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_ARCHIVE;
            } else if (BinaryGuesser.isBinary(document)) {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_BINARY;
            } else {
                documentCategory = MetaData.RAT_DOCUMENT_CATEGORY_DATUM_STANDARD;
                DocumentHeaderAnalyser headerAnalyser = new DocumentHeaderAnalyser(this.license);
                headerAnalyser.analyse(document);
            }
            document.getMetaData().set(documentCategory);
        }
    }
}

