/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim.util;

import java.util.List;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.report.RatReport;

public class ClaimReporterMultiplexer
implements RatReport {
    private final IDocumentAnalyser analyser;
    private final List<? extends RatReport> reporters;

    public ClaimReporterMultiplexer(IDocumentAnalyser pAnalyser, List<? extends RatReport> reporters) {
        this.analyser = pAnalyser;
        this.reporters = reporters;
    }

    @Override
    public void report(Document document) throws RatException {
        if (this.analyser != null) {
            try {
                this.analyser.analyse(document);
            }
            catch (RatDocumentAnalysisException e) {
                throw new RatException(e.getMessage(), e);
            }
        }
        for (RatReport ratReport : this.reporters) {
            ratReport.report(document);
        }
    }

    @Override
    public void startReport() throws RatException {
        for (RatReport ratReport : this.reporters) {
            ratReport.startReport();
        }
    }

    @Override
    public void endReport() throws RatException {
        for (RatReport ratReport : this.reporters) {
            ratReport.endReport();
        }
    }
}

