/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.ILicenseFamily;

class SimpleLicense
implements ILicense {
    private ILicenseFamily family;
    private IHeaderMatcher matcher;
    private String derivedFrom;
    private String notes;
    private String name;
    private String id;

    SimpleLicense(ILicenseFamily family, IHeaderMatcher matcher, String derivedFrom, String notes, String name, String id) {
        Objects.requireNonNull(matcher, "Matcher must not be null");
        Objects.requireNonNull(family, "Family must not be null");
        this.family = family;
        this.matcher = matcher;
        this.derivedFrom = derivedFrom;
        this.notes = notes;
        this.name = StringUtils.defaultIfBlank(name, family.getFamilyName());
        this.id = StringUtils.defaultIfBlank(id, family.getFamilyCategory().trim());
    }

    public String toString() {
        return String.format("%s:%s", this.getId(), this.getName());
    }

    public ILicenseFamily getFamily() {
        return this.family;
    }

    public void setFamily(ILicenseFamily family) {
        this.family = family;
    }

    public IHeaderMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(IHeaderMatcher matcher) {
        this.matcher = matcher;
    }

    public void setDerivedFrom(String derivedFrom) {
        this.derivedFrom = derivedFrom;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void reset() {
        this.matcher.reset();
    }

    @Override
    public IHeaderMatcher.State matches(String line) {
        return this.matcher.matches(line);
    }

    @Override
    public IHeaderMatcher.State finalizeState() {
        return this.matcher.finalizeState();
    }

    @Override
    public IHeaderMatcher.State currentState() {
        return this.matcher.currentState();
    }

    @Override
    public ILicenseFamily getLicenseFamily() {
        return this.family;
    }

    @Override
    public int compareTo(ILicense other) {
        return ILicense.getComparator().compare(this, other);
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String derivedFrom() {
        return this.derivedFrom;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

