/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.anttasks;

import java.io.File;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rat.ConfigurationException;
import org.apache.rat.Defaults;
import org.apache.rat.ReportConfiguration;
import org.apache.rat.Reporter;
import org.apache.rat.anttasks.Family;
import org.apache.rat.anttasks.License;
import org.apache.rat.anttasks.ResourceCollectionContainer;
import org.apache.rat.configuration.Format;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.license.ILicense;
import org.apache.rat.license.LicenseSetFactory;
import org.apache.rat.utils.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Union;

public class Report
extends Task {
    private final Defaults.Builder defaultsBuilder;
    private final ReportConfiguration configuration;
    private final List<License> licenses = new ArrayList<License>();
    private final List<Family> families = new ArrayList<Family>();
    private Union nestedResources;

    public Report() {
        this.configuration = new ReportConfiguration(new Logger());
        this.configuration.setOut(() -> new LogOutputStream((Task)this, 2));
        this.defaultsBuilder = Defaults.builder();
    }

    public void add(ResourceCollection rc) {
        if (this.nestedResources == null) {
            this.nestedResources = new Union();
        }
        this.nestedResources.add(rc);
    }

    public void setInputFileFilter(FilenameFilter inputFileFilter) {
        this.configuration.setInputFileFilter(inputFileFilter);
    }

    public void setReportFile(File reportFile) {
        this.configuration.setOut(reportFile);
    }

    public void addLicense(License lic) {
        this.licenses.add(lic);
    }

    public void addFamily(Family family) {
        this.families.add(family);
    }

    @Deprecated
    public void addStylesheet(Resource styleSheet) {
        this.addStyleSheet(styleSheet);
    }

    public void addStyleSheet(Resource styleSheet) {
        this.configuration.setStyleSheet(() -> ((Resource)styleSheet).getInputStream());
        this.configuration.setStyleReport(true);
    }

    public void setStyleReport(boolean styleReport) {
        this.configuration.setStyleReport(styleReport);
    }

    @Deprecated
    public void setFormat(String style) {
        this.setStyleReport("styled".equalsIgnoreCase(style));
    }

    public void setLicenses(File fileName) {
        try {
            LicenseReader lReader;
            URL url = fileName.toURI().toURL();
            Format fmt = Format.fromFile(fileName);
            MatcherReader mReader = fmt.matcherReader();
            if (mReader != null) {
                mReader.addMatchers(url);
            }
            if ((lReader = fmt.licenseReader()) != null) {
                lReader.addLicenses(url);
                this.configuration.addLicenses(lReader.readLicenses());
                this.configuration.addApprovedLicenseCategories(lReader.approvedLicenseId());
            }
        }
        catch (MalformedURLException e) {
            throw new BuildException("Can not read license file " + fileName, (Throwable)e);
        }
    }

    public void setUseDefaultLicenses(boolean useDefaultLicenses) {
        if (!useDefaultLicenses) {
            this.defaultsBuilder.noDefault();
        }
    }

    public void setAddApprovedLicense(String familyCategory) {
        this.configuration.addApprovedLicenseCategory(familyCategory);
    }

    public void addAddApprovedLicense(String familyCategory) {
        this.configuration.addApprovedLicenseCategory(familyCategory);
    }

    public void setRemoveApprovedLicense(String familyCategory) {
        this.configuration.removeApprovedLicenseCategory(familyCategory);
    }

    public void setRemoveApprovedLicense(String[] familyCategory) {
        this.configuration.removeApprovedLicenseCategories(Arrays.asList(familyCategory));
    }

    public void setCopyrightMessage(String copyrightMessage) {
        this.configuration.setCopyrightMessage(copyrightMessage);
    }

    public void setAddLicenseHeaders(AddLicenseHeaders setting) {
        this.configuration.setAddLicenseHeaders(setting.getNative());
    }

    public void setAddDefaultDefinitions(File fileName) {
        try {
            this.defaultsBuilder.add(fileName);
        }
        catch (MalformedURLException e) {
            throw new BuildException("Can not open additional default definitions: " + fileName.toString(), (Throwable)e);
        }
    }

    public ReportConfiguration getConfiguration() {
        Defaults defaults = this.defaultsBuilder.build();
        this.configuration.setFrom(defaults);
        this.configuration.setReportable(new ResourceCollectionContainer((ResourceCollection)this.nestedResources));
        this.families.stream().map(Family::build).forEach(this.configuration::addFamily);
        this.licenses.stream().map(License::asBuilder).forEach(l -> this.configuration.addApprovedLicenseCategory(this.configuration.addLicense((ILicense.Builder)l).getLicenseFamily()));
        return this.configuration;
    }

    public void execute() {
        try {
            Reporter.report(this.validate(this.getConfiguration()));
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception ioex) {
            throw new BuildException((Throwable)ioex);
        }
    }

    private ReportConfiguration validate(ReportConfiguration cfg) {
        try {
            cfg.validate((String s) -> this.log((String)s, 1));
        }
        catch (ConfigurationException e) {
            throw new BuildException(e.getMessage(), e.getCause());
        }
        if (this.nestedResources == null) {
            throw new BuildException("You must specify at least one file to create the report for.");
        }
        return cfg;
    }

    private class Logger
    implements Log {
        private Logger() {
        }

        private void write(int level, String msg) {
            try (PrintWriter pw = new PrintWriter((OutputStream)new LogOutputStream((Task)Report.this, level));){
                pw.write(msg);
            }
        }

        @Override
        public void log(Log.Level level, String msg) {
            switch (level) {
                case DEBUG: {
                    this.write(4, msg);
                    break;
                }
                case INFO: {
                    this.write(2, msg);
                    break;
                }
                case WARN: {
                    this.write(1, msg);
                    break;
                }
                case ERROR: {
                    this.write(0, msg);
                    break;
                }
                case OFF: {
                    break;
                }
            }
        }
    }

    public static class AddLicenseHeaders
    extends EnumeratedAttribute {
        static final String TRUE = "true";
        static final String FALSE = "false";
        static final String FORCED = "forced";

        public AddLicenseHeaders() {
        }

        public AddLicenseHeaders(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return new String[]{TRUE, FALSE, FORCED};
        }

        public org.apache.rat.config.AddLicenseHeaders getNative() {
            return org.apache.rat.config.AddLicenseHeaders.valueOf(this.getValue().toUpperCase());
        }
    }

    public static class ApprovalFilter
    extends EnumeratedAttribute {
        public ApprovalFilter() {
        }

        public ApprovalFilter(String s) {
            this.setValue(s);
        }

        public String[] getValues() {
            return Arrays.stream(LicenseSetFactory.LicenseFilter.values()).map(Enum::name).collect(Collectors.toList()).toArray(new String[LicenseSetFactory.LicenseFilter.values().length]);
        }

        public LicenseSetFactory.LicenseFilter internalFilter() {
            return LicenseSetFactory.LicenseFilter.valueOf(this.getValue());
        }
    }
}

