/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.Locale;
import java.util.Objects;
import org.apache.rat.analysis.matchers.AbstractSimpleMatcher;

public class FullTextMatcher
extends AbstractSimpleMatcher {
    private static final int DEFAULT_INITIAL_LINE_LENGTH = 20;
    private final String fullText;
    private final String firstLine;
    private boolean seenFirstLine;
    private final StringBuilder buffer = new StringBuilder();

    public FullTextMatcher(String fullText) {
        this(null, fullText);
    }

    public FullTextMatcher(String id, String fullText) {
        super(id);
        Objects.requireNonNull(fullText, "fullText may not be null");
        int offset = fullText.indexOf(10);
        if (offset == -1) {
            offset = Math.min(20, fullText.length());
        }
        this.firstLine = FullTextMatcher.prune(fullText.substring(0, offset)).toLowerCase(Locale.ENGLISH);
        this.fullText = FullTextMatcher.prune(fullText).toLowerCase(Locale.ENGLISH);
        this.buffer.setLength(0);
        this.seenFirstLine = false;
    }

    public static String prune(String text) {
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char at = text.charAt(i);
            if (!Character.isLetterOrDigit(at)) continue;
            buffer.append(at);
        }
        return buffer.toString();
    }

    @Override
    public boolean doMatch(String line) {
        int offset;
        String inputToMatch = FullTextMatcher.prune(line).toLowerCase(Locale.ENGLISH);
        if (this.seenFirstLine) {
            this.buffer.append(inputToMatch);
        } else {
            offset = inputToMatch.indexOf(this.firstLine);
            if (offset >= 0) {
                this.buffer.append(inputToMatch.substring(offset));
                this.seenFirstLine = true;
            } else {
                return false;
            }
        }
        if (this.buffer.length() >= this.fullText.length()) {
            if (this.buffer.toString().contains(this.fullText)) {
                return true;
            }
            offset = this.buffer.substring(1).indexOf(this.firstLine);
            if (offset >= 0) {
                this.buffer.delete(0, offset);
            } else {
                this.reset();
            }
        }
        return false;
    }

    @Override
    public void reset() {
        super.reset();
        this.buffer.setLength(0);
        this.seenFirstLine = false;
    }
}

