/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import org.apache.rat.configuration.builders.AllBuilder;
import org.apache.rat.configuration.builders.AnyBuilder;
import org.apache.rat.configuration.builders.CopyrightBuilder;
import org.apache.rat.configuration.builders.MatcherRefBuilder;
import org.apache.rat.configuration.builders.NotBuilder;
import org.apache.rat.configuration.builders.RegexBuilder;
import org.apache.rat.configuration.builders.SpdxBuilder;
import org.apache.rat.configuration.builders.TextBuilder;

public interface IHeaderMatcher {
    public String getId();

    public void reset();

    public State matches(String var1);

    public State finalizeState();

    public State currentState();

    @FunctionalInterface
    public static interface Builder {
        public IHeaderMatcher build();

        public static TextBuilder text() {
            return new TextBuilder();
        }

        public static AnyBuilder any() {
            return new AnyBuilder();
        }

        public static AllBuilder all() {
            return new AllBuilder();
        }

        public static CopyrightBuilder copyright() {
            return new CopyrightBuilder();
        }

        public static SpdxBuilder spdx() {
            return new SpdxBuilder();
        }

        public static MatcherRefBuilder matcherRef() {
            return new MatcherRefBuilder();
        }

        public static NotBuilder not() {
            return new NotBuilder();
        }

        public static RegexBuilder regex() {
            return new RegexBuilder();
        }
    }

    public static enum State {
        t("true"),
        f("false"),
        i("indeterminent");

        private final String desc;

        private State(String desc) {
            this.desc = desc;
        }

        public boolean asBoolean() {
            switch (this) {
                case t: {
                    return true;
                }
                case f: {
                    return false;
                }
            }
            throw new IllegalStateException("'asBoolean' should never be called on an indeterminate state");
        }

        public String toString() {
            return super.toString() + " " + this.desc;
        }
    }
}

