/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigInteger;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.BigIntegerValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BigIntegerValidatorTest
extends AbstractNumberValidatorTest {
    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new BigIntegerValidator(false, 0);
        this.strictValidator = new BigIntegerValidator();
        this.testPattern = "#,###";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = new BigInteger("1234");
        this.testZero = new BigInteger("0");
        this.validStrict = new String[]{"0", "1234", "1,234"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testBigIntegerRangeMinMax() {
        BigIntegerValidator validator = (BigIntegerValidator)this.strictValidator;
        BigInteger number9 = validator.validate("9", "#");
        BigInteger number10 = validator.validate("10", "#");
        BigInteger number11 = validator.validate("11", "#");
        BigInteger number19 = validator.validate("19", "#");
        BigInteger number20 = validator.validate("20", "#");
        BigInteger number21 = validator.validate("21", "#");
        Assertions.assertFalse((boolean)validator.isInRange(number9, 10L, 20L), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, 10L, 20L), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, 10L, 20L), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, 10L, 20L), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, 10L, 20L), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, 10L), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, 10L), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, 10L), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, 20L), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, 20L), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, 20L), (String)"maxValue() > max");
    }

    @Test
    public void testBigIntegerValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String xxxx = "XXXX";
        BigInteger expected = new BigInteger("12345");
        Assertions.assertEquals((Object)expected, (Object)BigIntegerValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Object)expected, (Object)BigIntegerValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale ");
        Assertions.assertEquals((Object)expected, (Object)BigIntegerValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Object)expected, (Object)BigIntegerValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)BigIntegerValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)BigIntegerValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale ");
        Assertions.assertTrue((boolean)BigIntegerValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)BigIntegerValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)BigIntegerValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)BigIntegerValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale ");
        Assertions.assertNull((Object)BigIntegerValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)BigIntegerValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)BigIntegerValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)BigIntegerValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale ");
        Assertions.assertFalse((boolean)BigIntegerValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)BigIntegerValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }
}

