/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class RequiredNameTest
extends AbstractCommonTest {
    protected static final String FORM_KEY = "nameForm";
    protected static final String ACTION = "required";

    @BeforeEach
    protected void setUp() throws IOException, SAXException {
        this.loadResources("RequiredNameTest-config.xml");
    }

    @AfterEach
    protected void tearDown() {
    }

    @Test
    public void testRequired() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), (String)"Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!lastNameResult.isValid(ACTION) ? 1 : 0) != 0, (String)"Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    public void testRequiredFirstName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION), () -> "First Name ValidatorResult for the 'required' action should have passed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), () -> "Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!lastNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    public void testRequiredFirstNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), () -> "Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!lastNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    public void testRequiredLastName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), () -> "Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)lastNameResult.isValid(ACTION), () -> "Last Name ValidatorResult for the 'required' action should have passed.");
    }

    @Test
    public void testRequiredLastNameBlank() throws ValidatorException {
        NameBean name = new NameBean();
        name.setLastName("");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), (String)"First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0, (String)"First Name ValidatorResult for the 'required' action should have failed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), () -> "Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((!lastNameResult.isValid(ACTION) ? 1 : 0) != 0, () -> "Last Name ValidatorResult for the 'required' action should have failed.");
    }

    @Test
    public void testRequiredName() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("Smith");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = validator.validate();
        Assertions.assertNotNull((Object)results, (String)"Results are null.");
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        Assertions.assertNotNull((Object)firstNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)firstNameResult.containsAction(ACTION), () -> "First Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)firstNameResult.isValid(ACTION), () -> "First Name ValidatorResult for the 'required' action should have passed.");
        Assertions.assertNotNull((Object)lastNameResult, (String)"First Name ValidatorResult should not be null.");
        Assertions.assertTrue((boolean)lastNameResult.containsAction(ACTION), () -> "Last Name ValidatorResult should contain the 'required' action.");
        Assertions.assertTrue((boolean)lastNameResult.isValid(ACTION), () -> "Last Name ValidatorResult for the 'required' action should have passed.");
    }
}

