/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.IntegerValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IntegerValidatorTest
extends AbstractNumberValidatorTest {
    private static final Integer INT_MIN_VAL = Integer.MIN_VALUE;
    private static final Integer INT_MAX_VAL = Integer.MAX_VALUE;
    private static final String INT_MAX = "2147483647";
    private static final String INT_MAX_0 = "2147483647.99999999999999999999999";
    private static final String INT_MAX_1 = "2147483648";
    private static final String INT_MIN = "-2147483648";
    private static final String INT_MIN_0 = "-2147483648.99999999999999999999999";
    private static final String INT_MIN_1 = "-2147483649";

    @Override
    @BeforeEach
    protected void setUp() {
        super.setUp();
        this.validator = new IntegerValidator(false, 0);
        this.strictValidator = new IntegerValidator();
        this.testPattern = "#,###";
        this.max = Integer.MAX_VALUE;
        this.maxPlusOne = this.max.longValue() + 1L;
        this.min = Integer.MIN_VALUE;
        this.minMinusOne = this.min.longValue() - 1L;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2", INT_MAX_1, INT_MIN_1};
        this.invalid = new String[]{null, "", "X", "X12", INT_MAX_1, INT_MIN_1};
        this.testNumber = 1234;
        this.testZero = 0;
        this.validStrict = new String[]{"0", "1234", "1,234", INT_MAX, INT_MIN};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, INT_MAX_VAL, INT_MIN_VAL};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X", INT_MAX, INT_MIN, INT_MAX_0, INT_MIN_0};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber, INT_MAX_VAL, INT_MIN_VAL, INT_MAX_VAL, INT_MIN_VAL};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    @Test
    public void testIntegerRangeMinMax() {
        IntegerValidator validator = (IntegerValidator)this.strictValidator;
        Integer number9 = validator.validate("9", "#");
        Integer number10 = validator.validate("10", "#");
        Integer number11 = validator.validate("11", "#");
        Integer number19 = validator.validate("19", "#");
        Integer number20 = validator.validate("20", "#");
        Integer number21 = validator.validate("21", "#");
        Assertions.assertFalse((boolean)validator.isInRange(number9, 10, 20), (String)"isInRange() < min");
        Assertions.assertTrue((boolean)validator.isInRange(number10, 10, 20), (String)"isInRange() = min");
        Assertions.assertTrue((boolean)validator.isInRange(number11, 10, 20), (String)"isInRange() in range");
        Assertions.assertTrue((boolean)validator.isInRange(number20, 10, 20), (String)"isInRange() = max");
        Assertions.assertFalse((boolean)validator.isInRange(number21, 10, 20), (String)"isInRange() > max");
        Assertions.assertFalse((boolean)validator.minValue(number9, 10), (String)"minValue() < min");
        Assertions.assertTrue((boolean)validator.minValue(number10, 10), (String)"minValue() = min");
        Assertions.assertTrue((boolean)validator.minValue(number11, 10), (String)"minValue() > min");
        Assertions.assertTrue((boolean)validator.maxValue(number19, 20), (String)"maxValue() < max");
        Assertions.assertTrue((boolean)validator.maxValue(number20, 20), (String)"maxValue() = max");
        Assertions.assertFalse((boolean)validator.maxValue(number21, 20), (String)"maxValue() > max");
    }

    @Test
    public void testIntegerValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Integer expected = 12345;
        Assertions.assertEquals((Integer)expected, (Integer)IntegerValidator.getInstance().validate("12,345"), (String)"validate(A) default");
        Assertions.assertEquals((Integer)expected, (Integer)IntegerValidator.getInstance().validate("12.345", locale), (String)"validate(A) locale");
        Assertions.assertEquals((Integer)expected, (Integer)IntegerValidator.getInstance().validate("1,23,45", "0,00,00"), (String)"validate(A) pattern");
        Assertions.assertEquals((Integer)expected, (Integer)IntegerValidator.getInstance().validate("1.23.45", "0,00,00", Locale.GERMAN), (String)"validate(A) both");
        Assertions.assertTrue((boolean)IntegerValidator.getInstance().isValid("12,345"), (String)"isValid(A) default");
        Assertions.assertTrue((boolean)IntegerValidator.getInstance().isValid("12.345", locale), (String)"isValid(A) locale");
        Assertions.assertTrue((boolean)IntegerValidator.getInstance().isValid("1,23,45", "0,00,00"), (String)"isValid(A) pattern");
        Assertions.assertTrue((boolean)IntegerValidator.getInstance().isValid("1.23.45", "0,00,00", Locale.GERMAN), (String)"isValid(A) both");
        Assertions.assertNull((Object)IntegerValidator.getInstance().validate("XXXX"), (String)"validate(B) default");
        Assertions.assertNull((Object)IntegerValidator.getInstance().validate("XXXX", locale), (String)"validate(B) locale");
        Assertions.assertNull((Object)IntegerValidator.getInstance().validate("XXXX", "0,00,00"), (String)"validate(B) pattern");
        Assertions.assertNull((Object)IntegerValidator.getInstance().validate("1,23,45", "0,00,00", Locale.GERMAN), (String)"validate(B) both");
        Assertions.assertFalse((boolean)IntegerValidator.getInstance().isValid("XXXX"), (String)"isValid(B) default");
        Assertions.assertFalse((boolean)IntegerValidator.getInstance().isValid("XXXX", locale), (String)"isValid(B) locale");
        Assertions.assertFalse((boolean)IntegerValidator.getInstance().isValid("XXXX", "0,00,00"), (String)"isValid(B) pattern");
        Assertions.assertFalse((boolean)IntegerValidator.getInstance().isValid("1,23,45", "0,00,00", Locale.GERMAN), (String)"isValid(B) both");
    }

    @Test
    public void testMinMaxValues() {
        Assertions.assertTrue((boolean)this.validator.isValid(INT_MAX), (String)"2147483647 is max integer");
        Assertions.assertFalse((boolean)this.validator.isValid(INT_MAX_1), (String)"2147483648 > max integer");
        Assertions.assertTrue((boolean)this.validator.isValid(INT_MIN), (String)"-2147483648 is min integer");
        Assertions.assertFalse((boolean)this.validator.isValid(INT_MIN_1), (String)"-2147483649 < min integer");
    }
}

