/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import org.apache.commons.validator.routines.InetAddressValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InetAddressValidatorTest {
    private InetAddressValidator validator;

    @BeforeEach
    protected void setUp() {
        this.validator = new InetAddressValidator();
    }

    @Test
    public void testBrokenInetAddresses() {
        Assertions.assertFalse((boolean)this.validator.isValid("124.14.32.abc"), (String)"IP with characters should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValid("124.14.32.01"), (String)"IP with leading zeroes should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValid("23.64.12"), (String)"IP with three groups should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValid("26.34.23.77.234"), (String)"IP with five groups should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(""), (String)"IP empty string should be invalid");
    }

    @Test
    public void testInetAddressesByClass() {
        Assertions.assertTrue((boolean)this.validator.isValid("24.25.231.12"), (String)"class A IP should be valid");
        Assertions.assertFalse((boolean)this.validator.isValid("2.41.32.324"), (String)"illegal class A IP should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValid("135.14.44.12"), (String)"class B IP should be valid");
        Assertions.assertFalse((boolean)this.validator.isValid("154.123.441.123"), (String)"illegal class B IP should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValid("213.25.224.32"), (String)"class C IP should be valid");
        Assertions.assertFalse((boolean)this.validator.isValid("201.543.23.11"), (String)"illegal class C IP should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValid("229.35.159.6"), (String)"class D IP should be valid");
        Assertions.assertFalse((boolean)this.validator.isValid("231.54.11.987"), (String)"illegal class D IP should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValid("248.85.24.92"), (String)"class E IP should be valid");
        Assertions.assertFalse((boolean)this.validator.isValid("250.21.323.48"), (String)"illegal class E IP should be invalid");
    }

    @Test
    public void testInetAddressesFromTheWild() {
        Assertions.assertTrue((boolean)this.validator.isValid("140.211.11.130"), (String)"www.apache.org IP should be valid");
        Assertions.assertTrue((boolean)this.validator.isValid("72.14.253.103"), (String)"www.l.google.com IP should be valid");
        Assertions.assertTrue((boolean)this.validator.isValid("199.232.41.5"), (String)"fsf.org IP should be valid");
        Assertions.assertTrue((boolean)this.validator.isValid("216.35.123.87"), (String)"appscs.ign.com IP should be valid");
    }

    @Test
    public void testIPv6() {
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(""), (String)"IPV6 empty string should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::1"), (String)"IPV6 ::1 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::"), (String)"IPV6 :: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:0:1"), (String)"IPV6 0:0:0:0:0:0:0:1 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:0:0"), (String)"IPV6 0:0:0:0:0:0:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:DB8:0:0:8:800:200C:417A"), (String)"IPV6 2001:DB8:0:0:8:800:200C:417A should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("FF01:0:0:0:0:0:0:101"), (String)"IPV6 FF01:0:0:0:0:0:0:101 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:DB8::8:800:200C:417A"), (String)"IPV6 2001:DB8::8:800:200C:417A should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("FF01::101"), (String)"IPV6 FF01::101 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:DB8:0:0:8:800:200C:417A:221"), (String)"IPV6 2001:DB8:0:0:8:800:200C:417A:221 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("FF01::101::2"), (String)"IPV6 FF01::101::2 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80::217:f2ff:fe07:ed62"), (String)"IPV6 fe80::217:f2ff:fe07:ed62 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0000:1234:0000:0000:C1C0:ABCD:0876"), (String)"IPV6 2001:0000:1234:0000:0000:C1C0:ABCD:0876 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("3ffe:0b00:0000:0000:0001:0000:0000:000a"), (String)"IPV6 3ffe:0b00:0000:0000:0001:0000:0000:000a should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("FF02:0000:0000:0000:0000:0000:0000:0001"), (String)"IPV6 FF02:0000:0000:0000:0000:0000:0000:0001 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0000:0000:0000:0000:0000:0000:0000:0001"), (String)"IPV6 0000:0000:0000:0000:0000:0000:0000:0001 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0000:0000:0000:0000:0000:0000:0000:0000"), (String)"IPV6 0000:0000:0000:0000:0000:0000:0000:0000 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("02001:0000:1234:0000:0000:C1C0:ABCD:0876"), (String)"IPV6 02001:0000:1234:0000:0000:C1C0:ABCD:0876 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:0000:1234:0000:00001:C1C0:ABCD:0876"), (String)"IPV6 2001:0000:1234:0000:00001:C1C0:ABCD:0876 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:0000:1234:0000:0000:C1C0:ABCD:0876 0"), (String)"IPV6 2001:0000:1234:0000:0000:C1C0:ABCD:0876 0 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:0000:1234: 0000:0000:C1C0:ABCD:0876"), (String)"IPV6 2001:0000:1234: 0000:0000:C1C0:ABCD:0876 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("3ffe:0b00:0000:0001:0000:0000:000a"), (String)"IPV6 3ffe:0b00:0000:0001:0000:0000:000a should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("FF02:0000:0000:0000:0000:0000:0000:0000:0001"), (String)"IPV6 FF02:0000:0000:0000:0000:0000:0000:0000:0001 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("3ffe:b00::1::a"), (String)"IPV6 3ffe:b00::1::a should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1111:2222:3333:4444:5555:6666::"), (String)"IPV6 ::1111:2222:3333:4444:5555:6666:: should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2::10"), (String)"IPV6 2::10 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("ff02::1"), (String)"IPV6 ff02::1 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80::"), (String)"IPV6 fe80:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2002::"), (String)"IPV6 2002:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:db8::"), (String)"IPV6 2001:db8:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:1234::"), (String)"IPV6 2001:0db8:1234:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:0:0"), (String)"IPV6 ::ffff:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5:6:7:8"), (String)"IPV6 1:2:3:4:5:6:7:8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5:6::8"), (String)"IPV6 1:2:3:4:5:6::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5::8"), (String)"IPV6 1:2:3:4:5::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4::8"), (String)"IPV6 1:2:3:4::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3::8"), (String)"IPV6 1:2:3::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2::8"), (String)"IPV6 1:2::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::8"), (String)"IPV6 1::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::2:3:4:5:6:7"), (String)"IPV6 1::2:3:4:5:6:7 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::2:3:4:5:6"), (String)"IPV6 1::2:3:4:5:6 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::2:3:4:5"), (String)"IPV6 1::2:3:4:5 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::2:3:4"), (String)"IPV6 1::2:3:4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::2:3"), (String)"IPV6 1::2:3 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2:3:4:5:6:7:8"), (String)"IPV6 ::2:3:4:5:6:7:8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2:3:4:5:6:7"), (String)"IPV6 ::2:3:4:5:6:7 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2:3:4:5:6"), (String)"IPV6 ::2:3:4:5:6 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2:3:4:5"), (String)"IPV6 ::2:3:4:5 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2:3:4"), (String)"IPV6 ::2:3:4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2:3"), (String)"IPV6 ::2:3 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::8"), (String)"IPV6 ::8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5:6::"), (String)"IPV6 1:2:3:4:5:6:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5::"), (String)"IPV6 1:2:3:4:5:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4::"), (String)"IPV6 1:2:3:4:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3::"), (String)"IPV6 1:2:3:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2::"), (String)"IPV6 1:2:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::"), (String)"IPV6 1:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5::7:8"), (String)"IPV6 1:2:3:4:5::7:8 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1:2:3::4:5::7:8"), (String)"IPV6 1:2:3::4:5::7:8 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("12345::6:7:8"), (String)"IPV6 12345::6:7:8 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4::7:8"), (String)"IPV6 1:2:3:4::7:8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3::7:8"), (String)"IPV6 1:2:3::7:8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2::7:8"), (String)"IPV6 1:2::7:8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::7:8"), (String)"IPV6 1::7:8 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5:6:1.2.3.4"), (String)"IPV6 1:2:3:4:5:6:1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4:5::1.2.3.4"), (String)"IPV6 1:2:3:4:5::1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4::1.2.3.4"), (String)"IPV6 1:2:3:4::1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3::1.2.3.4"), (String)"IPV6 1:2:3::1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2::1.2.3.4"), (String)"IPV6 1:2::1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::1.2.3.4"), (String)"IPV6 1::1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3:4::5:1.2.3.4"), (String)"IPV6 1:2:3:4::5:1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2:3::5:1.2.3.4"), (String)"IPV6 1:2:3::5:1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1:2::5:1.2.3.4"), (String)"IPV6 1:2::5:1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::5:1.2.3.4"), (String)"IPV6 1::5:1.2.3.4 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1::5:11.22.33.44"), (String)"IPV6 1::5:11.22.33.44 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:400.2.3.4"), (String)"IPV6 1::5:400.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:260.2.3.4"), (String)"IPV6 1::5:260.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:256.2.3.4"), (String)"IPV6 1::5:256.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.256.3.4"), (String)"IPV6 1::5:1.256.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.2.256.4"), (String)"IPV6 1::5:1.2.256.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.2.3.256"), (String)"IPV6 1::5:1.2.3.256 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:300.2.3.4"), (String)"IPV6 1::5:300.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.300.3.4"), (String)"IPV6 1::5:1.300.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.2.300.4"), (String)"IPV6 1::5:1.2.300.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.2.3.300"), (String)"IPV6 1::5:1.2.3.300 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:900.2.3.4"), (String)"IPV6 1::5:900.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.900.3.4"), (String)"IPV6 1::5:1.900.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.2.900.4"), (String)"IPV6 1::5:1.2.900.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:1.2.3.900"), (String)"IPV6 1::5:1.2.3.900 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:300.300.300.300"), (String)"IPV6 1::5:300.300.300.300 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::5:3000.30.30.30"), (String)"IPV6 1::5:3000.30.30.30 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::400.2.3.4"), (String)"IPV6 1::400.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::260.2.3.4"), (String)"IPV6 1::260.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::256.2.3.4"), (String)"IPV6 1::256.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.256.3.4"), (String)"IPV6 1::1.256.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.2.256.4"), (String)"IPV6 1::1.2.256.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.2.3.256"), (String)"IPV6 1::1.2.3.256 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::300.2.3.4"), (String)"IPV6 1::300.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.300.3.4"), (String)"IPV6 1::1.300.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.2.300.4"), (String)"IPV6 1::1.2.300.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.2.3.300"), (String)"IPV6 1::1.2.3.300 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::900.2.3.4"), (String)"IPV6 1::900.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.900.3.4"), (String)"IPV6 1::1.900.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.2.900.4"), (String)"IPV6 1::1.2.900.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::1.2.3.900"), (String)"IPV6 1::1.2.3.900 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::300.300.300.300"), (String)"IPV6 1::300.300.300.300 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::3000.30.30.30"), (String)"IPV6 1::3000.30.30.30 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::400.2.3.4"), (String)"IPV6 ::400.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::260.2.3.4"), (String)"IPV6 ::260.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::256.2.3.4"), (String)"IPV6 ::256.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.256.3.4"), (String)"IPV6 ::1.256.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.256.4"), (String)"IPV6 ::1.2.256.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.3.256"), (String)"IPV6 ::1.2.3.256 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::300.2.3.4"), (String)"IPV6 ::300.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.300.3.4"), (String)"IPV6 ::1.300.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.300.4"), (String)"IPV6 ::1.2.300.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.3.300"), (String)"IPV6 ::1.2.3.300 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::900.2.3.4"), (String)"IPV6 ::900.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.900.3.4"), (String)"IPV6 ::1.900.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.900.4"), (String)"IPV6 ::1.2.900.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.3.900"), (String)"IPV6 ::1.2.3.900 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::300.300.300.300"), (String)"IPV6 ::300.300.300.300 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::3000.30.30.30"), (String)"IPV6 ::3000.30.30.30 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80::217:f2ff:254.7.237.98"), (String)"IPV6 fe80::217:f2ff:254.7.237.98 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:192.168.1.26"), (String)"IPV6 ::ffff:192.168.1.26 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:1:1:1:1:1:255Z255X255Y255"), (String)"IPV6 2001:1:1:1:1:1:255Z255X255Y255 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::ffff:192x168.1.26"), (String)"IPV6 ::ffff:192x168.1.26 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:192.168.1.1"), (String)"IPV6 ::ffff:192.168.1.1 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:13.1.68.3"), (String)"IPV6 0:0:0:0:0:0:13.1.68.3 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0:FFFF:129.144.52.38"), (String)"IPV6 0:0:0:0:0:FFFF:129.144.52.38 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::13.1.68.3"), (String)"IPV6 ::13.1.68.3 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::FFFF:129.144.52.38"), (String)"IPV6 ::FFFF:129.144.52.38 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80:0:0:0:204:61ff:254.157.241.86"), (String)"IPV6 fe80:0:0:0:204:61ff:254.157.241.86 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80::204:61ff:254.157.241.86"), (String)"IPV6 fe80::204:61ff:254.157.241.86 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:12.34.56.78"), (String)"IPV6 ::ffff:12.34.56.78 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::ffff:2.3.4"), (String)"IPV6 ::ffff:2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::ffff:257.1.2.3"), (String)"IPV6 ::ffff:257.1.2.3 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4"), (String)"IPV6 1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4:1111:2222:3333:4444::5555"), (String)"IPV6 1.2.3.4:1111:2222:3333:4444::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4:1111:2222:3333::5555"), (String)"IPV6 1.2.3.4:1111:2222:3333::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4:1111:2222::5555"), (String)"IPV6 1.2.3.4:1111:2222::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4:1111::5555"), (String)"IPV6 1.2.3.4:1111::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4::5555"), (String)"IPV6 1.2.3.4::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4::"), (String)"IPV6 1.2.3.4:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("fe80:0000:0000:0000:0204:61ff:254.157.241.086"), (String)"IPV6 fe80:0000:0000:0000:0204:61ff:254.157.241.086 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:192.0.2.128"), (String)"IPV6 ::ffff:192.0.2.128 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:1.2.3.4"), (String)"IPV6 XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:00.00.00.00"), (String)"IPV6 1111:2222:3333:4444:5555:6666:00.00.00.00 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:000.000.000.000"), (String)"IPV6 1111:2222:3333:4444:5555:6666:000.000.000.000 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:256.256.256.256"), (String)"IPV6 1111:2222:3333:4444:5555:6666:256.256.256.256 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80:0000:0000:0000:0204:61ff:fe9d:f156"), (String)"IPV6 fe80:0000:0000:0000:0204:61ff:fe9d:f156 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80:0:0:0:204:61ff:fe9d:f156"), (String)"IPV6 fe80:0:0:0:204:61ff:fe9d:f156 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("fe80::204:61ff:fe9d:f156"), (String)"IPV6 fe80::204:61ff:fe9d:f156 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":"), (String)"IPV6 : should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:c000:280"), (String)"IPV6 ::ffff:c000:280 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::5555:"), (String)"IPV6 1111:2222:3333:4444::5555: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:"), (String)"IPV6 1111:2222:3333::5555: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::5555:"), (String)"IPV6 1111:2222::5555: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::5555:"), (String)"IPV6 1111::5555: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::5555:"), (String)"IPV6 ::5555: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::"), (String)"IPV6 ::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:"), (String)"IPV6 1111: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::5555"), (String)"IPV6 :1111:2222:3333:4444::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::5555"), (String)"IPV6 :1111:2222:3333::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::5555"), (String)"IPV6 :1111:2222::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::5555"), (String)"IPV6 :1111::5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::5555"), (String)"IPV6 :::5555 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:85a3:0000:0000:8a2e:0370:7334"), (String)"IPV6 2001:0db8:85a3:0000:0000:8a2e:0370:7334 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:db8:85a3:0:0:8a2e:370:7334"), (String)"IPV6 2001:db8:85a3:0:0:8a2e:370:7334 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:db8:85a3::8a2e:370:7334"), (String)"IPV6 2001:db8:85a3::8a2e:370:7334 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:0000:0000:0000:0000:1428:57ab"), (String)"IPV6 2001:0db8:0000:0000:0000:0000:1428:57ab should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:0000:0000:0000::1428:57ab"), (String)"IPV6 2001:0db8:0000:0000:0000::1428:57ab should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:0:0:0:0:1428:57ab"), (String)"IPV6 2001:0db8:0:0:0:0:1428:57ab should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:0:0::1428:57ab"), (String)"IPV6 2001:0db8:0:0::1428:57ab should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8::1428:57ab"), (String)"IPV6 2001:0db8::1428:57ab should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:db8::1428:57ab"), (String)"IPV6 2001:db8::1428:57ab should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::ffff:0c22:384e"), (String)"IPV6 ::ffff:0c22:384e should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:1234:0000:0000:0000:0000:0000"), (String)"IPV6 2001:0db8:1234:0000:0000:0000:0000:0000 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:0db8:1234:ffff:ffff:ffff:ffff:ffff"), (String)"IPV6 2001:0db8:1234:ffff:ffff:ffff:ffff:ffff should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("2001:db8:a::123"), (String)"IPV6 2001:db8:a::123 should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("123"), (String)"IPV6 123 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("ldkfj"), (String)"IPV6 ldkfj should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001::FFD3::57ab"), (String)"IPV6 2001::FFD3::57ab should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:db8:85a3::8a2e:37023:7334"), (String)"IPV6 2001:db8:85a3::8a2e:37023:7334 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("2001:db8:85a3::8a2e:370k:7334"), (String)"IPV6 2001:db8:85a3::8a2e:370k:7334 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1:2:3:4:5:6:7:8:9"), (String)"IPV6 1:2:3:4:5:6:7:8:9 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1::2::3"), (String)"IPV6 1::2::3 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1:::3:4:5"), (String)"IPV6 1:::3:4:5 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1:2:3::4:5:6:7:8:9"), (String)"IPV6 1:2:3::4:5:6:7:8:9 should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777::"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::"), (String)"IPV6 1111:2222:3333:4444:5555:6666:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::"), (String)"IPV6 1111:2222:3333:4444:5555:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::"), (String)"IPV6 1111:2222:3333:4444:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::"), (String)"IPV6 1111:2222:3333:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::"), (String)"IPV6 1111:2222:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::"), (String)"IPV6 1111:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::8888"), (String)"IPV6 1111:2222:3333:4444:5555:6666::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::8888"), (String)"IPV6 1111:2222:3333:4444:5555::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::8888"), (String)"IPV6 1111:2222:3333:4444::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::8888"), (String)"IPV6 1111:2222:3333::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::8888"), (String)"IPV6 1111:2222::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::8888"), (String)"IPV6 1111::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::8888"), (String)"IPV6 ::8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::7777:8888"), (String)"IPV6 1111:2222:3333:4444:5555::7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::7777:8888"), (String)"IPV6 1111:2222:3333:4444::7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::7777:8888"), (String)"IPV6 1111:2222:3333::7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::7777:8888"), (String)"IPV6 1111:2222::7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::7777:8888"), (String)"IPV6 1111::7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::7777:8888"), (String)"IPV6 ::7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:7777:8888"), (String)"IPV6 1111:2222:3333:4444::6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::6666:7777:8888"), (String)"IPV6 1111:2222:3333::6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::6666:7777:8888"), (String)"IPV6 1111:2222::6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::6666:7777:8888"), (String)"IPV6 1111::6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::6666:7777:8888"), (String)"IPV6 ::6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:7777:8888"), (String)"IPV6 1111:2222:3333::5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::5555:6666:7777:8888"), (String)"IPV6 1111:2222::5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::5555:6666:7777:8888"), (String)"IPV6 1111::5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::5555:6666:7777:8888"), (String)"IPV6 ::5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:7777:8888"), (String)"IPV6 1111:2222::4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::4444:5555:6666:7777:8888"), (String)"IPV6 1111::4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::4444:5555:6666:7777:8888"), (String)"IPV6 ::4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:7777:8888"), (String)"IPV6 1111::3333:4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::3333:4444:5555:6666:7777:8888"), (String)"IPV6 ::3333:4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 ::2222:3333:4444:5555:6666:7777:8888 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:123.123.123.123"), (String)"IPV6 1111:2222:3333:4444:5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::123.123.123.123"), (String)"IPV6 1111:2222:3333:4444:5555::123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::123.123.123.123"), (String)"IPV6 1111:2222:3333:4444::123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::123.123.123.123"), (String)"IPV6 1111:2222:3333::123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::123.123.123.123"), (String)"IPV6 1111:2222::123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::123.123.123.123"), (String)"IPV6 1111::123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::123.123.123.123"), (String)"IPV6 ::123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:123.123.123.123"), (String)"IPV6 1111:2222:3333:4444::6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::6666:123.123.123.123"), (String)"IPV6 1111:2222:3333::6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::6666:123.123.123.123"), (String)"IPV6 1111:2222::6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::6666:123.123.123.123"), (String)"IPV6 1111::6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::6666:123.123.123.123"), (String)"IPV6 ::6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:123.123.123.123"), (String)"IPV6 1111:2222:3333::5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::5555:6666:123.123.123.123"), (String)"IPV6 1111:2222::5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::5555:6666:123.123.123.123"), (String)"IPV6 1111::5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::5555:6666:123.123.123.123"), (String)"IPV6 ::5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:123.123.123.123"), (String)"IPV6 1111:2222::4444:5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::4444:5555:6666:123.123.123.123"), (String)"IPV6 1111::4444:5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::4444:5555:6666:123.123.123.123"), (String)"IPV6 ::4444:5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:123.123.123.123"), (String)"IPV6 1111::3333:4444:5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:123.123.123.123"), (String)"IPV6 ::2222:3333:4444:5555:6666:123.123.123.123 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:0:0:0:0:0:0"), (String)"IPV6 ::0:0:0:0:0:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:0:0:0:0:0"), (String)"IPV6 ::0:0:0:0:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:0:0:0:0"), (String)"IPV6 ::0:0:0:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:0:0:0"), (String)"IPV6 ::0:0:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:0:0"), (String)"IPV6 ::0:0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:0"), (String)"IPV6 ::0:0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0"), (String)"IPV6 ::0 should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0:0:0::"), (String)"IPV6 0:0:0:0:0:0:0:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0:0::"), (String)"IPV6 0:0:0:0:0:0:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0:0::"), (String)"IPV6 0:0:0:0:0:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0:0::"), (String)"IPV6 0:0:0:0:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0:0::"), (String)"IPV6 0:0:0:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:0::"), (String)"IPV6 0:0:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0::"), (String)"IPV6 0:: should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX"), (String)"IPV6 XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX:XXXX should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888:9999"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888:9999 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888::"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:8888:9999"), (String)"IPV6 ::2222:3333:4444:5555:6666:7777:8888:9999 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666"), (String)"IPV6 1111:2222:3333:4444:5555:6666 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555"), (String)"IPV6 1111:2222:3333:4444:5555 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444"), (String)"IPV6 1111:2222:3333:4444 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333"), (String)"IPV6 1111:2222:3333 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222"), (String)"IPV6 1111:2222 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111"), (String)"IPV6 1111 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("11112222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 11112222:3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:22223333:4444:5555:6666:7777:8888"), (String)"IPV6 1111:22223333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:33334444:5555:6666:7777:8888"), (String)"IPV6 1111:2222:33334444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:44445555:6666:7777:8888"), (String)"IPV6 1111:2222:3333:44445555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:55556666:7777:8888"), (String)"IPV6 1111:2222:3333:4444:55556666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:66667777:8888"), (String)"IPV6 1111:2222:3333:4444:5555:66667777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:77778888"), (String)"IPV6 1111:2222:3333:4444:5555:6666:77778888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888:"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:"), (String)"IPV6 1111:2222:3333:4444:5555:6666: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:"), (String)"IPV6 1111:2222:3333:4444:5555: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:"), (String)"IPV6 1111:2222:3333:4444: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:"), (String)"IPV6 1111:2222:3333: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:"), (String)"IPV6 1111:2222: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":8888"), (String)"IPV6 :8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":7777:8888"), (String)"IPV6 :7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":6666:7777:8888"), (String)"IPV6 :6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":5555:6666:7777:8888"), (String)"IPV6 :5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":4444:5555:6666:7777:8888"), (String)"IPV6 :4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":3333:4444:5555:6666:7777:8888"), (String)"IPV6 :3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":2222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 :2222:3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 :1111:2222:3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 :::2222:3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:::3333:4444:5555:6666:7777:8888"), (String)"IPV6 1111:::3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:::4444:5555:6666:7777:8888"), (String)"IPV6 1111:2222:::4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:::5555:6666:7777:8888"), (String)"IPV6 1111:2222:3333:::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:::6666:7777:8888"), (String)"IPV6 1111:2222:3333:4444:::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:::7777:8888"), (String)"IPV6 1111:2222:3333:4444:5555:::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:::8888"), (String)"IPV6 1111:2222:3333:4444:5555:6666:::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:::"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222::4444:5555:6666:7777:8888"), (String)"IPV6 ::2222::4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333::5555:6666:7777:8888"), (String)"IPV6 ::2222:3333::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444::6666:7777:8888"), (String)"IPV6 ::2222:3333:4444::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555::7777:8888"), (String)"IPV6 ::2222:3333:4444:5555::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:7777::8888"), (String)"IPV6 ::2222:3333:4444:5555:7777::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:7777:8888::"), (String)"IPV6 ::2222:3333:4444:5555:7777:8888:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333::5555:6666:7777:8888"), (String)"IPV6 1111::3333::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444::6666:7777:8888"), (String)"IPV6 1111::3333:4444::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555::7777:8888"), (String)"IPV6 1111::3333:4444:5555::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666::8888"), (String)"IPV6 1111::3333:4444:5555:6666::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:7777::"), (String)"IPV6 1111::3333:4444:5555:6666:7777:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444::6666:7777:8888"), (String)"IPV6 1111:2222::4444::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555::7777:8888"), (String)"IPV6 1111:2222::4444:5555::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666::8888"), (String)"IPV6 1111:2222::4444:5555:6666::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:7777::"), (String)"IPV6 1111:2222::4444:5555:6666:7777:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555::7777:8888"), (String)"IPV6 1111:2222:3333::5555::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666::8888"), (String)"IPV6 1111:2222:3333::5555:6666::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:7777::"), (String)"IPV6 1111:2222:3333::5555:6666:7777:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666::8888"), (String)"IPV6 1111:2222:3333:4444::6666::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:7777::"), (String)"IPV6 1111:2222:3333:4444::6666:7777:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::7777::"), (String)"IPV6 1111:2222:3333:4444:5555::7777:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:8888:1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:8888:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:5555:6666::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:1.2.3.4"), (String)"IPV6 ::2222:3333:4444:5555:6666:7777:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:1.2.3.4.5"), (String)"IPV6 1111:2222:3333:4444:5555:6666:1.2.3.4.5 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:5555:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:1.2.3.4"), (String)"IPV6 1111:2222:3333:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:1.2.3.4"), (String)"IPV6 1111:2222:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:1.2.3.4"), (String)"IPV6 1111:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1.2.3.4"), (String)"IPV6 1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("11112222:3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 11112222:3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:22223333:4444:5555:6666:1.2.3.4"), (String)"IPV6 1111:22223333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:33334444:5555:6666:1.2.3.4"), (String)"IPV6 1111:2222:33334444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:44445555:6666:1.2.3.4"), (String)"IPV6 1111:2222:3333:44445555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:55556666:1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:55556666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:66661.2.3.4"), (String)"IPV6 1111:2222:3333:4444:5555:66661.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:255255.255.255"), (String)"IPV6 1111:2222:3333:4444:5555:6666:255255.255.255 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:255.255255.255"), (String)"IPV6 1111:2222:3333:4444:5555:6666:255.255255.255 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:255.255.255255"), (String)"IPV6 1111:2222:3333:4444:5555:6666:255.255.255255 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1.2.3.4"), (String)"IPV6 :1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":6666:1.2.3.4"), (String)"IPV6 :6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":5555:6666:1.2.3.4"), (String)"IPV6 :5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":4444:5555:6666:1.2.3.4"), (String)"IPV6 :4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":2222:3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :2222:3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :1111:2222:3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :::2222:3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:::3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 1111:::3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:::4444:5555:6666:1.2.3.4"), (String)"IPV6 1111:2222:::4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:::5555:6666:1.2.3.4"), (String)"IPV6 1111:2222:3333:::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:::6666:1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:::1.2.3.4"), (String)"IPV6 1111:2222:3333:4444:5555:::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222::4444:5555:6666:1.2.3.4"), (String)"IPV6 ::2222::4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333::5555:6666:1.2.3.4"), (String)"IPV6 ::2222:3333::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444::6666:1.2.3.4"), (String)"IPV6 ::2222:3333:4444::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555::1.2.3.4"), (String)"IPV6 ::2222:3333:4444:5555::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333::5555:6666:1.2.3.4"), (String)"IPV6 1111::3333::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444::6666:1.2.3.4"), (String)"IPV6 1111::3333:4444::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555::1.2.3.4"), (String)"IPV6 1111::3333:4444:5555::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444::6666:1.2.3.4"), (String)"IPV6 1111:2222::4444::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555::1.2.3.4"), (String)"IPV6 1111:2222::4444:5555::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555::1.2.3.4"), (String)"IPV6 1111:2222:3333::5555::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::."), (String)"IPV6 ::. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::.."), (String)"IPV6 ::.. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::..."), (String)"IPV6 ::... should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1..."), (String)"IPV6 ::1... should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.."), (String)"IPV6 ::1.2.. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::1.2.3."), (String)"IPV6 ::1.2.3. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::.2.."), (String)"IPV6 ::.2.. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::.2.3."), (String)"IPV6 ::.2.3. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::.2.3.4"), (String)"IPV6 ::.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::..3."), (String)"IPV6 ::..3. should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::..3.4"), (String)"IPV6 ::..3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::...4"), (String)"IPV6 ::...4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:7777::"), (String)"IPV6 :1111:2222:3333:4444:5555:6666:7777:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666::"), (String)"IPV6 :1111:2222:3333:4444:5555:6666:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::"), (String)"IPV6 :1111:2222:3333:4444:5555:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::"), (String)"IPV6 :1111:2222:3333:4444:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::"), (String)"IPV6 :1111:2222:3333:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::"), (String)"IPV6 :1111:2222:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::"), (String)"IPV6 :1111:: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666::8888"), (String)"IPV6 :1111:2222:3333:4444:5555:6666::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::8888"), (String)"IPV6 :1111:2222:3333:4444:5555::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::8888"), (String)"IPV6 :1111:2222:3333:4444::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::8888"), (String)"IPV6 :1111:2222:3333::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::8888"), (String)"IPV6 :1111:2222::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::8888"), (String)"IPV6 :1111::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::8888"), (String)"IPV6 :::8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::7777:8888"), (String)"IPV6 :1111:2222:3333:4444:5555::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::7777:8888"), (String)"IPV6 :1111:2222:3333:4444::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::7777:8888"), (String)"IPV6 :1111:2222:3333::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::7777:8888"), (String)"IPV6 :1111:2222::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::7777:8888"), (String)"IPV6 :1111::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::7777:8888"), (String)"IPV6 :::7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::6666:7777:8888"), (String)"IPV6 :1111:2222:3333:4444::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::6666:7777:8888"), (String)"IPV6 :1111:2222:3333::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::6666:7777:8888"), (String)"IPV6 :1111:2222::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::6666:7777:8888"), (String)"IPV6 :1111::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::6666:7777:8888"), (String)"IPV6 :::6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::5555:6666:7777:8888"), (String)"IPV6 :1111:2222:3333::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::5555:6666:7777:8888"), (String)"IPV6 :1111:2222::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::5555:6666:7777:8888"), (String)"IPV6 :1111::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::5555:6666:7777:8888"), (String)"IPV6 :::5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::4444:5555:6666:7777:8888"), (String)"IPV6 :1111:2222::4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::4444:5555:6666:7777:8888"), (String)"IPV6 :1111::4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::4444:5555:6666:7777:8888"), (String)"IPV6 :::4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::3333:4444:5555:6666:7777:8888"), (String)"IPV6 :1111::3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::3333:4444:5555:6666:7777:8888"), (String)"IPV6 :::3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:7777:8888"), (String)"IPV6 :::2222:3333:4444:5555:6666:7777:8888 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :1111:2222:3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444:5555::1.2.3.4"), (String)"IPV6 :1111:2222:3333:4444:5555::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::1.2.3.4"), (String)"IPV6 :1111:2222:3333:4444::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::1.2.3.4"), (String)"IPV6 :1111:2222:3333::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::1.2.3.4"), (String)"IPV6 :1111:2222::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::1.2.3.4"), (String)"IPV6 :1111::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::1.2.3.4"), (String)"IPV6 :::1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333:4444::6666:1.2.3.4"), (String)"IPV6 :1111:2222:3333:4444::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::6666:1.2.3.4"), (String)"IPV6 :1111:2222:3333::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::6666:1.2.3.4"), (String)"IPV6 :1111:2222::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::6666:1.2.3.4"), (String)"IPV6 :1111::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::6666:1.2.3.4"), (String)"IPV6 :::6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222:3333::5555:6666:1.2.3.4"), (String)"IPV6 :1111:2222:3333::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::5555:6666:1.2.3.4"), (String)"IPV6 :1111:2222::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::5555:6666:1.2.3.4"), (String)"IPV6 :1111::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::5555:6666:1.2.3.4"), (String)"IPV6 :::5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111:2222::4444:5555:6666:1.2.3.4"), (String)"IPV6 :1111:2222::4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::4444:5555:6666:1.2.3.4"), (String)"IPV6 :1111::4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::4444:5555:6666:1.2.3.4"), (String)"IPV6 :::4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":1111::3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :1111::3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address(":::2222:3333:4444:5555:6666:1.2.3.4"), (String)"IPV6 :::2222:3333:4444:5555:6666:1.2.3.4 should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:7777:::"), (String)"IPV6 1111:2222:3333:4444:5555:6666:7777::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666:::"), (String)"IPV6 1111:2222:3333:4444:5555:6666::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:::"), (String)"IPV6 1111:2222:3333:4444:5555::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:::"), (String)"IPV6 1111:2222:3333:4444::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:::"), (String)"IPV6 1111:2222:3333::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:::"), (String)"IPV6 1111:2222::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:::"), (String)"IPV6 1111::: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555:6666::8888:"), (String)"IPV6 1111:2222:3333:4444:5555:6666::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::8888:"), (String)"IPV6 1111:2222:3333:4444:5555::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::8888:"), (String)"IPV6 1111:2222:3333:4444::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::8888:"), (String)"IPV6 1111:2222:3333::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::8888:"), (String)"IPV6 1111:2222::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::8888:"), (String)"IPV6 1111::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::8888:"), (String)"IPV6 ::8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444:5555::7777:8888:"), (String)"IPV6 1111:2222:3333:4444:5555::7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::7777:8888:"), (String)"IPV6 1111:2222:3333:4444::7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::7777:8888:"), (String)"IPV6 1111:2222:3333::7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::7777:8888:"), (String)"IPV6 1111:2222::7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::7777:8888:"), (String)"IPV6 1111::7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::7777:8888:"), (String)"IPV6 ::7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333:4444::6666:7777:8888:"), (String)"IPV6 1111:2222:3333:4444::6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::6666:7777:8888:"), (String)"IPV6 1111:2222:3333::6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::6666:7777:8888:"), (String)"IPV6 1111:2222::6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::6666:7777:8888:"), (String)"IPV6 1111::6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::6666:7777:8888:"), (String)"IPV6 ::6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222:3333::5555:6666:7777:8888:"), (String)"IPV6 1111:2222:3333::5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::5555:6666:7777:8888:"), (String)"IPV6 1111:2222::5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::5555:6666:7777:8888:"), (String)"IPV6 1111::5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::5555:6666:7777:8888:"), (String)"IPV6 ::5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111:2222::4444:5555:6666:7777:8888:"), (String)"IPV6 1111:2222::4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::4444:5555:6666:7777:8888:"), (String)"IPV6 1111::4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::4444:5555:6666:7777:8888:"), (String)"IPV6 ::4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("1111::3333:4444:5555:6666:7777:8888:"), (String)"IPV6 1111::3333:4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::3333:4444:5555:6666:7777:8888:"), (String)"IPV6 ::3333:4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("::2222:3333:4444:5555:6666:7777:8888:"), (String)"IPV6 ::2222:3333:4444:5555:6666:7777:8888: should be invalid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("0:a:b:c:d:e:f::"), (String)"IPV6 0:a:b:c:d:e:f:: should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("::0:a:b:c:d:e:f"), (String)"IPV6 ::0:a:b:c:d:e:f should be valid");
        Assertions.assertTrue((boolean)this.validator.isValidInet6Address("a:b:c:d:e:f:0::"), (String)"IPV6 a:b:c:d:e:f:0:: should be valid");
        Assertions.assertFalse((boolean)this.validator.isValidInet6Address("':10.0.0.1"), (String)"IPV6 ':10.0.0.1 should be invalid");
    }

    @Test
    public void testReservedInetAddresses() {
        Assertions.assertTrue((boolean)this.validator.isValid("127.0.0.1"), (String)"localhost IP should be valid");
        Assertions.assertTrue((boolean)this.validator.isValid("255.255.255.255"), (String)"broadcast IP should be valid");
    }

    @Test
    public void testVALIDATOR_335() {
        Assertions.assertTrue((boolean)this.validator.isValid("2001:0438:FFFE:0000:0000:0000:0000:0A35"), (String)"2001:0438:FFFE:0000:0000:0000:0000:0A35 should be valid");
    }

    @Test
    public void testVALIDATOR_419() {
        String addr = "0:0:0:0:0:0:13.1.68.3";
        Assertions.assertTrue((boolean)this.validator.isValid(addr));
        addr = "0:0:0:0:0:FFFF:129.144.52.38";
        Assertions.assertTrue((boolean)this.validator.isValid(addr), (String)addr);
        addr = "::13.1.68.3";
        Assertions.assertTrue((boolean)this.validator.isValid(addr), (String)addr);
        addr = "::FFFF:129.144.52.38";
        Assertions.assertTrue((boolean)this.validator.isValid(addr), (String)addr);
        addr = "::ffff:192.168.1.1:192.168.1.1";
        Assertions.assertFalse((boolean)this.validator.isValid(addr), (String)addr);
        addr = "::192.168.1.1:192.168.1.1";
        Assertions.assertFalse((boolean)this.validator.isValid(addr), (String)addr);
    }

    @Test
    public void testVALIDATOR_445() {
        String[] valid = new String[]{"2001:0000:1234:0000:0000:C1C0:ABCD:0876", "2001:0000:1234:0000:0000:C1C0:ABCD:0876/123", "2001:0000:1234:0000:0000:C1C0:ABCD:0876/0", "2001:0000:1234:0000:0000:C1C0:ABCD:0876%0", "2001:0000:1234:0000:0000:C1C0:ABCD:0876%abcdefgh"};
        String[] invalid = new String[]{"2001:0000:1234:0000:0000:C1C0:ABCD:0876/129", "2001:0000:1234:0000:0000:C1C0:ABCD:0876/-0", "2001:0000:1234:0000:0000:C1C0:ABCD:0876/+0", "2001:0000:1234:0000:0000:C1C0:ABCD:0876/10O", "2001:0000:1234:0000:0000:C1C0:ABCD:0876/0%0", "2001:0000:1234:0000:0000:C1C0:ABCD:0876%abc defgh", "2001:0000:1234:0000:0000:C1C0:ABCD:0876%abc%defgh"};
        for (String item : valid) {
            Assertions.assertTrue((boolean)this.validator.isValid(item), () -> String.format("%s should be valid", item));
        }
        for (String item : invalid) {
            Assertions.assertFalse((boolean)this.validator.isValid(item), () -> String.format("%s should be invalid", item));
        }
    }
}

