/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.UrlValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@Deprecated
public class UrlTest {
    private final boolean printStatus = false;
    private final boolean printIndex = false;
    ResultPair[] testUrlScheme = new ResultPair[]{new ResultPair("http://", true), new ResultPair("ftp://", true), new ResultPair("h3t://", true), new ResultPair("3ht://", false), new ResultPair("http:/", false), new ResultPair("http:", false), new ResultPair("http/", false), new ResultPair("://", false), new ResultPair("", true)};
    ResultPair[] testUrlAuthority = new ResultPair[]{new ResultPair("www.google.com", true), new ResultPair("go.com", true), new ResultPair("go.au", true), new ResultPair("0.0.0.0", true), new ResultPair("255.255.255.255", true), new ResultPair("256.256.256.256", false), new ResultPair("255.com", true), new ResultPair("1.2.3.4.5", false), new ResultPair("1.2.3.4.", false), new ResultPair("1.2.3", false), new ResultPair(".1.2.3.4", false), new ResultPair("go.a", false), new ResultPair("go.a1a", true), new ResultPair("go.1aa", false), new ResultPair("aaa.", false), new ResultPair(".aaa", false), new ResultPair("aaa", false), new ResultPair("", false)};
    ResultPair[] testUrlPort = new ResultPair[]{new ResultPair(":80", true), new ResultPair(":65535", true), new ResultPair(":0", true), new ResultPair("", true), new ResultPair(":-1", false), new ResultPair(":65636", true), new ResultPair(":65a", false)};
    ResultPair[] testPath = new ResultPair[]{new ResultPair("/test1", true), new ResultPair("/t123", true), new ResultPair("/$23", true), new ResultPair("/..", false), new ResultPair("/../", false), new ResultPair("/test1/", true), new ResultPair("", true), new ResultPair("/test1/file", true), new ResultPair("/..//file", false), new ResultPair("/test1//file", false)};
    ResultPair[] testUrlPathOptions = new ResultPair[]{new ResultPair("/test1", true), new ResultPair("/t123", true), new ResultPair("/$23", true), new ResultPair("/..", false), new ResultPair("/../", false), new ResultPair("/test1/", true), new ResultPair("/#", false), new ResultPair("", true), new ResultPair("/test1/file", true), new ResultPair("/t123/file", true), new ResultPair("/$23/file", true), new ResultPair("/../file", false), new ResultPair("/..//file", false), new ResultPair("/test1//file", true), new ResultPair("/#/file", false)};
    ResultPair[] testUrlQuery = new ResultPair[]{new ResultPair("?action=view", true), new ResultPair("?action=edit&mode=up", true), new ResultPair("", true)};
    Object[] testUrlParts = new Object[]{this.testUrlScheme, this.testUrlAuthority, this.testUrlPort, this.testPath, this.testUrlQuery};
    Object[] testUrlPartsOptions = new Object[]{this.testUrlScheme, this.testUrlAuthority, this.testUrlPort, this.testUrlPathOptions, this.testUrlQuery};
    int[] testPartsIndex = new int[]{0, 0, 0, 0, 0};
    ResultPair[] testScheme = new ResultPair[]{new ResultPair("http", true), new ResultPair("ftp", false), new ResultPair("httpd", false), new ResultPair("telnet", false)};

    static boolean incrementTestPartsIndex(int[] testPartsIndex, Object[] testParts) {
        boolean carry = true;
        boolean maxIndex = true;
        for (int testPartsIndexIndex = testPartsIndex.length - 1; testPartsIndexIndex >= 0; --testPartsIndexIndex) {
            int index = testPartsIndex[testPartsIndexIndex];
            ResultPair[] part = (ResultPair[])testParts[testPartsIndexIndex];
            if (carry) {
                if (index < part.length - 1) {
                    testPartsIndex[testPartsIndexIndex] = ++index;
                    carry = false;
                } else {
                    testPartsIndex[testPartsIndexIndex] = 0;
                    carry = true;
                }
            }
            maxIndex &= index == part.length - 1;
        }
        return !maxIndex;
    }

    public static void main(String[] argv) {
        UrlTest fct = new UrlTest();
        fct.setUp();
        fct.testIsValid();
        fct.testIsValidScheme();
    }

    @BeforeEach
    protected void setUp() {
        for (int index = 0; index < this.testPartsIndex.length - 1; ++index) {
            this.testPartsIndex[index] = 0;
        }
    }

    @Test
    public void testIsValid() {
        this.testIsValid(this.testUrlParts, 1);
        this.setUp();
        int options = 7;
        this.testIsValid(this.testUrlPartsOptions, 7);
    }

    void testIsValid(Object[] testObjects, int options) {
        UrlValidator urlVal = new UrlValidator(null, options);
        Assertions.assertTrue((boolean)urlVal.isValid("http://www.google.com"));
        Assertions.assertTrue((boolean)urlVal.isValid("http://www.google.com/"));
        int statusPerLine = 60;
        boolean printed = false;
        do {
            StringBuilder testBuffer = new StringBuilder();
            boolean expected = true;
            for (int testPartsIndexIndex = 0; testPartsIndexIndex < this.testPartsIndex.length; ++testPartsIndexIndex) {
                int index = this.testPartsIndex[testPartsIndexIndex];
                ResultPair[] part = (ResultPair[])testObjects[testPartsIndexIndex];
                testBuffer.append(part[index].item);
                expected &= part[index].valid;
            }
            String url = testBuffer.toString();
            boolean result = urlVal.isValid(url);
            Assertions.assertEquals((Object)expected, (Object)result, (String)url);
        } while (UrlTest.incrementTestPartsIndex(this.testPartsIndex, testObjects));
    }

    @Test
    public void testIsValidScheme() {
        String[] schemes = new String[]{"http", "gopher"};
        UrlValidator urlVal = new UrlValidator(schemes, 0);
        for (ResultPair testPair : this.testScheme) {
            boolean result = urlVal.isValidScheme(testPair.item);
            Assertions.assertEquals((Object)testPair.valid, (Object)result, (String)testPair.item);
        }
    }

    private String testPartsIndextoString() {
        StringBuilder carryMsg = new StringBuilder("{");
        for (int testPartsIndexIndex = 0; testPartsIndexIndex < this.testPartsIndex.length; ++testPartsIndexIndex) {
            carryMsg.append(this.testPartsIndex[testPartsIndexIndex]);
            if (testPartsIndexIndex < this.testPartsIndex.length - 1) {
                carryMsg.append(',');
                continue;
            }
            carryMsg.append('}');
        }
        return carryMsg.toString();
    }

    @Test
    public void testValidateUrl() {
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testValidator202() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes, 4);
        urlValidator.isValid("http://www.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.logoworks.comwww.log");
    }

    @Test
    public void testValidator204() {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        Assertions.assertTrue((boolean)urlValidator.isValid("http://tech.yahoo.com/rc/desktops/102;_ylt=Ao8yevQHlZ4On0O3ZJGXLEQFLZA5"));
    }
}

