/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.PercentValidator;

public class PercentValidatorTest
extends TestCase {
    protected PercentValidator validator;

    public PercentValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new PercentValidator();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.validator = null;
    }

    public void testFormatType() {
        PercentValidatorTest.assertEquals((String)"Format Type A", (int)2, (int)PercentValidator.getInstance().getFormatType());
        PercentValidatorTest.assertEquals((String)"Format Type B", (int)2, (int)PercentValidator.getInstance().getFormatType());
    }

    public void testValid() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        BigDecimalValidator validator = PercentValidator.getInstance();
        BigDecimal expected = new BigDecimal("0.12");
        BigDecimal negative = new BigDecimal("-0.12");
        BigDecimal hundred = new BigDecimal("1.00");
        PercentValidatorTest.assertEquals((String)"Default locale", (Object)expected, (Object)validator.validate("12%"));
        PercentValidatorTest.assertEquals((String)"Default negtve", (Object)negative, (Object)validator.validate("-12%"));
        PercentValidatorTest.assertEquals((String)"UK locale", (Object)expected, (Object)validator.validate("12%", Locale.UK));
        PercentValidatorTest.assertEquals((String)"UK negative", (Object)negative, (Object)validator.validate("-12%", Locale.UK));
        PercentValidatorTest.assertEquals((String)"UK No symbol", (Object)expected, (Object)validator.validate("12", Locale.UK));
        PercentValidatorTest.assertEquals((String)"US locale", (Object)expected, (Object)validator.validate("12%", Locale.US));
        PercentValidatorTest.assertEquals((String)"US negative", (Object)negative, (Object)validator.validate("-12%", Locale.US));
        PercentValidatorTest.assertEquals((String)"US No symbol", (Object)expected, (Object)validator.validate("12", Locale.US));
        PercentValidatorTest.assertEquals((String)"100%", (Object)hundred, (Object)validator.validate("100%"));
        Locale.setDefault(origDefault);
    }

    public void testInvalid() {
        BigDecimalValidator validator = PercentValidator.getInstance();
        PercentValidatorTest.assertFalse((String)"isValid() Null Value", (boolean)validator.isValid(null));
        PercentValidatorTest.assertFalse((String)"isValid() Empty Value", (boolean)validator.isValid(""));
        PercentValidatorTest.assertNull((String)"validate() Null Value", (Object)validator.validate(null));
        PercentValidatorTest.assertNull((String)"validate() Empty Value", (Object)validator.validate(""));
        PercentValidatorTest.assertFalse((String)"UK wrong symbol", (boolean)validator.isValid("12@", Locale.UK));
        PercentValidatorTest.assertFalse((String)"UK wrong negative", (boolean)validator.isValid("(12%)", Locale.UK));
        PercentValidatorTest.assertFalse((String)"US wrong symbol", (boolean)validator.isValid("12@", Locale.US));
        PercentValidatorTest.assertFalse((String)"US wrong negative", (boolean)validator.isValid("(12%)", Locale.US));
    }
}

