/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.ISBNValidator;

public class ISBNValidatorTest
extends TestCase {
    private final String[] validISBN10Format = new String[]{"1234567890", "123456789X", "12345-1234567-123456-X", "12345 1234567 123456 X", "1-2-3-4", "1 2 3 4"};
    private final String[] invalidISBN10Format = new String[]{"", "   ", "1", "123456789", "12345678901", "12345678X0", "123456-1234567-123456-X", "12345-12345678-123456-X", "12345-1234567-1234567-X", "12345-1234567-123456-X2", "--1 930110 99 5", "1 930110 99 5--", "1 930110-99 5-", "1.2.3.4", "1=2=3=4", "1_2_3_4", "123456789Y", "dsasdsadsa", "I love sparrows!", "068-556-98-45"};
    private final String[] validISBN13Format = new String[]{"9781234567890", "9791234567890", "978-12345-1234567-123456-1", "979-12345-1234567-123456-1", "978 12345 1234567 123456 1", "979 12345 1234567 123456 1", "978-1-2-3-4", "979-1-2-3-4", "978 1 2 3 4", "979 1 2 3 4"};
    private final String[] invalidISBN13Format = new String[]{"", "   ", "1", "978123456789", "97812345678901", "978-123456-1234567-123456-1", "978-12345-12345678-123456-1", "978-12345-1234567-1234567-1", "978-12345-1234567-123456-12", "--978 1 930110 99 1", "978 1 930110 99 1--", "978 1 930110-99 1-", "123-4-567890-12-8", "978.1.2.3.4", "978=1=2=3=4", "978_1_2_3_4", "978123456789X", "978-0-201-63385-X", "dsasdsadsadsa", "I love sparrows!", "979-1-234-567-89-6"};

    public ISBNValidatorTest(String name) {
        super(name);
    }

    public void testValidISBN10Format() {
        Pattern pattern = Pattern.compile("^(?:(\\d{9}[0-9X])|(?:(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9X])))$");
        for (int i = 0; i < this.validISBN10Format.length; ++i) {
            ISBNValidatorTest.assertTrue((String)("Pattern[" + i + "]=" + this.validISBN10Format[i]), (boolean)pattern.matcher(this.validISBN10Format[i]).matches());
        }
    }

    public void testInvalidISBN10Format() {
        ISBNValidator validator = ISBNValidator.getInstance();
        Pattern pattern = Pattern.compile("^(?:(\\d{9}[0-9X])|(?:(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9X])))$");
        for (int i = 0; i < this.invalidISBN10Format.length; ++i) {
            ISBNValidatorTest.assertFalse((String)("Pattern[" + i + "]=" + this.invalidISBN10Format[i]), (boolean)pattern.matcher(this.invalidISBN10Format[i]).matches());
            ISBNValidatorTest.assertFalse((String)("isValidISBN10[" + i + "]=" + this.invalidISBN10Format[i]), (boolean)validator.isValidISBN10(this.invalidISBN10Format[i]));
            ISBNValidatorTest.assertNull((String)("validateISBN10[" + i + "]=" + this.invalidISBN10Format[i]), (Object)validator.validateISBN10(this.invalidISBN10Format[i]));
        }
    }

    public void testValidISBN13Format() {
        Pattern pattern = Pattern.compile("^(978|979)(?:(\\d{10})|(?:(?:\\-|\\s)(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9])))$");
        for (int i = 0; i < this.validISBN13Format.length; ++i) {
            ISBNValidatorTest.assertTrue((String)("Pattern[" + i + "]=" + this.validISBN13Format[i]), (boolean)pattern.matcher(this.validISBN13Format[i]).matches());
        }
    }

    public void testInvalidISBN13Format() {
        Pattern pattern = Pattern.compile("^(978|979)(?:(\\d{10})|(?:(?:\\-|\\s)(\\d{1,5})(?:\\-|\\s)(\\d{1,7})(?:\\-|\\s)(\\d{1,6})(?:\\-|\\s)([0-9])))$");
        ISBNValidator validator = ISBNValidator.getInstance();
        for (int i = 0; i < this.invalidISBN13Format.length; ++i) {
            ISBNValidatorTest.assertFalse((String)("Pattern[" + i + "]=" + this.invalidISBN13Format[i]), (boolean)pattern.matcher(this.invalidISBN13Format[i]).matches());
            ISBNValidatorTest.assertFalse((String)("isValidISBN13[" + i + "]=" + this.invalidISBN13Format[i]), (boolean)validator.isValidISBN13(this.invalidISBN13Format[i]));
            ISBNValidatorTest.assertNull((String)("validateISBN13[" + i + "]=" + this.invalidISBN13Format[i]), (Object)validator.validateISBN13(this.invalidISBN13Format[i]));
        }
    }

    public void testIsValidISBN10() {
        ISBNValidator validator = ISBNValidator.getInstance();
        ISBNValidatorTest.assertTrue((String)"isValidISBN10-1", (boolean)validator.isValidISBN10("1930110995"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN10-2", (boolean)validator.isValidISBN10("1-930110-99-5"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN10-3", (boolean)validator.isValidISBN10("1 930110 99 5"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN10-4", (boolean)validator.isValidISBN10("020163385X"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN10-5", (boolean)validator.isValidISBN10("0-201-63385-X"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN10-6", (boolean)validator.isValidISBN10("0 201 63385 X"));
        ISBNValidatorTest.assertTrue((String)"isValid-1", (boolean)validator.isValid("1930110995"));
        ISBNValidatorTest.assertTrue((String)"isValid-2", (boolean)validator.isValid("1-930110-99-5"));
        ISBNValidatorTest.assertTrue((String)"isValid-3", (boolean)validator.isValid("1 930110 99 5"));
        ISBNValidatorTest.assertTrue((String)"isValid-4", (boolean)validator.isValid("020163385X"));
        ISBNValidatorTest.assertTrue((String)"isValid-5", (boolean)validator.isValid("0-201-63385-X"));
        ISBNValidatorTest.assertTrue((String)"isValid-6", (boolean)validator.isValid("0 201 63385 X"));
    }

    public void testIsValidISBN13() {
        ISBNValidator validator = ISBNValidator.getInstance();
        ISBNValidatorTest.assertTrue((String)"isValidISBN13-1", (boolean)validator.isValidISBN13("9781930110991"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN13-2", (boolean)validator.isValidISBN13("978-1-930110-99-1"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN13-3", (boolean)validator.isValidISBN13("978 1 930110 99 1"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN13-4", (boolean)validator.isValidISBN13("9780201633856"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN13-5", (boolean)validator.isValidISBN13("978-0-201-63385-6"));
        ISBNValidatorTest.assertTrue((String)"isValidISBN13-6", (boolean)validator.isValidISBN13("978 0 201 63385 6"));
        ISBNValidatorTest.assertTrue((String)"isValid-1", (boolean)validator.isValid("9781930110991"));
        ISBNValidatorTest.assertTrue((String)"isValid-2", (boolean)validator.isValid("978-1-930110-99-1"));
        ISBNValidatorTest.assertTrue((String)"isValid-3", (boolean)validator.isValid("978 1 930110 99 1"));
        ISBNValidatorTest.assertTrue((String)"isValid-4", (boolean)validator.isValid("9780201633856"));
        ISBNValidatorTest.assertTrue((String)"isValid-5", (boolean)validator.isValid("978-0-201-63385-6"));
        ISBNValidatorTest.assertTrue((String)"isValid-6", (boolean)validator.isValid("978 0 201 63385 6"));
    }

    public void testValidateISBN10() {
        ISBNValidator validator = ISBNValidator.getInstance((boolean)false);
        ISBNValidatorTest.assertEquals((String)"validateISBN10-1", (String)"1930110995", (String)validator.validateISBN10("1930110995"));
        ISBNValidatorTest.assertEquals((String)"validateISBN10-2", (String)"1930110995", (String)validator.validateISBN10("1-930110-99-5"));
        ISBNValidatorTest.assertEquals((String)"validateISBN10-3", (String)"1930110995", (String)validator.validateISBN10("1 930110 99 5"));
        ISBNValidatorTest.assertEquals((String)"validateISBN10-4", (String)"020163385X", (String)validator.validateISBN10("020163385X"));
        ISBNValidatorTest.assertEquals((String)"validateISBN10-5", (String)"020163385X", (String)validator.validateISBN10("0-201-63385-X"));
        ISBNValidatorTest.assertEquals((String)"validateISBN10-6", (String)"020163385X", (String)validator.validateISBN10("0 201 63385 X"));
        ISBNValidatorTest.assertEquals((String)"validate-1", (String)"1930110995", (String)validator.validate("1930110995"));
        ISBNValidatorTest.assertEquals((String)"validate-2", (String)"1930110995", (String)validator.validate("1-930110-99-5"));
        ISBNValidatorTest.assertEquals((String)"validate-3", (String)"1930110995", (String)validator.validate("1 930110 99 5"));
        ISBNValidatorTest.assertEquals((String)"validate-4", (String)"020163385X", (String)validator.validate("020163385X"));
        ISBNValidatorTest.assertEquals((String)"validate-5", (String)"020163385X", (String)validator.validate("0-201-63385-X"));
        ISBNValidatorTest.assertEquals((String)"validate-6", (String)"020163385X", (String)validator.validate("0 201 63385 X"));
    }

    public void testValidateISBN10Convert() {
        ISBNValidator validator = ISBNValidator.getInstance();
        ISBNValidatorTest.assertEquals((String)"validate-1", (String)"9781930110991", (String)validator.validate("1930110995"));
        ISBNValidatorTest.assertEquals((String)"validate-2", (String)"9781930110991", (String)validator.validate("1-930110-99-5"));
        ISBNValidatorTest.assertEquals((String)"validate-3", (String)"9781930110991", (String)validator.validate("1 930110 99 5"));
        ISBNValidatorTest.assertEquals((String)"validate-4", (String)"9780201633856", (String)validator.validate("020163385X"));
        ISBNValidatorTest.assertEquals((String)"validate-5", (String)"9780201633856", (String)validator.validate("0-201-63385-X"));
        ISBNValidatorTest.assertEquals((String)"validate-6", (String)"9780201633856", (String)validator.validate("0 201 63385 X"));
    }

    public void testValidateISBN13() {
        ISBNValidator validator = ISBNValidator.getInstance();
        ISBNValidatorTest.assertEquals((String)"validateISBN13-1", (String)"9781930110991", (String)validator.validateISBN13("9781930110991"));
        ISBNValidatorTest.assertEquals((String)"validateISBN13-2", (String)"9781930110991", (String)validator.validateISBN13("978-1-930110-99-1"));
        ISBNValidatorTest.assertEquals((String)"validateISBN13-3", (String)"9781930110991", (String)validator.validateISBN13("978 1 930110 99 1"));
        ISBNValidatorTest.assertEquals((String)"validateISBN13-4", (String)"9780201633856", (String)validator.validateISBN13("9780201633856"));
        ISBNValidatorTest.assertEquals((String)"validateISBN13-5", (String)"9780201633856", (String)validator.validateISBN13("978-0-201-63385-6"));
        ISBNValidatorTest.assertEquals((String)"validateISBN13-6", (String)"9780201633856", (String)validator.validateISBN13("978 0 201 63385 6"));
        ISBNValidatorTest.assertEquals((String)"validate-1", (String)"9781930110991", (String)validator.validate("9781930110991"));
        ISBNValidatorTest.assertEquals((String)"validate-2", (String)"9781930110991", (String)validator.validate("978-1-930110-99-1"));
        ISBNValidatorTest.assertEquals((String)"validate-3", (String)"9781930110991", (String)validator.validate("978 1 930110 99 1"));
        ISBNValidatorTest.assertEquals((String)"validate-4", (String)"9780201633856", (String)validator.validate("9780201633856"));
        ISBNValidatorTest.assertEquals((String)"validate-5", (String)"9780201633856", (String)validator.validate("978-0-201-63385-6"));
        ISBNValidatorTest.assertEquals((String)"validate-6", (String)"9780201633856", (String)validator.validate("978 0 201 63385 6"));
    }

    public void testNull() {
        ISBNValidator validator = ISBNValidator.getInstance();
        ISBNValidatorTest.assertFalse((String)"isValid", (boolean)validator.isValid(null));
        ISBNValidatorTest.assertFalse((String)"isValidISBN10", (boolean)validator.isValidISBN10(null));
        ISBNValidatorTest.assertFalse((String)"isValidISBN13", (boolean)validator.isValidISBN13(null));
        ISBNValidatorTest.assertNull((String)"validate", (Object)validator.validate(null));
        ISBNValidatorTest.assertNull((String)"validateISBN10", (Object)validator.validateISBN10(null));
        ISBNValidatorTest.assertNull((String)"validateISBN13", (Object)validator.validateISBN13(null));
        ISBNValidatorTest.assertNull((String)"convertToISBN13", (Object)validator.convertToISBN13(null));
    }

    public void testInvalid() {
        ISBNValidator validator = ISBNValidator.getInstance();
        String baseCode = "193011099";
        ISBNValidatorTest.assertFalse((String)"ISBN10-0", (boolean)validator.isValid(baseCode + "0"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-1", (boolean)validator.isValid(baseCode + "1"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-2", (boolean)validator.isValid(baseCode + "2"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-3", (boolean)validator.isValid(baseCode + "3"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-4", (boolean)validator.isValid(baseCode + "4"));
        ISBNValidatorTest.assertTrue((String)"ISBN10-5", (boolean)validator.isValid(baseCode + "5"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-6", (boolean)validator.isValid(baseCode + "6"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-7", (boolean)validator.isValid(baseCode + "7"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-8", (boolean)validator.isValid(baseCode + "8"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-9", (boolean)validator.isValid(baseCode + "9"));
        ISBNValidatorTest.assertFalse((String)"ISBN10-X", (boolean)validator.isValid(baseCode + "X"));
        baseCode = "978193011099";
        ISBNValidatorTest.assertFalse((String)"ISBN13-0", (boolean)validator.isValid(baseCode + "0"));
        ISBNValidatorTest.assertTrue((String)"ISBN13-1", (boolean)validator.isValid(baseCode + "1"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-2", (boolean)validator.isValid(baseCode + "2"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-3", (boolean)validator.isValid(baseCode + "3"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-4", (boolean)validator.isValid(baseCode + "4"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-5", (boolean)validator.isValid(baseCode + "5"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-6", (boolean)validator.isValid(baseCode + "6"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-7", (boolean)validator.isValid(baseCode + "7"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-8", (boolean)validator.isValid(baseCode + "8"));
        ISBNValidatorTest.assertFalse((String)"ISBN13-9", (boolean)validator.isValid(baseCode + "9"));
    }

    public void testConversionErrors() {
        ISBNValidator validator = ISBNValidator.getInstance();
        String input = null;
        try {
            input = "123456789 ";
            validator.convertToISBN13(input);
            ISBNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            input = "12345678901";
            validator.convertToISBN13(input);
            ISBNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            input = "";
            validator.convertToISBN13(input);
            ISBNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            input = "X234567890";
            validator.convertToISBN13(input);
            ISBNValidatorTest.fail((String)("Expected IllegalArgumentException for '" + input + "'"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

