/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.ArrayList;
import org.apache.commons.validator.ResultPair;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class EmailValidatorTest {
    protected static String FORM_KEY = "emailForm";
    protected static String ACTION = "email";
    private EmailValidator validator;
    private static final ResultPair[] testEmailFromPerl = new ResultPair[]{new ResultPair("abigail@example.com", true), new ResultPair("abigail@example.com ", true), new ResultPair(" abigail@example.com", true), new ResultPair("abigail @example.com ", true), new ResultPair("*@example.net", true), new ResultPair("\"\\\"\"@foo.bar", true), new ResultPair("fred&barny@example.com", true), new ResultPair("---@example.com", true), new ResultPair("foo-bar@example.net", true), new ResultPair("\"127.0.0.1\"@[127.0.0.1]", true), new ResultPair("Abigail <abigail@example.com>", true), new ResultPair("Abigail<abigail@example.com>", true), new ResultPair("Abigail<@a,@b,@c:abigail@example.com>", true), new ResultPair("\"This is a phrase\"<abigail@example.com>", true), new ResultPair("\"Abigail \"<abigail@example.com>", true), new ResultPair("\"Joe & J. Harvey\" <example @Org>", true), new ResultPair("Abigail <abigail @ example.com>", true), new ResultPair("Abigail made this <  abigail   @   example  .    com    >", true), new ResultPair("Abigail(the bitch)@example.com", true), new ResultPair("Abigail <abigail @ example . (bar) com >", true), new ResultPair("Abigail < (one)  abigail (two) @(three)example . (bar) com (quz) >", true), new ResultPair("Abigail (foo) (((baz)(nested) (comment)) ! ) < (one)  abigail (two) @(three)example . (bar) com (quz) >", true), new ResultPair("Abigail <abigail(fo\\(o)@example.com>", true), new ResultPair("Abigail <abigail(fo\\)o)@example.com> ", true), new ResultPair("(foo) abigail@example.com", true), new ResultPair("abigail@example.com (foo)", true), new ResultPair("\"Abi\\\"gail\" <abigail@example.com>", true), new ResultPair("abigail@[example.com]", true), new ResultPair("abigail@[exa\\[ple.com]", true), new ResultPair("abigail@[exa\\]ple.com]", true), new ResultPair("\":sysmail\"@  Some-Group. Some-Org", true), new ResultPair("Muhammed.(I am  the greatest) Ali @(the)Vegas.WBA", true), new ResultPair("mailbox.sub1.sub2@this-domain", true), new ResultPair("sub-net.mailbox@sub-domain.domain", true), new ResultPair("name:;", true), new ResultPair("':;", true), new ResultPair("name:   ;", true), new ResultPair("Alfred Neuman <Neuman@BBN-TENEXA>", true), new ResultPair("Neuman@BBN-TENEXA", true), new ResultPair("\"George, Ted\" <Shared@Group.Arpanet>", true), new ResultPair("Wilt . (the  Stilt) Chamberlain@NBA.US", true), new ResultPair("Cruisers:  Port@Portugal, Jones@SEA;", true), new ResultPair("$@[]", true), new ResultPair("*()@[]", true), new ResultPair("\"quoted ( brackets\" ( a comment )@example.com", true), new ResultPair("\"Joe & J. Harvey\"\\x0D\\x0A     <ddd\\@ Org>", true), new ResultPair("\"Joe &\\x0D\\x0A J. Harvey\" <ddd \\@ Org>", true), new ResultPair("Gourmets:  Pompous Person <WhoZiWhatZit\\@Cordon-Bleu>,\\x0D\\x0A        Childs\\@WGBH.Boston, \"Galloping Gourmet\"\\@\\x0D\\x0A        ANT.Down-Under (Australian National Television),\\x0D\\x0A        Cheapie\\@Discount-Liquors;", true), new ResultPair("   Just a string", false), new ResultPair("string", false), new ResultPair("(comment)", false), new ResultPair("()@example.com", false), new ResultPair("fred(&)barny@example.com", false), new ResultPair("fred\\ barny@example.com", false), new ResultPair("Abigail <abi gail @ example.com>", false), new ResultPair("Abigail <abigail(fo(o)@example.com>", false), new ResultPair("Abigail <abigail(fo)o)@example.com>", false), new ResultPair("\"Abi\"gail\" <abigail@example.com>", false), new ResultPair("abigail@[exa]ple.com]", false), new ResultPair("abigail@[exa[ple.com]", false), new ResultPair("abigail@[exaple].com]", false), new ResultPair("abigail@", false), new ResultPair("@example.com", false), new ResultPair("phrase: abigail@example.com abigail@example.com ;", false), new ResultPair("invalid\ufffdchar@example.com", false)};

    @Before
    public void setUp() {
        this.validator = EmailValidator.getInstance();
    }

    @Test
    public void testEmail() {
        Assert.assertTrue((boolean)this.validator.isValid("jsmith@apache.org"));
    }

    @Test
    public void testEmailWithNumericAddress() {
        Assert.assertTrue((boolean)this.validator.isValid("someone@[216.109.118.76]"));
        Assert.assertTrue((boolean)this.validator.isValid("someone@yahoo.com"));
    }

    @Test
    public void testEmailExtension() {
        Assert.assertTrue((boolean)this.validator.isValid("jsmith@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("jsmith@apache.com"));
        Assert.assertTrue((boolean)this.validator.isValid("jsmith@apache.net"));
        Assert.assertTrue((boolean)this.validator.isValid("jsmith@apache.info"));
        Assert.assertFalse((boolean)this.validator.isValid("jsmith@apache."));
        Assert.assertFalse((boolean)this.validator.isValid("jsmith@apache.c"));
        Assert.assertTrue((boolean)this.validator.isValid("someone@yahoo.museum"));
        Assert.assertFalse((boolean)this.validator.isValid("someone@yahoo.mu-seum"));
    }

    @Test
    public void testEmailWithDash() {
        Assert.assertTrue((boolean)this.validator.isValid("andy.noble@data-workshop.com"));
        Assert.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.-com"));
        Assert.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.c-om"));
        Assert.assertFalse((boolean)this.validator.isValid("andy-noble@data-workshop.co-m"));
    }

    @Test
    public void testEmailWithDotEnd() {
        Assert.assertFalse((boolean)this.validator.isValid("andy.noble@data-workshop.com."));
    }

    @Test
    public void testEmailWithBogusCharacter() {
        Assert.assertFalse((boolean)this.validator.isValid("andy.noble@\u008fdata-workshop.com"));
        Assert.assertTrue((boolean)this.validator.isValid("andy.o'reilly@data-workshop.com"));
        Assert.assertFalse((boolean)this.validator.isValid("andy@o'reilly.data-workshop.com"));
        Assert.assertTrue((boolean)this.validator.isValid("foo+bar@i.am.not.in.us.example.com"));
        Assert.assertFalse((boolean)this.validator.isValid("foo+bar@example+3.com"));
        Assert.assertFalse((boolean)this.validator.isValid("test@%*.com"));
        Assert.assertFalse((boolean)this.validator.isValid("test@^&#.com"));
    }

    @Test
    public void testVALIDATOR_315() {
        Assert.assertFalse((boolean)this.validator.isValid("me@at&t.net"));
        Assert.assertTrue((boolean)this.validator.isValid("me@att.net"));
    }

    @Test
    public void testVALIDATOR_278() {
        Assert.assertFalse((boolean)this.validator.isValid("someone@-test.com"));
        Assert.assertFalse((boolean)this.validator.isValid("someone@test-.com"));
    }

    @Test
    public void testValidator235() {
        String version = System.getProperty("java.version");
        if (version.compareTo("1.6") < 0) {
            System.out.println("Cannot run Unicode IDN tests");
            return;
        }
        Assert.assertTrue((String)"xn--d1abbgf6aiiy.xn--p1ai should validate", (boolean)this.validator.isValid("someone@xn--d1abbgf6aiiy.xn--p1ai"));
        Assert.assertTrue((String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate", (boolean)this.validator.isValid("someone@\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"));
        Assert.assertTrue((String)"www.b\u00fccher.ch should validate", (boolean)this.validator.isValid("someone@www.b\u00fccher.ch"));
        Assert.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)this.validator.isValid("someone@www.\ufffd.ch"));
        Assert.assertTrue((String)"www.b\u00fccher.ch should validate", (boolean)this.validator.isValid("someone@www.b\u00fccher.ch"));
        Assert.assertFalse((String)"www.\ufffd.ch FFFD should fail", (boolean)this.validator.isValid("someone@www.\ufffd.ch"));
    }

    @Test
    public void testEmailWithCommas() {
        Assert.assertFalse((boolean)this.validator.isValid("joeblow@apa,che.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joeblow@apache.o,rg"));
        Assert.assertFalse((boolean)this.validator.isValid("joeblow@apache,org"));
    }

    @Test
    public void testEmailWithSpaces() {
        Assert.assertFalse((boolean)this.validator.isValid("joeblow @apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joeblow@ apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid(" joeblow@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joeblow@apache.org "));
        Assert.assertFalse((boolean)this.validator.isValid("joe blow@apache.org "));
        Assert.assertFalse((boolean)this.validator.isValid("joeblow@apa che.org "));
        Assert.assertTrue((boolean)this.validator.isValid("\"joeblow \"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\" joeblow\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\" joe blow \"@apache.org"));
    }

    @Test
    public void testEmailWithControlChars() {
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            Assert.assertFalse((String)("Test control char " + c), (boolean)this.validator.isValid("foo" + c + "bar@domain.com"));
        }
        Assert.assertFalse((String)"Test control char 127", (boolean)this.validator.isValid("foo\u007fbar@domain.com"));
    }

    @Test
    public void testEmailLocalhost() {
        EmailValidator noLocal = EmailValidator.getInstance((boolean)false);
        EmailValidator allowLocal = EmailValidator.getInstance((boolean)true);
        Assert.assertEquals((Object)this.validator, (Object)noLocal);
        Assert.assertTrue((String)"@localhost.localdomain should be accepted but wasn't", (boolean)allowLocal.isValid("joe@localhost.localdomain"));
        Assert.assertTrue((String)"@localhost should be accepted but wasn't", (boolean)allowLocal.isValid("joe@localhost"));
        Assert.assertFalse((String)"@localhost.localdomain should be accepted but wasn't", (boolean)noLocal.isValid("joe@localhost.localdomain"));
        Assert.assertFalse((String)"@localhost should be accepted but wasn't", (boolean)noLocal.isValid("joe@localhost"));
    }

    @Test
    public void testEmailWithSlashes() {
        Assert.assertTrue((String)"/ and ! valid in username", (boolean)this.validator.isValid("joe!/blow@apache.org"));
        Assert.assertFalse((String)"/ not valid in domain", (boolean)this.validator.isValid("joe@ap/ache.org"));
        Assert.assertFalse((String)"! not valid in domain", (boolean)this.validator.isValid("joe@apac!he.org"));
    }

    @Test
    public void testEmailUserName() {
        Assert.assertTrue((boolean)this.validator.isValid("joe1blow@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe$blow@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe-@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe_@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe+@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe!@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe*@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe'@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe%45@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe?@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe&@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe=@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("+joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("!joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("*joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("'joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("%joe45@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("?joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("&joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("=joe@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("+@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("!@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("*@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("'@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("%@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("?@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("&@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("=@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joe.@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid(".joe@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid(".@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("joe.ok@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joe..ok@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("..@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joe(@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joe)@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joe,@apache.org"));
        Assert.assertFalse((boolean)this.validator.isValid("joe;@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe.\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\".joe\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe+\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe@\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe!\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe*\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe'\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe(\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe)\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe,\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe%45\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe;\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe?\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe&\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"joe=\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"..\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("\"john\\\"doe\"@apache.org"));
        Assert.assertTrue((boolean)this.validator.isValid("john56789.john56789.john56789.john56789.john56789.john56789.john@example.com"));
        Assert.assertFalse((boolean)this.validator.isValid("john56789.john56789.john56789.john56789.john56789.john56789.john5@example.com"));
        Assert.assertTrue((boolean)this.validator.isValid("\\>escape\\\\special\\^characters\\<@example.com"));
        Assert.assertTrue((boolean)this.validator.isValid("Abc\\@def@example.com"));
        Assert.assertFalse((boolean)this.validator.isValid("Abc@def@example.com"));
        Assert.assertTrue((boolean)this.validator.isValid("space\\ monkey@example.com"));
    }

    @Ignore(value="VALIDATOR-267")
    @Test
    public void testEmailFromPerl() {
        int errors = 0;
        for (int index = 0; index < testEmailFromPerl.length; ++index) {
            String item = EmailValidatorTest.testEmailFromPerl[index].item;
            boolean exp = EmailValidatorTest.testEmailFromPerl[index].valid;
            boolean act = this.validator.isValid(item);
            if (act == exp) continue;
            System.out.printf("%s: expected %s actual %s%n", item, exp, act);
            ++errors;
        }
        Assert.assertEquals((String)"Expected 0 errors", (long)0L, (long)errors);
    }

    @Test
    public void testValidator293() {
        Assert.assertTrue((boolean)this.validator.isValid("abc-@abc.com"));
        Assert.assertTrue((boolean)this.validator.isValid("abc_@abc.com"));
        Assert.assertTrue((boolean)this.validator.isValid("abc-def@abc.com"));
        Assert.assertTrue((boolean)this.validator.isValid("abc_def@abc.com"));
        Assert.assertFalse((boolean)this.validator.isValid("abc@abc_def.com"));
    }

    @Test
    public void testValidator365() {
        Assert.assertFalse((boolean)this.validator.isValid("Loremipsumdolorsitametconsecteturadipiscingelit.Nullavitaeligulamattisrhoncusnuncegestasmattisleo.Donecnonsapieninmagnatristiquedictumaacturpis.Fusceorciduifacilisisutsapieneuconsequatpharetralectus.Quisqueenimestpulvinarutquamvitaeportamattisex.Nullamquismaurisplaceratconvallisjustoquisportamauris.Innullalacusconvalliseufringillautvenenatissitametdiam.Maecenasluctusligulascelerisquepulvinarfeugiat.Sedmolestienullaaliquetorciluctusidpharetranislfinibus.Suspendissemalesuadatinciduntduisitametportaarcusollicitudinnec.Donecetmassamagna.Curabitururnadiampretiumveldignissimporttitorfringillaeuneque.Duisantetelluspharetraidtinciduntinterdummolestiesitametfelis.Utquisquamsitametantesagittisdapibusacnonodio.Namrutrummolestiediamidmattis.Cumsociisnatoquepenatibusetmagnisdisparturientmontesnasceturridiculusmus.Morbiposueresedmetusacconsectetur.Etiamquisipsumvitaejustotempusmaximus.Sedultriciesplaceratvolutpat.Integerlacuslectusmaximusacornarequissagittissitametjusto.Cumsociisnatoquepenatibusetmagnisdisparturientmontesnasceturridiculusmus.Maecenasindictumpurussedrutrumex.Nullafacilisi.Integerfinibusfinibusmietpharetranislfaucibusvel.Maecenasegetdolorlacinialobortisjustovelullamcorpersem.Vivamusaliquetpurusidvariusornaresapienrisusrutrumnisitinciduntmollissemnequeidmetus.Etiamquiseleifendpurus.Nuncfelisnuncscelerisqueiddignissimnecfinibusalibero.Nuncsemperenimnequesitamethendreritpurusfacilisisac.Maurisdapibussemperfelisdignissimgravida.Aeneanultricesblanditnequealiquamfinibusodioscelerisqueac.Aliquamnecmassaeumaurisfaucibusfringilla.Etiamconsequatligulanisisitametaliquamnibhtemporquis.Nuncinterdumdignissimnullaatsodalesarcusagittiseu.Proinpharetrametusneclacuspulvinarsedvolutpatliberoornare.Sedligulanislpulvinarnonlectuseublanditfacilisisante.Sedmollisnislalacusauctorsuscipit.Inhachabitasseplateadictumst.Phasellussitametvelittemporvenenatisfeliseuegestasrisus.Aliquameteratsitametnibhcommodofinibus.Morbiefficiturodiovelpulvinariaculis.Aeneantemporipsummassaaconsecteturturpisfaucibusultrices.Praesentsodalesmaurisquisportafermentum.Etiamnisinislvenenatisvelauctorutullamcorperinjusto.Proinvelligulaerat.Phasellusvestibulumgravidamassanonfeugiat.Maecenaspharetraeuismodmetusegetefficitur.Suspendisseamet@gmail.com"));
    }

    @Test
    public void testEmailAtTLD() {
        EmailValidator val = EmailValidator.getInstance((boolean)false, (boolean)true);
        Assert.assertTrue((boolean)val.isValid("test@com"));
    }

    @Test
    public void testValidator359() {
        EmailValidator val = EmailValidator.getInstance((boolean)false, (boolean)true);
        Assert.assertFalse((boolean)val.isValid("test@.com"));
    }

    @Test
    public void testValidator374() {
        Assert.assertTrue((boolean)this.validator.isValid("abc@school.school"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidator473_1() {
        new EmailValidator(false, false, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidator473_2() {
        ArrayList items = new ArrayList();
        new EmailValidator(false, false, DomainValidator.getInstance((boolean)true, items));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidator473_3() {
        ArrayList items = new ArrayList();
        new EmailValidator(true, false, DomainValidator.getInstance((boolean)false, items));
    }

    @Test
    public void testValidator473_4() {
        Assert.assertFalse((boolean)this.validator.isValidDomain("test.local"));
        ArrayList<DomainValidator.Item> items = new ArrayList<DomainValidator.Item>();
        items.add(new DomainValidator.Item(DomainValidator.ArrayType.GENERIC_PLUS, new String[]{"local"}));
        EmailValidator val = new EmailValidator(true, false, DomainValidator.getInstance((boolean)true, items));
        Assert.assertTrue((boolean)val.isValidDomain("test.local"));
    }

    public static void main(String[] args) {
        EmailValidator validator = EmailValidator.getInstance();
        for (String arg : args) {
            System.out.printf("%s: %s%n", arg, validator.isValid(arg));
        }
    }
}

