/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.DoubleValidator;

public class DoubleValidatorTest
extends AbstractNumberValidatorTest {
    public DoubleValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new DoubleValidator(false, 0);
        this.strictValidator = new DoubleValidator();
        this.testPattern = "#,###.#";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = 1234.5;
        this.testZero = 0.0;
        this.validStrict = new String[]{"0", "1234.5", "1,234.5"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234.5", "1,234.5", "1,234.5", "1234.5X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234.5";
        this.localeValue = this.testStringDE = "1.234,5";
        this.localePattern = "#.###,#";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testDoubleValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        Double expected = 12345.0;
        DoubleValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)DoubleValidator.getInstance().validate(defaultVal));
        DoubleValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)DoubleValidator.getInstance().validate(localeVal, locale));
        DoubleValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)DoubleValidator.getInstance().validate(patternVal, pattern));
        DoubleValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)DoubleValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        DoubleValidatorTest.assertTrue((String)"isValid(A) default", (boolean)DoubleValidator.getInstance().isValid(defaultVal));
        DoubleValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)DoubleValidator.getInstance().isValid(localeVal, locale));
        DoubleValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)DoubleValidator.getInstance().isValid(patternVal, pattern));
        DoubleValidatorTest.assertTrue((String)"isValid(A) both", (boolean)DoubleValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        DoubleValidatorTest.assertNull((String)"validate(B) default", (Object)DoubleValidator.getInstance().validate(XXXX));
        DoubleValidatorTest.assertNull((String)"validate(B) locale ", (Object)DoubleValidator.getInstance().validate(XXXX, locale));
        DoubleValidatorTest.assertNull((String)"validate(B) pattern", (Object)DoubleValidator.getInstance().validate(XXXX, pattern));
        DoubleValidatorTest.assertNull((String)"validate(B) both", (Object)DoubleValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        DoubleValidatorTest.assertFalse((String)"isValid(B) default", (boolean)DoubleValidator.getInstance().isValid(XXXX));
        DoubleValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)DoubleValidator.getInstance().isValid(XXXX, locale));
        DoubleValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)DoubleValidator.getInstance().isValid(XXXX, pattern));
        DoubleValidatorTest.assertFalse((String)"isValid(B) both", (boolean)DoubleValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testDoubleRangeMinMax() {
        DoubleValidator validator = (DoubleValidator)this.strictValidator;
        Double number9 = validator.validate("9", "#");
        Double number10 = validator.validate("10", "#");
        Double number11 = validator.validate("11", "#");
        Double number19 = validator.validate("19", "#");
        Double number20 = validator.validate("20", "#");
        Double number21 = validator.validate("21", "#");
        DoubleValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, 10.0, 20.0));
        DoubleValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, 10.0, 20.0));
        DoubleValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, 10.0, 20.0));
        DoubleValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, 10.0, 20.0));
        DoubleValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, 10.0, 20.0));
        DoubleValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, 10.0));
        DoubleValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, 10.0));
        DoubleValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, 10.0));
        DoubleValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, 20.0));
        DoubleValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, 20.0));
        DoubleValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, 20.0));
    }
}

