/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigInteger;
import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.BigIntegerValidator;

public class BigIntegerValidatorTest
extends AbstractNumberValidatorTest {
    public BigIntegerValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new BigIntegerValidator(false, 0);
        this.strictValidator = new BigIntegerValidator();
        this.testPattern = "#,###";
        this.max = null;
        this.maxPlusOne = null;
        this.min = null;
        this.minMinusOne = null;
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = new BigInteger("1234");
        this.testZero = new BigInteger("0");
        this.validStrict = new String[]{"0", "1234", "1,234"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "1234", "1,234", "1,234.5", "1234X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = "1,234";
        this.localeValue = this.testStringDE = "1.234";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testBigIntegerValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00,00";
        String patternVal = "1,23,45";
        String germanPatternVal = "1.23.45";
        String localeVal = "12.345";
        String defaultVal = "12,345";
        String XXXX = "XXXX";
        BigInteger expected = new BigInteger("12345");
        BigIntegerValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)BigIntegerValidator.getInstance().validate(defaultVal));
        BigIntegerValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)BigIntegerValidator.getInstance().validate(localeVal, locale));
        BigIntegerValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)BigIntegerValidator.getInstance().validate(patternVal, pattern));
        BigIntegerValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)BigIntegerValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        BigIntegerValidatorTest.assertTrue((String)"isValid(A) default", (boolean)BigIntegerValidator.getInstance().isValid(defaultVal));
        BigIntegerValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)BigIntegerValidator.getInstance().isValid(localeVal, locale));
        BigIntegerValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)BigIntegerValidator.getInstance().isValid(patternVal, pattern));
        BigIntegerValidatorTest.assertTrue((String)"isValid(A) both", (boolean)BigIntegerValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        BigIntegerValidatorTest.assertNull((String)"validate(B) default", (Object)BigIntegerValidator.getInstance().validate(XXXX));
        BigIntegerValidatorTest.assertNull((String)"validate(B) locale ", (Object)BigIntegerValidator.getInstance().validate(XXXX, locale));
        BigIntegerValidatorTest.assertNull((String)"validate(B) pattern", (Object)BigIntegerValidator.getInstance().validate(XXXX, pattern));
        BigIntegerValidatorTest.assertNull((String)"validate(B) both", (Object)BigIntegerValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        BigIntegerValidatorTest.assertFalse((String)"isValid(B) default", (boolean)BigIntegerValidator.getInstance().isValid(XXXX));
        BigIntegerValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)BigIntegerValidator.getInstance().isValid(XXXX, locale));
        BigIntegerValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)BigIntegerValidator.getInstance().isValid(XXXX, pattern));
        BigIntegerValidatorTest.assertFalse((String)"isValid(B) both", (boolean)BigIntegerValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testBigIntegerRangeMinMax() {
        BigIntegerValidator validator = (BigIntegerValidator)this.strictValidator;
        BigInteger number9 = validator.validate("9", "#");
        BigInteger number10 = validator.validate("10", "#");
        BigInteger number11 = validator.validate("11", "#");
        BigInteger number19 = validator.validate("19", "#");
        BigInteger number20 = validator.validate("20", "#");
        BigInteger number21 = validator.validate("21", "#");
        BigIntegerValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, 10L, 20L));
        BigIntegerValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, 10L, 20L));
        BigIntegerValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, 10L, 20L));
        BigIntegerValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, 10L, 20L));
        BigIntegerValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, 10L, 20L));
        BigIntegerValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, 10L));
        BigIntegerValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, 10L));
        BigIntegerValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, 10L));
        BigIntegerValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, 20L));
        BigIntegerValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, 20L));
        BigIntegerValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, 20L));
    }
}

