/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.AbstractNumberValidator;

public abstract class AbstractNumberValidatorTest
extends TestCase {
    protected AbstractNumberValidator validator;
    protected AbstractNumberValidator strictValidator;
    protected Number max;
    protected Number maxPlusOne;
    protected Number min;
    protected Number minMinusOne;
    protected String[] invalid;
    protected String[] valid;
    protected Number[] validCompare;
    protected String[] invalidStrict;
    protected String[] validStrict;
    protected Number[] validStrictCompare;
    protected String testPattern;
    protected Number testNumber;
    protected Number testZero;
    protected String testStringUS;
    protected String testStringDE;
    protected String localeValue;
    protected String localePattern;
    protected Locale testLocale;
    protected Number localeExpected;

    public AbstractNumberValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Locale.setDefault(Locale.US);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.validator = null;
        this.strictValidator = null;
    }

    public void testFormatType() {
        AbstractNumberValidatorTest.assertEquals((String)"Format Type A", (int)0, (int)this.validator.getFormatType());
        AbstractNumberValidatorTest.assertEquals((String)"Format Type B", (int)0, (int)this.validator.getFormatType());
    }

    public void testValidateMinMax() {
        DecimalFormat fmt = new DecimalFormat("#");
        if (this.max != null) {
            AbstractNumberValidatorTest.assertEquals((String)"Test Max", (Object)this.max, (Object)this.validator.parse(fmt.format(this.max), "#", null));
            AbstractNumberValidatorTest.assertNull((String)"Test Max + 1", (Object)this.validator.parse(fmt.format(this.maxPlusOne), "#", null));
            AbstractNumberValidatorTest.assertEquals((String)"Test Min", (Object)this.min, (Object)this.validator.parse(fmt.format(this.min), "#", null));
            AbstractNumberValidatorTest.assertNull((String)"Test min - 1", (Object)this.validator.parse(fmt.format(this.minMinusOne), "#", null));
        }
    }

    public void testInvalidStrict() {
        for (int i = 0; i < this.invalidStrict.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.invalidStrict[i] + "]";
            AbstractNumberValidatorTest.assertNull((String)("(A) " + text), (Object)this.strictValidator.parse(this.invalidStrict[i], null, Locale.US));
            AbstractNumberValidatorTest.assertFalse((String)("(B) " + text), (boolean)this.strictValidator.isValid(this.invalidStrict[i], null, Locale.US));
            AbstractNumberValidatorTest.assertNull((String)("(C) " + text), (Object)this.strictValidator.parse(this.invalidStrict[i], this.testPattern, null));
            AbstractNumberValidatorTest.assertFalse((String)("(D) " + text), (boolean)this.strictValidator.isValid(this.invalidStrict[i], this.testPattern, null));
        }
    }

    public void testInvalidNotStrict() {
        for (int i = 0; i < this.invalid.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.invalid[i] + "]";
            AbstractNumberValidatorTest.assertNull((String)("(A) " + text), (Object)this.validator.parse(this.invalid[i], null, Locale.US));
            AbstractNumberValidatorTest.assertFalse((String)("(B) " + text), (boolean)this.validator.isValid(this.invalid[i], null, Locale.US));
            AbstractNumberValidatorTest.assertNull((String)("(C) " + text), (Object)this.validator.parse(this.invalid[i], this.testPattern, null));
            AbstractNumberValidatorTest.assertFalse((String)("(D) " + text), (boolean)this.validator.isValid(this.invalid[i], this.testPattern, null));
        }
    }

    public void testValidStrict() {
        for (int i = 0; i < this.validStrict.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.validStrictCompare[i] + "]";
            AbstractNumberValidatorTest.assertEquals((String)("(A) " + text), (Object)this.validStrictCompare[i], (Object)this.strictValidator.parse(this.validStrict[i], null, Locale.US));
            AbstractNumberValidatorTest.assertTrue((String)("(B) " + text), (boolean)this.strictValidator.isValid(this.validStrict[i], null, Locale.US));
            AbstractNumberValidatorTest.assertEquals((String)("(C) " + text), (Object)this.validStrictCompare[i], (Object)this.strictValidator.parse(this.validStrict[i], this.testPattern, null));
            AbstractNumberValidatorTest.assertTrue((String)("(D) " + text), (boolean)this.strictValidator.isValid(this.validStrict[i], this.testPattern, null));
        }
    }

    public void testValidNotStrict() {
        for (int i = 0; i < this.valid.length; ++i) {
            String text = "idx=[" + i + "] value=[" + this.validCompare[i] + "]";
            AbstractNumberValidatorTest.assertEquals((String)("(A) " + text), (Object)this.validCompare[i], (Object)this.validator.parse(this.valid[i], null, Locale.US));
            AbstractNumberValidatorTest.assertTrue((String)("(B) " + text), (boolean)this.validator.isValid(this.valid[i], null, Locale.US));
            AbstractNumberValidatorTest.assertEquals((String)("(C) " + text), (Object)this.validCompare[i], (Object)this.validator.parse(this.valid[i], this.testPattern, null));
            AbstractNumberValidatorTest.assertTrue((String)("(D) " + text), (boolean)this.validator.isValid(this.valid[i], this.testPattern, null));
        }
    }

    public void testValidateLocale() {
        AbstractNumberValidatorTest.assertEquals((String)"US Locale, US Format", (Object)this.testNumber, (Object)this.strictValidator.parse(this.testStringUS, null, Locale.US));
        AbstractNumberValidatorTest.assertNull((String)"US Locale, DE Format", (Object)this.strictValidator.parse(this.testStringDE, null, Locale.US));
        AbstractNumberValidatorTest.assertEquals((String)"DE Locale, DE Format", (Object)this.testNumber, (Object)this.strictValidator.parse(this.testStringDE, null, Locale.GERMAN));
        AbstractNumberValidatorTest.assertNull((String)"DE Locale, US Format", (Object)this.strictValidator.parse(this.testStringUS, null, Locale.GERMAN));
        AbstractNumberValidatorTest.assertEquals((String)"Default Locale, US Format", (Object)this.testNumber, (Object)this.strictValidator.parse(this.testStringUS, null, null));
        AbstractNumberValidatorTest.assertNull((String)"Default Locale, DE Format", (Object)this.strictValidator.parse(this.testStringDE, null, null));
    }

    public void testFormat() {
        BigDecimal number = new BigDecimal("1234.5");
        AbstractNumberValidatorTest.assertEquals((String)"US Locale, US Format", (String)"1,234.5", (String)this.strictValidator.format((Object)number, Locale.US));
        AbstractNumberValidatorTest.assertEquals((String)"DE Locale, DE Format", (String)"1.234,5", (String)this.strictValidator.format((Object)number, Locale.GERMAN));
        AbstractNumberValidatorTest.assertEquals((String)"Pattern #,#0.00", (String)"12,34.50", (String)this.strictValidator.format((Object)number, "#,#0.00"));
    }

    public void testRangeMinMax() {
        Integer number9 = 9;
        Integer number10 = 10;
        Integer number11 = 11;
        Integer number19 = 19;
        Integer number20 = 20;
        Integer number21 = 21;
        AbstractNumberValidatorTest.assertFalse((String)"isInRange() < min", (boolean)this.strictValidator.isInRange((Number)number9, (Number)number10, (Number)number20));
        AbstractNumberValidatorTest.assertTrue((String)"isInRange() = min", (boolean)this.strictValidator.isInRange((Number)number10, (Number)number10, (Number)number20));
        AbstractNumberValidatorTest.assertTrue((String)"isInRange() in range", (boolean)this.strictValidator.isInRange((Number)number11, (Number)number10, (Number)number20));
        AbstractNumberValidatorTest.assertTrue((String)"isInRange() = max", (boolean)this.strictValidator.isInRange((Number)number20, (Number)number10, (Number)number20));
        AbstractNumberValidatorTest.assertFalse((String)"isInRange() > max", (boolean)this.strictValidator.isInRange((Number)number21, (Number)number10, (Number)number20));
        AbstractNumberValidatorTest.assertFalse((String)"minValue() < min", (boolean)this.strictValidator.minValue((Number)number9, (Number)number10));
        AbstractNumberValidatorTest.assertTrue((String)"minValue() = min", (boolean)this.strictValidator.minValue((Number)number10, (Number)number10));
        AbstractNumberValidatorTest.assertTrue((String)"minValue() > min", (boolean)this.strictValidator.minValue((Number)number11, (Number)number10));
        AbstractNumberValidatorTest.assertTrue((String)"maxValue() < max", (boolean)this.strictValidator.maxValue((Number)number19, (Number)number20));
        AbstractNumberValidatorTest.assertTrue((String)"maxValue() = max", (boolean)this.strictValidator.maxValue((Number)number20, (Number)number20));
        AbstractNumberValidatorTest.assertFalse((String)"maxValue() > max", (boolean)this.strictValidator.maxValue((Number)number21, (Number)number20));
    }

    public void testSerialization() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.validator);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            AbstractNumberValidatorTest.fail((String)(this.validator.getClass().getName() + " error during serialization: " + e));
        }
        Object result = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            result = ois.readObject();
            bais.close();
        }
        catch (Exception e) {
            AbstractNumberValidatorTest.fail((String)(this.validator.getClass().getName() + " error during deserialization: " + e));
        }
        AbstractNumberValidatorTest.assertNotNull((Object)result);
    }
}

