/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import org.apache.commons.validator.AbstractCommonTest;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class ValidatorResultsTest
extends AbstractCommonTest {
    private static final String FORM_KEY = "nameForm";
    private static final String firstNameField = "firstName";
    private static final String middleNameField = "middleName";
    private static final String lastNameField = "lastName";
    private String firstName;
    private String middleName;
    private String lastName;

    public ValidatorResultsTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        this.loadResources("ValidatorResultsTest-config.xml");
        this.firstName = "foo";
        this.middleName = "123";
        this.lastName = "456";
    }

    protected void tearDown() {
    }

    public void testAllValid() throws ValidatorException {
        NameBean bean = this.createNameBean();
        ValidatorResults results = this.validate(bean);
        this.checkValidatorResult(results, firstNameField, "required", true);
        this.checkValidatorResult(results, middleNameField, "required", true);
        this.checkValidatorResult(results, middleNameField, "int", true);
        this.checkValidatorResult(results, middleNameField, "positive", true);
        this.checkValidatorResult(results, lastNameField, "required", true);
        this.checkValidatorResult(results, lastNameField, "int", true);
    }

    public void testErrors() throws ValidatorException {
        this.middleName = "XXX";
        this.lastName = null;
        NameBean bean = this.createNameBean();
        ValidatorResults results = this.validate(bean);
        this.checkValidatorResult(results, firstNameField, "required", true);
        this.checkValidatorResult(results, middleNameField, "required", true);
        this.checkValidatorResult(results, middleNameField, "int", false);
        this.checkNotRun(results, middleNameField, "positive");
        this.checkValidatorResult(results, lastNameField, "required", false);
        this.checkNotRun(results, lastNameField, "int");
    }

    private void checkNotRun(ValidatorResults results, String field, String action) {
        ValidatorResult result = results.getValidatorResult(field);
        ValidatorResultsTest.assertNotNull((String)(field + " result"), (Object)result);
        ValidatorResultsTest.assertFalse((String)(field + "[" + action + "] run"), (boolean)result.containsAction(action));
    }

    private void checkValidatorResult(ValidatorResults results, String field, String action, boolean expected) {
        ValidatorResult result = results.getValidatorResult(field);
        ValidatorResultsTest.assertNotNull((String)(field + " result"), (Object)result);
        ValidatorResultsTest.assertTrue((String)(field + "[" + action + "] not run"), (boolean)result.containsAction(action));
        ValidatorResultsTest.assertEquals((String)(field + "[" + action + "] result"), (boolean)expected, (boolean)result.isValid(action));
    }

    private NameBean createNameBean() {
        NameBean name = new NameBean();
        name.setFirstName(this.firstName);
        name.setMiddleName(this.middleName);
        name.setLastName(this.lastName);
        return name;
    }

    private ValidatorResults validate(Object bean) throws ValidatorException {
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", bean);
        ValidatorResults results = validator.validate();
        return results;
    }
}

