/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.NameBean;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.ValidatorResult;
import org.apache.commons.validator.ValidatorResults;
import org.xml.sax.SAXException;

public class MultipleConfigFilesTest
extends TestCase {
    private ValidatorResources resources = null;
    private static final String FORM_KEY = "nameForm";
    private static final String ACTION = "required";

    public MultipleConfigFilesTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException, SAXException {
        InputStream[] streams = new InputStream[]{((Object)((Object)this)).getClass().getResourceAsStream("MultipleConfigFilesTest-1-config.xml"), ((Object)((Object)this)).getClass().getResourceAsStream("MultipleConfigFilesTest-2-config.xml")};
        this.resources = new ValidatorResources(streams);
        for (int i = 0; i < streams.length; ++i) {
            streams[i].close();
        }
    }

    public void testMergedConfig() {
        Form form1 = this.resources.getForm("", "", "", "testForm1");
        MultipleConfigFilesTest.assertNotNull((String)"Form 'testForm1' not found", (Object)form1);
        Form form2 = this.resources.getForm("", "", "", "testForm2");
        MultipleConfigFilesTest.assertNotNull((String)"Form 'testForm2' not found", (Object)form2);
        Field field1 = form1.getField("testProperty1");
        MultipleConfigFilesTest.assertEquals((String)"testProperty1 - const 1", (String)"testConstValue1", (String)field1.getVarValue("var11"));
        MultipleConfigFilesTest.assertEquals((String)"testProperty1 - const 2", (String)"testConstValue2", (String)field1.getVarValue("var12"));
        Field field2 = form2.getField("testProperty2");
        MultipleConfigFilesTest.assertEquals((String)"testProperty2 - const 1", (String)"testConstValue1", (String)field2.getVarValue("var21"));
        MultipleConfigFilesTest.assertEquals((String)"testProperty2 - const 2", (String)"testConstValue2", (String)field2.getVarValue("var22"));
        Form form1_fr = this.resources.getForm("fr", "", "", "testForm1_fr");
        MultipleConfigFilesTest.assertNotNull((String)"Form 'testForm1_fr' not found", (Object)form1_fr);
        Form form2_fr = this.resources.getForm("fr", "", "", "testForm2_fr");
        MultipleConfigFilesTest.assertNotNull((String)"Form 'testForm2_fr' not found", (Object)form2_fr);
        Field field1_fr = form1_fr.getField("testProperty1_fr");
        MultipleConfigFilesTest.assertEquals((String)"testProperty1_fr - const 1", (String)"testConstValue1_fr", (String)field1_fr.getVarValue("var11_fr"));
        MultipleConfigFilesTest.assertEquals((String)"testProperty1_fr - const 2", (String)"testConstValue2_fr", (String)field1_fr.getVarValue("var12_fr"));
        Field field2_fr = form2_fr.getField("testProperty2_fr");
        MultipleConfigFilesTest.assertEquals((String)"testProperty2_fr - const 1", (String)"testConstValue1_fr", (String)field2_fr.getVarValue("var21_fr"));
        MultipleConfigFilesTest.assertEquals((String)"testProperty2_fr - const 2", (String)"testConstValue2_fr", (String)field2_fr.getVarValue("var22_fr"));
    }

    public void testBothBlank() throws ValidatorException {
        NameBean name = new NameBean();
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleConfigFilesTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleConfigFilesTest.assertNotNull((Object)firstNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        MultipleConfigFilesTest.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        MultipleConfigFilesTest.assertNotNull((Object)lastNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)lastNameResult.containsAction(ACTION));
        MultipleConfigFilesTest.assertTrue((!lastNameResult.isValid(ACTION) ? 1 : 0) != 0);
        MultipleConfigFilesTest.assertTrue((!lastNameResult.containsAction("int") ? 1 : 0) != 0);
    }

    public void testRequiredFirstNameBlankLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleConfigFilesTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleConfigFilesTest.assertNotNull((Object)firstNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        MultipleConfigFilesTest.assertTrue((!firstNameResult.isValid(ACTION) ? 1 : 0) != 0);
        MultipleConfigFilesTest.assertNotNull((Object)lastNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)lastNameResult.containsAction("int"));
        MultipleConfigFilesTest.assertTrue((!lastNameResult.isValid("int") ? 1 : 0) != 0);
    }

    public void testRequiredLastNameShort() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Test");
        name.setLastName("Test");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleConfigFilesTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleConfigFilesTest.assertNotNull((Object)firstNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        MultipleConfigFilesTest.assertTrue((boolean)firstNameResult.isValid(ACTION));
        MultipleConfigFilesTest.assertNotNull((Object)lastNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)lastNameResult.containsAction("int"));
        MultipleConfigFilesTest.assertTrue((!lastNameResult.isValid("int") ? 1 : 0) != 0);
    }

    public void testRequiredLastNameLong() throws ValidatorException {
        NameBean name = new NameBean();
        name.setFirstName("Joe");
        name.setLastName("12345678");
        Validator validator = new Validator(this.resources, FORM_KEY);
        validator.setParameter("java.lang.Object", (Object)name);
        ValidatorResults results = null;
        results = validator.validate();
        MultipleConfigFilesTest.assertNotNull((String)"Results are null.", (Object)results);
        ValidatorResult firstNameResult = results.getValidatorResult("firstName");
        ValidatorResult lastNameResult = results.getValidatorResult("lastName");
        MultipleConfigFilesTest.assertNotNull((Object)firstNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)firstNameResult.containsAction(ACTION));
        MultipleConfigFilesTest.assertTrue((boolean)firstNameResult.isValid(ACTION));
        MultipleConfigFilesTest.assertNotNull((Object)lastNameResult);
        MultipleConfigFilesTest.assertTrue((boolean)lastNameResult.containsAction("int"));
        MultipleConfigFilesTest.assertTrue((boolean)lastNameResult.isValid("int"));
    }
}

