/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import junit.framework.TestCase;
import org.apache.commons.validator.CreditCardValidator;

@Deprecated
public class CreditCardValidatorTest
extends TestCase {
    private static final String VALID_VISA = "4417123456789113";
    private static final String VALID_SHORT_VISA = "4222222222222";
    private static final String VALID_AMEX = "378282246310005";
    private static final String VALID_MASTERCARD = "5105105105105100";
    private static final String VALID_DISCOVER = "6011000990139424";
    private static final String VALID_DINERS = "30569309025904";

    public CreditCardValidatorTest(String name) {
        super(name);
    }

    public void testIsValid() {
        CreditCardValidator ccv = new CreditCardValidator();
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(null));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(""));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("123456789012"));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("12345678901234567890"));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("4417123456789112"));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid("4417q23456w89113"));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_VISA));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_SHORT_VISA));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_DISCOVER));
        ccv = new CreditCardValidator(1);
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_VISA));
    }

    public void testAddAllowedCardType() {
        CreditCardValidator ccv = new CreditCardValidator(0);
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_VISA));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_AMEX));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_MASTERCARD));
        CreditCardValidatorTest.assertFalse((boolean)ccv.isValid(VALID_DISCOVER));
        ccv.addAllowedCardType((CreditCardValidator.CreditCardType)new DinersClub());
        CreditCardValidatorTest.assertTrue((boolean)ccv.isValid(VALID_DINERS));
    }

    private class DinersClub
    implements CreditCardValidator.CreditCardType {
        private static final String PREFIX = "300,301,302,303,304,305,";

        private DinersClub() {
        }

        public boolean matches(String card) {
            String prefix = card.substring(0, 3) + ",";
            return PREFIX.contains(prefix) && card.length() == 14;
        }
    }
}

