/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.ISINCheckDigit;

public class ISINCheckDigitTest
extends AbstractCheckDigitTest {
    private static String[] invalidCheckDigits = new String[]{"US037833100O", "BMG8571G109D", "AU0000XVGZAD", "GB000263494I", "FR000402625C", "DK000976334H"};

    public ISINCheckDigitTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.routine = ISINCheckDigit.ISIN_CHECK_DIGIT;
        this.valid = new String[]{"US0378331005", "BMG8571G1096", "AU0000XVGZA3", "GB0002634946", "FR0004026250", "DK0009763344"};
        this.invalid = new String[]{"0378#3100"};
    }

    public void testVALIDATOR_345() {
        for (int i = 0; i < invalidCheckDigits.length; ++i) {
            String invalidCheckDigit = invalidCheckDigits[i];
            ISINCheckDigitTest.assertFalse((String)("Should fail: " + invalidCheckDigit), (boolean)this.routine.isValid(invalidCheckDigit));
        }
    }
}

