/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.regex.PatternSyntaxException;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.RegexValidator;

public class RegexValidatorTest
extends TestCase {
    private static final String REGEX = "^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$";
    private static final String COMPONENT_1 = "([abc]{3})";
    private static final String COMPONENT_2 = "([DEF]{3})";
    private static final String COMPONENT_3 = "([123]{3})";
    private static final String SEPARATOR_1 = "(?:\\-)";
    private static final String SEPARATOR_2 = "(?:\\s)";
    private static final String REGEX_1 = "^([abc]{3})(?:\\-)([DEF]{3})(?:\\-)([123]{3})$";
    private static final String REGEX_2 = "^([abc]{3})(?:\\s)([DEF]{3})(?:\\s)([123]{3})$";
    private static final String REGEX_3 = "^([abc]{3})([DEF]{3})([123]{3})$";
    private static final String[] MULTIPLE_REGEX = new String[]{"^([abc]{3})(?:\\-)([DEF]{3})(?:\\-)([123]{3})$", "^([abc]{3})(?:\\s)([DEF]{3})(?:\\s)([123]{3})$", "^([abc]{3})([DEF]{3})([123]{3})$"};

    public RegexValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSingle() {
        RegexValidator sensitive = new RegexValidator(REGEX);
        RegexValidator insensitive = new RegexValidator(REGEX, false);
        RegexValidatorTest.assertEquals((String)"Sensitive isValid() valid", (boolean)true, (boolean)sensitive.isValid("ac-DE-1"));
        RegexValidatorTest.assertEquals((String)"Sensitive isValid() invalid", (boolean)false, (boolean)sensitive.isValid("AB-de-1"));
        RegexValidatorTest.assertEquals((String)"Insensitive isValid() valid", (boolean)true, (boolean)insensitive.isValid("AB-de-1"));
        RegexValidatorTest.assertEquals((String)"Insensitive isValid() invalid", (boolean)false, (boolean)insensitive.isValid("ABd-de-1"));
        RegexValidatorTest.assertEquals((String)"Sensitive validate() valid", (String)"acDE1", (String)sensitive.validate("ac-DE-1"));
        RegexValidatorTest.assertEquals((String)"Sensitive validate() invalid", null, (String)sensitive.validate("AB-de-1"));
        RegexValidatorTest.assertEquals((String)"Insensitive validate() valid", (String)"ABde1", (String)insensitive.validate("AB-de-1"));
        RegexValidatorTest.assertEquals((String)"Insensitive validate() invalid", null, (String)insensitive.validate("ABd-de-1"));
        this.checkArray("Sensitive match() valid", new String[]{"ac", "DE", "1"}, sensitive.match("ac-DE-1"));
        this.checkArray("Sensitive match() invalid", null, sensitive.match("AB-de-1"));
        this.checkArray("Insensitive match() valid", new String[]{"AB", "de", "1"}, insensitive.match("AB-de-1"));
        this.checkArray("Insensitive match() invalid", null, insensitive.match("ABd-de-1"));
        RegexValidatorTest.assertEquals((String)"validate one", (String)"ABC", (String)new RegexValidator("^([A-Z]*)$").validate("ABC"));
        this.checkArray("match one", new String[]{"ABC"}, new RegexValidator("^([A-Z]*)$").match("ABC"));
    }

    public void testMultipleSensitive() {
        RegexValidator multiple = new RegexValidator(MULTIPLE_REGEX);
        RegexValidator single1 = new RegexValidator(REGEX_1);
        RegexValidator single2 = new RegexValidator(REGEX_2);
        RegexValidator single3 = new RegexValidator(REGEX_3);
        String value = "aac FDE 321";
        String expect = "aacFDE321";
        String[] array = new String[]{"aac", "FDE", "321"};
        RegexValidatorTest.assertEquals((String)"Sensitive isValid() Multiple", (boolean)true, (boolean)multiple.isValid(value));
        RegexValidatorTest.assertEquals((String)"Sensitive isValid() 1st", (boolean)false, (boolean)single1.isValid(value));
        RegexValidatorTest.assertEquals((String)"Sensitive isValid() 2nd", (boolean)true, (boolean)single2.isValid(value));
        RegexValidatorTest.assertEquals((String)"Sensitive isValid() 3rd", (boolean)false, (boolean)single3.isValid(value));
        RegexValidatorTest.assertEquals((String)"Sensitive validate() Multiple", (String)expect, (String)multiple.validate(value));
        RegexValidatorTest.assertEquals((String)"Sensitive validate() 1st", null, (String)single1.validate(value));
        RegexValidatorTest.assertEquals((String)"Sensitive validate() 2nd", (String)expect, (String)single2.validate(value));
        RegexValidatorTest.assertEquals((String)"Sensitive validate() 3rd", null, (String)single3.validate(value));
        this.checkArray("Sensitive match() Multiple", array, multiple.match(value));
        this.checkArray("Sensitive match() 1st", null, single1.match(value));
        this.checkArray("Sensitive match() 2nd", array, single2.match(value));
        this.checkArray("Sensitive match() 3rd", null, single3.match(value));
        value = "AAC*FDE*321";
        RegexValidatorTest.assertEquals((String)"isValid() Invalid", (boolean)false, (boolean)multiple.isValid(value));
        RegexValidatorTest.assertEquals((String)"validate() Invalid", null, (String)multiple.validate(value));
        RegexValidatorTest.assertEquals((String)"match() Multiple", null, (Object)multiple.match(value));
    }

    public void testMultipleInsensitive() {
        RegexValidator multiple = new RegexValidator(MULTIPLE_REGEX, false);
        RegexValidator single1 = new RegexValidator(REGEX_1, false);
        RegexValidator single2 = new RegexValidator(REGEX_2, false);
        RegexValidator single3 = new RegexValidator(REGEX_3, false);
        String value = "AAC FDE 321";
        String expect = "AACFDE321";
        String[] array = new String[]{"AAC", "FDE", "321"};
        RegexValidatorTest.assertEquals((String)"isValid() Multiple", (boolean)true, (boolean)multiple.isValid(value));
        RegexValidatorTest.assertEquals((String)"isValid() 1st", (boolean)false, (boolean)single1.isValid(value));
        RegexValidatorTest.assertEquals((String)"isValid() 2nd", (boolean)true, (boolean)single2.isValid(value));
        RegexValidatorTest.assertEquals((String)"isValid() 3rd", (boolean)false, (boolean)single3.isValid(value));
        RegexValidatorTest.assertEquals((String)"validate() Multiple", (String)expect, (String)multiple.validate(value));
        RegexValidatorTest.assertEquals((String)"validate() 1st", null, (String)single1.validate(value));
        RegexValidatorTest.assertEquals((String)"validate() 2nd", (String)expect, (String)single2.validate(value));
        RegexValidatorTest.assertEquals((String)"validate() 3rd", null, (String)single3.validate(value));
        this.checkArray("match() Multiple", array, multiple.match(value));
        this.checkArray("match() 1st", null, single1.match(value));
        this.checkArray("match() 2nd", array, single2.match(value));
        this.checkArray("match() 3rd", null, single3.match(value));
        value = "AAC*FDE*321";
        RegexValidatorTest.assertEquals((String)"isValid() Invalid", (boolean)false, (boolean)multiple.isValid(value));
        RegexValidatorTest.assertEquals((String)"validate() Invalid", null, (String)multiple.validate(value));
        RegexValidatorTest.assertEquals((String)"match() Multiple", null, (Object)multiple.match(value));
    }

    public void testNullValue() {
        RegexValidator validator = new RegexValidator(REGEX);
        RegexValidatorTest.assertEquals((String)"Instance isValid()", (boolean)false, (boolean)validator.isValid(null));
        RegexValidatorTest.assertEquals((String)"Instance validate()", null, (String)validator.validate(null));
        RegexValidatorTest.assertEquals((String)"Instance match()", null, (Object)validator.match(null));
    }

    public void testMissingRegex() {
        try {
            new RegexValidator((String)null);
            RegexValidatorTest.fail((String)"Single Null - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            RegexValidatorTest.assertEquals((String)"Single Null", (String)"Regular expression[0] is missing", (String)e.getMessage());
        }
        try {
            new RegexValidator("");
            RegexValidatorTest.fail((String)"Single Zero Length - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            RegexValidatorTest.assertEquals((String)"Single Zero Length", (String)"Regular expression[0] is missing", (String)e.getMessage());
        }
        try {
            new RegexValidator((String[])null);
            RegexValidatorTest.fail((String)"Null Array - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            RegexValidatorTest.assertEquals((String)"Null Array", (String)"Regular expressions are missing", (String)e.getMessage());
        }
        try {
            new RegexValidator(new String[0]);
            RegexValidatorTest.fail((String)"Zero Length Array - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            RegexValidatorTest.assertEquals((String)"Zero Length Array", (String)"Regular expressions are missing", (String)e.getMessage());
        }
        String[] expressions = new String[]{"ABC", null};
        try {
            new RegexValidator(expressions);
            RegexValidatorTest.fail((String)"Array has Null - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            RegexValidatorTest.assertEquals((String)"Array has Null", (String)"Regular expression[1] is missing", (String)e.getMessage());
        }
        expressions = new String[]{"", "ABC"};
        try {
            new RegexValidator(expressions);
            RegexValidatorTest.fail((String)"Array has Zero Length - expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            RegexValidatorTest.assertEquals((String)"Array has Zero Length", (String)"Regular expression[0] is missing", (String)e.getMessage());
        }
    }

    public void testExceptions() {
        String invalidRegex = "^([abCD12]*$";
        try {
            new RegexValidator(invalidRegex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public void testToString() {
        RegexValidator single = new RegexValidator(REGEX);
        RegexValidatorTest.assertEquals((String)"Single", (String)"RegexValidator{^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$}", (String)single.toString());
        RegexValidator multiple = new RegexValidator(new String[]{REGEX, REGEX});
        RegexValidatorTest.assertEquals((String)"Multiple", (String)"RegexValidator{^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$,^([abc]*)(?:\\-)([DEF]*)(?:\\-)([123]*)$}", (String)multiple.toString());
    }

    private void checkArray(String label, String[] expect, String[] result) {
        if (expect == null || result == null) {
            if (expect == null && result == null) {
                return;
            }
            RegexValidatorTest.fail((String)(label + " Null expect=" + expect + " result=" + result));
            return;
        }
        if (expect.length != result.length) {
            RegexValidatorTest.fail((String)(label + " Length expect=" + expect.length + " result=" + result.length));
        }
        for (int i = 0; i < expect.length; ++i) {
            RegexValidatorTest.assertEquals((String)(label + " value[" + i + "]"), (String)expect[i], (String)result[i]);
        }
    }
}

