/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.validator.routines.BigDecimalValidator;
import org.apache.commons.validator.routines.CurrencyValidator;

public class CurrencyValidatorTest
extends TestCase {
    private static final char CURRENCY_SYMBOL = '\u00a4';
    private String US_DOLLAR;
    private String UK_POUND;

    public CurrencyValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.US_DOLLAR = new DecimalFormatSymbols(Locale.US).getCurrencySymbol();
        this.UK_POUND = new DecimalFormatSymbols(Locale.UK).getCurrencySymbol();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testFormatType() {
        CurrencyValidatorTest.assertEquals((String)"Format Type A", (int)1, (int)CurrencyValidator.getInstance().getFormatType());
        CurrencyValidatorTest.assertEquals((String)"Format Type B", (int)1, (int)CurrencyValidator.getInstance().getFormatType());
    }

    public void testValid() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        BigDecimal expected = new BigDecimal("1234.56");
        BigDecimal negative = new BigDecimal("-1234.56");
        BigDecimal noDecimal = new BigDecimal("1234.00");
        BigDecimal oneDecimal = new BigDecimal("1234.50");
        CurrencyValidatorTest.assertEquals((String)"Default locale", (Object)expected, (Object)validator.validate(this.UK_POUND + "1,234.56"));
        CurrencyValidatorTest.assertEquals((String)"UK locale", (Object)expected, (Object)validator.validate(this.UK_POUND + "1,234.56", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"UK negative", (Object)negative, (Object)validator.validate("-" + this.UK_POUND + "1,234.56", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"UK no decimal", (Object)noDecimal, (Object)validator.validate(this.UK_POUND + "1,234", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"UK 1 decimal", (Object)oneDecimal, (Object)validator.validate(this.UK_POUND + "1,234.5", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"UK 3 decimal", (Object)expected, (Object)validator.validate(this.UK_POUND + "1,234.567", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"UK no symbol", (Object)expected, (Object)validator.validate("1,234.56", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"US locale", (Object)expected, (Object)validator.validate(this.US_DOLLAR + "1,234.56", Locale.US));
        CurrencyValidatorTest.assertEquals((String)"US negative", (Object)negative, (Object)validator.validate("(" + this.US_DOLLAR + "1,234.56)", Locale.US));
        CurrencyValidatorTest.assertEquals((String)"US no decimal", (Object)noDecimal, (Object)validator.validate(this.US_DOLLAR + "1,234", Locale.US));
        CurrencyValidatorTest.assertEquals((String)"US 1 decimal", (Object)oneDecimal, (Object)validator.validate(this.US_DOLLAR + "1,234.5", Locale.US));
        CurrencyValidatorTest.assertEquals((String)"US 3 decimal", (Object)expected, (Object)validator.validate(this.US_DOLLAR + "1,234.567", Locale.US));
        CurrencyValidatorTest.assertEquals((String)"US no symbol", (Object)expected, (Object)validator.validate("1,234.56", Locale.US));
        Locale.setDefault(origDefault);
    }

    public void testInvalid() {
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        CurrencyValidatorTest.assertFalse((String)"isValid() Null Value", (boolean)validator.isValid(null));
        CurrencyValidatorTest.assertFalse((String)"isValid() Empty Value", (boolean)validator.isValid(""));
        CurrencyValidatorTest.assertNull((String)"validate() Null Value", (Object)validator.validate(null));
        CurrencyValidatorTest.assertNull((String)"validate() Empty Value", (Object)validator.validate(""));
        CurrencyValidatorTest.assertFalse((String)"UK wrong symbol", (boolean)validator.isValid(this.US_DOLLAR + "1,234.56", Locale.UK));
        CurrencyValidatorTest.assertFalse((String)"UK wrong negative", (boolean)validator.isValid("(" + this.UK_POUND + "1,234.56)", Locale.UK));
        CurrencyValidatorTest.assertFalse((String)"US wrong symbol", (boolean)validator.isValid(this.UK_POUND + "1,234.56", Locale.US));
        CurrencyValidatorTest.assertFalse((String)"US wrong negative", (boolean)validator.isValid("-" + this.US_DOLLAR + "1,234.56", Locale.US));
    }

    public void testIntegerValid() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        CurrencyValidator validator = new CurrencyValidator();
        BigDecimal expected = new BigDecimal("1234.00");
        BigDecimal negative = new BigDecimal("-1234.00");
        CurrencyValidatorTest.assertEquals((String)"Default locale", (Object)expected, (Object)validator.validate(this.UK_POUND + "1,234"));
        CurrencyValidatorTest.assertEquals((String)"UK locale", (Object)expected, (Object)validator.validate(this.UK_POUND + "1,234", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"UK negative", (Object)negative, (Object)validator.validate("-" + this.UK_POUND + "1,234", Locale.UK));
        CurrencyValidatorTest.assertEquals((String)"US locale", (Object)expected, (Object)validator.validate(this.US_DOLLAR + "1,234", Locale.US));
        CurrencyValidatorTest.assertEquals((String)"US negative", (Object)negative, (Object)validator.validate("(" + this.US_DOLLAR + "1,234)", Locale.US));
        Locale.setDefault(origDefault);
    }

    public void testIntegerInvalid() {
        CurrencyValidator validator = new CurrencyValidator(true, false);
        CurrencyValidatorTest.assertFalse((String)"UK positive", (boolean)validator.isValid(this.UK_POUND + "1,234.56", Locale.UK));
        CurrencyValidatorTest.assertFalse((String)"UK negative", (boolean)validator.isValid("-" + this.UK_POUND + "1,234.56", Locale.UK));
        CurrencyValidatorTest.assertFalse((String)"US positive", (boolean)validator.isValid(this.US_DOLLAR + "1,234.56", Locale.US));
        CurrencyValidatorTest.assertFalse((String)"US negative", (boolean)validator.isValid("(" + this.US_DOLLAR + "1,234.56)", Locale.US));
    }

    public void testPattern() {
        Locale origDefault = Locale.getDefault();
        Locale.setDefault(Locale.UK);
        BigDecimalValidator validator = CurrencyValidator.getInstance();
        String basicPattern = "\u00a4#,##0.000";
        String pattern = basicPattern + ";[" + basicPattern + "]";
        BigDecimal expected = new BigDecimal("1234.567");
        BigDecimal negative = new BigDecimal("-1234.567");
        CurrencyValidatorTest.assertEquals((String)"default", (Object)expected, (Object)validator.validate(this.UK_POUND + "1,234.567", pattern));
        CurrencyValidatorTest.assertEquals((String)"negative", (Object)negative, (Object)validator.validate("[" + this.UK_POUND + "1,234.567]", pattern));
        CurrencyValidatorTest.assertEquals((String)"no symbol +ve", (Object)expected, (Object)validator.validate("1,234.567", pattern));
        CurrencyValidatorTest.assertEquals((String)"no symbol -ve", (Object)negative, (Object)validator.validate("[1,234.567]", pattern));
        CurrencyValidatorTest.assertEquals((String)"default", (Object)expected, (Object)validator.validate(this.US_DOLLAR + "1,234.567", pattern, Locale.US));
        CurrencyValidatorTest.assertEquals((String)"negative", (Object)negative, (Object)validator.validate("[" + this.US_DOLLAR + "1,234.567]", pattern, Locale.US));
        CurrencyValidatorTest.assertEquals((String)"no symbol +ve", (Object)expected, (Object)validator.validate("1,234.567", pattern, Locale.US));
        CurrencyValidatorTest.assertEquals((String)"no symbol -ve", (Object)negative, (Object)validator.validate("[1,234.567]", pattern, Locale.US));
        CurrencyValidatorTest.assertFalse((String)"invalid symbol", (boolean)validator.isValid(this.US_DOLLAR + "1,234.567", pattern));
        CurrencyValidatorTest.assertFalse((String)"invalid symbol", (boolean)validator.isValid(this.UK_POUND + "1,234.567", pattern, Locale.US));
        Locale.setDefault(origDefault);
    }
}

