/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import junit.framework.TestCase;
import org.apache.commons.validator.routines.CodeValidator;
import org.apache.commons.validator.routines.RegexValidator;
import org.apache.commons.validator.routines.checkdigit.CheckDigit;
import org.apache.commons.validator.routines.checkdigit.EAN13CheckDigit;

public class CodeValidatorTest
extends TestCase {
    public CodeValidatorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCheckDigit() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        String invalidEAN = "9781930110992";
        String validEAN = "9781930110991";
        CodeValidatorTest.assertNull((String)"No CheckDigit", (Object)validator.getCheckDigit());
        CodeValidatorTest.assertEquals((String)"No CheckDigit invalid", (Object)invalidEAN, (Object)validator.validate(invalidEAN));
        CodeValidatorTest.assertEquals((String)"No CheckDigit valid", (Object)validEAN, (Object)validator.validate(validEAN));
        CodeValidatorTest.assertEquals((String)"No CheckDigit (is) invalid", (boolean)true, (boolean)validator.isValid(invalidEAN));
        CodeValidatorTest.assertEquals((String)"No CheckDigit (is) valid", (boolean)true, (boolean)validator.isValid(validEAN));
        validator = new CodeValidator((String)null, -1, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertNotNull((String)"EAN CheckDigit", (Object)validator.getCheckDigit());
        CodeValidatorTest.assertEquals((String)"EAN CheckDigit invalid", null, (Object)validator.validate(invalidEAN));
        CodeValidatorTest.assertEquals((String)"EAN CheckDigit valid", (Object)validEAN, (Object)validator.validate(validEAN));
        CodeValidatorTest.assertEquals((String)"EAN CheckDigit (is) invalid", (boolean)false, (boolean)validator.isValid(invalidEAN));
        CodeValidatorTest.assertEquals((String)"EAN CheckDigit (is) valid", (boolean)true, (boolean)validator.isValid(validEAN));
        CodeValidatorTest.assertEquals((String)"EAN CheckDigit ex", null, (Object)validator.validate("978193011099X"));
    }

    public void testLength() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        String length_10 = "1234567890";
        String length_11 = "12345678901";
        String length_12 = "123456789012";
        String length_20 = "12345678901234567890";
        String length_21 = "123456789012345678901";
        String length_22 = "1234567890123456789012";
        CodeValidatorTest.assertEquals((String)"No min", (int)-1, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"No max", (int)-1, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"No Length 10", (Object)length_10, (Object)validator.validate(length_10));
        CodeValidatorTest.assertEquals((String)"No Length 11", (Object)length_11, (Object)validator.validate(length_11));
        CodeValidatorTest.assertEquals((String)"No Length 12", (Object)length_12, (Object)validator.validate(length_12));
        CodeValidatorTest.assertEquals((String)"No Length 20", (Object)length_20, (Object)validator.validate(length_20));
        CodeValidatorTest.assertEquals((String)"No Length 21", (Object)length_21, (Object)validator.validate(length_21));
        CodeValidatorTest.assertEquals((String)"No Length 22", (Object)length_22, (Object)validator.validate(length_22));
        validator = new CodeValidator((String)null, 11, -1, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Min 11 - min", (int)11, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Min 11 - max", (int)-1, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Min 11 - 10", null, (Object)validator.validate(length_10));
        CodeValidatorTest.assertEquals((String)"Min 11 - 11", (Object)length_11, (Object)validator.validate(length_11));
        CodeValidatorTest.assertEquals((String)"Min 11 - 12", (Object)length_12, (Object)validator.validate(length_12));
        CodeValidatorTest.assertEquals((String)"Min 11 - 20", (Object)length_20, (Object)validator.validate(length_20));
        CodeValidatorTest.assertEquals((String)"Min 11 - 21", (Object)length_21, (Object)validator.validate(length_21));
        CodeValidatorTest.assertEquals((String)"Min 11 - 22", (Object)length_22, (Object)validator.validate(length_22));
        validator = new CodeValidator((String)null, -1, 21, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Max 21 - min", (int)-1, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Max 21 - max", (int)21, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Max 21 - 10", (Object)length_10, (Object)validator.validate(length_10));
        CodeValidatorTest.assertEquals((String)"Max 21 - 11", (Object)length_11, (Object)validator.validate(length_11));
        CodeValidatorTest.assertEquals((String)"Max 21 - 12", (Object)length_12, (Object)validator.validate(length_12));
        CodeValidatorTest.assertEquals((String)"Max 21 - 20", (Object)length_20, (Object)validator.validate(length_20));
        CodeValidatorTest.assertEquals((String)"Max 21 - 21", (Object)length_21, (Object)validator.validate(length_21));
        CodeValidatorTest.assertEquals((String)"Max 21 - 22", null, (Object)validator.validate(length_22));
        validator = new CodeValidator((String)null, 11, 21, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - min", (int)11, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - max", (int)21, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - 10", null, (Object)validator.validate(length_10));
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - 11", (Object)length_11, (Object)validator.validate(length_11));
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - 12", (Object)length_12, (Object)validator.validate(length_12));
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - 20", (Object)length_20, (Object)validator.validate(length_20));
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - 21", (Object)length_21, (Object)validator.validate(length_21));
        CodeValidatorTest.assertEquals((String)"Min 11 / Max 21 - 22", null, (Object)validator.validate(length_22));
        validator = new CodeValidator((String)null, 11, 11, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Exact 11 - min", (int)11, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Exact 11 - max", (int)11, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Exact 11 - 10", null, (Object)validator.validate(length_10));
        CodeValidatorTest.assertEquals((String)"Exact 11 - 11", (Object)length_11, (Object)validator.validate(length_11));
        CodeValidatorTest.assertEquals((String)"Exact 11 - 12", null, (Object)validator.validate(length_12));
    }

    public void testRegex() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        String value2 = "12";
        String value3 = "123";
        String value4 = "1234";
        String value5 = "12345";
        String invalid = "12a4";
        CodeValidatorTest.assertNull((String)"No Regex", (Object)validator.getRegexValidator());
        CodeValidatorTest.assertEquals((String)"No Regex 2", (Object)value2, (Object)validator.validate(value2));
        CodeValidatorTest.assertEquals((String)"No Regex 3", (Object)value3, (Object)validator.validate(value3));
        CodeValidatorTest.assertEquals((String)"No Regex 4", (Object)value4, (Object)validator.validate(value4));
        CodeValidatorTest.assertEquals((String)"No Regex 5", (Object)value5, (Object)validator.validate(value5));
        CodeValidatorTest.assertEquals((String)"No Regex invalid", (Object)invalid, (Object)validator.validate(invalid));
        String regex = "^([0-9]{3,4})$";
        validator = new CodeValidator(regex, -1, -1, (CheckDigit)null);
        CodeValidatorTest.assertNotNull((String)"No Regex", (Object)validator.getRegexValidator());
        CodeValidatorTest.assertEquals((String)"Regex 2", null, (Object)validator.validate(value2));
        CodeValidatorTest.assertEquals((String)"Regex 3", (Object)value3, (Object)validator.validate(value3));
        CodeValidatorTest.assertEquals((String)"Regex 4", (Object)value4, (Object)validator.validate(value4));
        CodeValidatorTest.assertEquals((String)"Regex 5", null, (Object)validator.validate(value5));
        CodeValidatorTest.assertEquals((String)"Regex invalid", null, (Object)validator.validate(invalid));
        regex = "^([0-9]{3})(?:[-\\s])([0-9]{3})$";
        validator = new CodeValidator(new RegexValidator(regex), 6, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Reformat 123-456", (Object)"123456", (Object)validator.validate("123-456"));
        CodeValidatorTest.assertEquals((String)"Reformat 123 456", (Object)"123456", (Object)validator.validate("123 456"));
        CodeValidatorTest.assertEquals((String)"Reformat 123456", null, (Object)validator.validate("123456"));
        CodeValidatorTest.assertEquals((String)"Reformat 123.456", null, (Object)validator.validate("123.456"));
        regex = "^(?:([0-9]{3})(?:[-\\s])([0-9]{3}))|([0-9]{6})$";
        validator = new CodeValidator(new RegexValidator(regex), 6, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Reformat 2 Regex", (String)("RegexValidator{" + regex + "}"), (String)validator.getRegexValidator().toString());
        CodeValidatorTest.assertEquals((String)"Reformat 2 123-456", (Object)"123456", (Object)validator.validate("123-456"));
        CodeValidatorTest.assertEquals((String)"Reformat 2 123 456", (Object)"123456", (Object)validator.validate("123 456"));
        CodeValidatorTest.assertEquals((String)"Reformat 2 123456", (Object)"123456", (Object)validator.validate("123456"));
    }

    public void testNoInput() {
        CodeValidator validator = new CodeValidator((String)null, -1, -1, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Null", null, (Object)validator.validate(null));
        CodeValidatorTest.assertEquals((String)"Zero Length", null, (Object)validator.validate(""));
        CodeValidatorTest.assertEquals((String)"Spaces", null, (Object)validator.validate("   "));
        CodeValidatorTest.assertEquals((String)"Trimmed", (Object)"A", (Object)validator.validate(" A  "));
    }

    public void testValidator294_1() {
        CodeValidator validator = new CodeValidator((String)null, 0, -1, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Null", null, (Object)validator.validate(null));
        validator = new CodeValidator((String)null, -1, 0, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Null", null, (Object)validator.validate(null));
    }

    public void testValidator294_2() {
        CodeValidator validator = new CodeValidator((String)null, -1, 0, (CheckDigit)null);
        CodeValidatorTest.assertEquals((String)"Null", null, (Object)validator.validate(null));
    }

    public void testConstructors() {
        CodeValidator validator = null;
        RegexValidator regex = new RegexValidator("^[0-9]*$");
        validator = new CodeValidator(regex, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertEquals((String)"Constructor 1 - regex", (Object)regex, (Object)validator.getRegexValidator());
        CodeValidatorTest.assertEquals((String)"Constructor 1 - min length", (int)-1, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Constructor 1 - max length", (int)-1, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Constructor 1 - check digit", (Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit());
        validator = new CodeValidator(regex, 13, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertEquals((String)"Constructor 2 - regex", (Object)regex, (Object)validator.getRegexValidator());
        CodeValidatorTest.assertEquals((String)"Constructor 2 - min length", (int)13, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Constructor 2 - max length", (int)13, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Constructor 2 - check digit", (Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit());
        validator = new CodeValidator(regex, 10, 20, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertEquals((String)"Constructor 3 - regex", (Object)regex, (Object)validator.getRegexValidator());
        CodeValidatorTest.assertEquals((String)"Constructor 3 - min length", (int)10, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Constructor 3 - max length", (int)20, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Constructor 3 - check digit", (Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit());
        validator = new CodeValidator("^[0-9]*$", EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertEquals((String)"Constructor 4 - regex", (String)"RegexValidator{^[0-9]*$}", (String)validator.getRegexValidator().toString());
        CodeValidatorTest.assertEquals((String)"Constructor 4 - min length", (int)-1, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Constructor 4 - max length", (int)-1, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Constructor 4 - check digit", (Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit());
        validator = new CodeValidator("^[0-9]*$", 13, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertEquals((String)"Constructor 5 - regex", (String)"RegexValidator{^[0-9]*$}", (String)validator.getRegexValidator().toString());
        CodeValidatorTest.assertEquals((String)"Constructor 5 - min length", (int)13, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Constructor 5 - max length", (int)13, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Constructor 5 - check digit", (Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit());
        validator = new CodeValidator("^[0-9]*$", 10, 20, EAN13CheckDigit.EAN13_CHECK_DIGIT);
        CodeValidatorTest.assertEquals((String)"Constructor 6 - regex", (String)"RegexValidator{^[0-9]*$}", (String)validator.getRegexValidator().toString());
        CodeValidatorTest.assertEquals((String)"Constructor 6 - min length", (int)10, (int)validator.getMinLength());
        CodeValidatorTest.assertEquals((String)"Constructor 6 - max length", (int)20, (int)validator.getMaxLength());
        CodeValidatorTest.assertEquals((String)"Constructor 6 - check digit", (Object)EAN13CheckDigit.EAN13_CHECK_DIGIT, (Object)validator.getCheckDigit());
    }
}

