/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.util.Locale;
import org.apache.commons.validator.routines.AbstractNumberValidatorTest;
import org.apache.commons.validator.routines.ByteValidator;

public class ByteValidatorTest
extends AbstractNumberValidatorTest {
    public ByteValidatorTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validator = new ByteValidator(false, 0);
        this.strictValidator = new ByteValidator();
        this.testPattern = "#,###";
        this.max = new Byte(127);
        this.maxPlusOne = new Long(this.max.longValue() + 1L);
        this.min = new Byte(-128);
        this.minMinusOne = new Long(this.min.longValue() - 1L);
        this.invalidStrict = new String[]{null, "", "X", "X12", "12X", "1X2", "1.2"};
        this.invalid = new String[]{null, "", "X", "X12"};
        this.testNumber = new Byte(123);
        this.testZero = new Byte(0);
        this.validStrict = new String[]{"0", "123", ",123"};
        this.validStrictCompare = new Number[]{this.testZero, this.testNumber, this.testNumber};
        this.valid = new String[]{"0", "123", ",123", ",123.5", "123X"};
        this.validCompare = new Number[]{this.testZero, this.testNumber, this.testNumber, this.testNumber, this.testNumber};
        this.testStringUS = ",123";
        this.localeValue = this.testStringDE = ".123";
        this.localePattern = "#.###";
        this.testLocale = Locale.GERMANY;
        this.localeExpected = this.testNumber;
    }

    public void testByteValidatorMethods() {
        Locale locale = Locale.GERMAN;
        String pattern = "0,00";
        String patternVal = "1,23";
        String germanPatternVal = "1.23";
        String localeVal = ".123";
        String defaultVal = ",123";
        String XXXX = "XXXX";
        Byte expected = new Byte(123);
        ByteValidatorTest.assertEquals((String)"validate(A) default", (Object)expected, (Object)ByteValidator.getInstance().validate(defaultVal));
        ByteValidatorTest.assertEquals((String)"validate(A) locale ", (Object)expected, (Object)ByteValidator.getInstance().validate(localeVal, locale));
        ByteValidatorTest.assertEquals((String)"validate(A) pattern", (Object)expected, (Object)ByteValidator.getInstance().validate(patternVal, pattern));
        ByteValidatorTest.assertEquals((String)"validate(A) both", (Object)expected, (Object)ByteValidator.getInstance().validate(germanPatternVal, pattern, Locale.GERMAN));
        ByteValidatorTest.assertTrue((String)"isValid(A) default", (boolean)ByteValidator.getInstance().isValid(defaultVal));
        ByteValidatorTest.assertTrue((String)"isValid(A) locale ", (boolean)ByteValidator.getInstance().isValid(localeVal, locale));
        ByteValidatorTest.assertTrue((String)"isValid(A) pattern", (boolean)ByteValidator.getInstance().isValid(patternVal, pattern));
        ByteValidatorTest.assertTrue((String)"isValid(A) both", (boolean)ByteValidator.getInstance().isValid(germanPatternVal, pattern, Locale.GERMAN));
        ByteValidatorTest.assertNull((String)"validate(B) default", (Object)ByteValidator.getInstance().validate(XXXX));
        ByteValidatorTest.assertNull((String)"validate(B) locale ", (Object)ByteValidator.getInstance().validate(XXXX, locale));
        ByteValidatorTest.assertNull((String)"validate(B) pattern", (Object)ByteValidator.getInstance().validate(XXXX, pattern));
        ByteValidatorTest.assertNull((String)"validate(B) both", (Object)ByteValidator.getInstance().validate(patternVal, pattern, Locale.GERMAN));
        ByteValidatorTest.assertFalse((String)"isValid(B) default", (boolean)ByteValidator.getInstance().isValid(XXXX));
        ByteValidatorTest.assertFalse((String)"isValid(B) locale ", (boolean)ByteValidator.getInstance().isValid(XXXX, locale));
        ByteValidatorTest.assertFalse((String)"isValid(B) pattern", (boolean)ByteValidator.getInstance().isValid(XXXX, pattern));
        ByteValidatorTest.assertFalse((String)"isValid(B) both", (boolean)ByteValidator.getInstance().isValid(patternVal, pattern, Locale.GERMAN));
    }

    public void testByteRangeMinMax() {
        ByteValidator validator = (ByteValidator)this.strictValidator;
        Byte number9 = validator.validate("9", "#");
        Byte number10 = validator.validate("10", "#");
        Byte number11 = validator.validate("11", "#");
        Byte number19 = validator.validate("19", "#");
        Byte number20 = validator.validate("20", "#");
        Byte number21 = validator.validate("21", "#");
        byte min = 10;
        byte max = 20;
        ByteValidatorTest.assertFalse((String)"isInRange() < min", (boolean)validator.isInRange(number9, min, max));
        ByteValidatorTest.assertTrue((String)"isInRange() = min", (boolean)validator.isInRange(number10, min, max));
        ByteValidatorTest.assertTrue((String)"isInRange() in range", (boolean)validator.isInRange(number11, min, max));
        ByteValidatorTest.assertTrue((String)"isInRange() = max", (boolean)validator.isInRange(number20, min, max));
        ByteValidatorTest.assertFalse((String)"isInRange() > max", (boolean)validator.isInRange(number21, min, max));
        ByteValidatorTest.assertFalse((String)"minValue() < min", (boolean)validator.minValue(number9, min));
        ByteValidatorTest.assertTrue((String)"minValue() = min", (boolean)validator.minValue(number10, min));
        ByteValidatorTest.assertTrue((String)"minValue() > min", (boolean)validator.minValue(number11, min));
        ByteValidatorTest.assertTrue((String)"maxValue() < max", (boolean)validator.maxValue(number19, max));
        ByteValidatorTest.assertTrue((String)"maxValue() = max", (boolean)validator.maxValue(number20, max));
        ByteValidatorTest.assertFalse((String)"maxValue() > max", (boolean)validator.maxValue(number21, max));
    }
}

