/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import org.apache.commons.text.lookup.XmlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlStringLookupTest {
    private static final String DOC_PATH = "src/test/resources/document.xml";

    @Test
    public void testBadXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.lookup("docName"));
    }

    @Test
    public void testMissingXPath() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> XmlStringLookup.INSTANCE.lookup("src/test/resources/document.xml:!JUNK!"));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)XmlStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        String xpath = "/root/path/to/node";
        Assertions.assertEquals((Object)"Hello World!", (Object)XmlStringLookup.INSTANCE.lookup("src/test/resources/document.xml:/root/path/to/node"));
    }

    @Test
    public void testToString() {
        Assertions.assertFalse((boolean)XmlStringLookup.INSTANCE.toString().isEmpty());
    }
}

