/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcher;
import org.apache.commons.text.matcher.StringMatcherFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringTokenizerTest {
    private static final String CSV_SIMPLE_FIXTURE = "A,b,c";
    private static final String TSV_SIMPLE_FIXTURE = "A\tb\tc";

    private void checkClone(StringTokenizer tokenizer) {
        Assertions.assertFalse((StringTokenizer.getCSVInstance() == tokenizer ? 1 : 0) != 0);
        Assertions.assertFalse((StringTokenizer.getTSVInstance() == tokenizer ? 1 : 0) != 0);
    }

    @Test
    public void test1() {
        String input = "a;b;c;\"d;\"\"e\";f; ; ;  ";
        StringTokenizer tok = new StringTokenizer("a;b;c;\"d;\"\"e\";f; ; ;  ");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", "", "", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test2() {
        String input = "a;b;c ;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b;c ;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c ", "d;\"e", "f", " ", " ", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test3() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", " ", " ", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test4() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f"};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test5() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", null, null, null};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test6() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StringTokenizer tok = new StringTokenizer("a;b; c;\"d;\"\"e\";f; ; ;");
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", null, null, null};
        int nextCount = 0;
        while (tok.hasNext()) {
            tok.next();
            ++nextCount;
        }
        int prevCount = 0;
        while (tok.hasPrevious()) {
            tok.previous();
            ++prevCount;
        }
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        Assertions.assertTrue((nextCount == expected.length ? 1 : 0) != 0, (String)"could not cycle through entire token list using the 'hasNext' and 'next' methods");
        Assertions.assertTrue((prevCount == expected.length ? 1 : 0) != 0, (String)"could not cycle through entire token list using the 'hasPrevious' and 'previous' methods");
    }

    @Test
    public void test7() {
        String input = "a   b c \"d e\" f ";
        StringTokenizer tok = new StringTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "", "", "b", "c", "d e", "f", ""};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void test8() {
        String input = "a   b c \"d e\" f ";
        StringTokenizer tok = new StringTokenizer("a   b c \"d e\" f ");
        tok.setDelimiterMatcher(StringMatcherFactory.INSTANCE.spaceMatcher());
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.noneMatcher());
        tok.setIgnoreEmptyTokens(true);
        Object[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d e", "f"};
        Assertions.assertEquals((int)expected.length, (int)tokens.length, (String)Arrays.toString(tokens));
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)tokens[i], (String)("token[" + i + "] was '" + (String)tokens[i] + "' but was expected to be '" + expected[i] + "'"));
        }
    }

    @Test
    public void testBasic1() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic2() {
        String input = "a \nb\fc";
        StringTokenizer tok = new StringTokenizer("a \nb\fc");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic3() {
        String input = "a \nb\u0001\fc";
        StringTokenizer tok = new StringTokenizer("a \nb\u0001\fc");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b\u0001", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic4() {
        String input = "a \"b\" c";
        StringTokenizer tok = new StringTokenizer("a \"b\" c");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"\"b\"", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasic5() {
        String input = "a:b':c";
        StringTokenizer tok = new StringTokenizer("a:b':c", ':', '\'');
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b'", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim1() {
        String input = "a:b:c";
        StringTokenizer tok = new StringTokenizer("a:b:c", ':');
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicDelim2() {
        String input = "a:b:c";
        StringTokenizer tok = new StringTokenizer("a:b:c", ',');
        Assertions.assertEquals((Object)"a:b:c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty1() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicEmpty2() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed1() {
        String input = "a: bIGNOREc : ";
        StringTokenizer tok = new StringTokenizer("a: bIGNOREc : ", ':');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bc", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed2() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StringTokenizer tok = new StringTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bc", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed3() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StringTokenizer tok = new StringTokenizer("IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ", ':');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"  bc  ", (Object)tok.next());
        Assertions.assertEquals((Object)"  ", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicIgnoreTrimmed4() {
        String input = "IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ";
        StringTokenizer tok = new StringTokenizer("IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ", ':', '\'');
        tok.setIgnoredMatcher(StringMatcherFactory.INSTANCE.stringMatcher("IGNORE"));
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bIGNOREcd", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted1() {
        String input = "a 'b' c";
        StringTokenizer tok = new StringTokenizer("a 'b' c", ' ', '\'');
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted2() {
        String input = "a:'b':";
        StringTokenizer tok = new StringTokenizer("a:'b':", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted3() {
        String input = "a:'b''c'";
        StringTokenizer tok = new StringTokenizer("a:'b''c'", ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b'c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted4() {
        String input = "a: 'b' 'c' :d";
        StringTokenizer tok = new StringTokenizer("a: 'b' 'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b c", (Object)tok.next());
        Assertions.assertEquals((Object)"d", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted5() {
        String input = "a: 'b'x'c' :d";
        StringTokenizer tok = new StringTokenizer("a: 'b'x'c' :d", ':', '\'');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"bxc", (Object)tok.next());
        Assertions.assertEquals((Object)"d", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted6() {
        String input = "a:'b'\"c':d";
        StringTokenizer tok = new StringTokenizer("a:'b'\"c':d", ':');
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.quoteMatcher());
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b\"c:d", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuoted7() {
        String input = "a:\"There's a reason here\":b";
        StringTokenizer tok = new StringTokenizer("a:\"There's a reason here\":b", ':');
        tok.setQuoteMatcher(StringMatcherFactory.INSTANCE.quoteMatcher());
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"There's a reason here", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicQuotedTrimmed1() {
        String input = "a: 'b' :";
        StringTokenizer tok = new StringTokenizer("a: 'b' :", ':', '\'');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed1() {
        String input = "a: b :  ";
        StringTokenizer tok = new StringTokenizer("a: b :  ", ':');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testBasicTrimmed2() {
        String input = "a:  b  :";
        StringTokenizer tok = new StringTokenizer("a:  b  :", ':');
        tok.setTrimmerMatcher(StringMatcherFactory.INSTANCE.stringMatcher("  "));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertNull((Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testChaining() {
        StringTokenizer tok = new StringTokenizer();
        Assertions.assertEquals((Object)tok, (Object)tok.reset());
        Assertions.assertEquals((Object)tok, (Object)tok.reset(""));
        Assertions.assertEquals((Object)tok, (Object)tok.reset(ArrayUtils.EMPTY_CHAR_ARRAY));
        Assertions.assertEquals((Object)tok, (Object)tok.setDelimiterChar(' '));
        Assertions.assertEquals((Object)tok, (Object)tok.setDelimiterString(" "));
        Assertions.assertEquals((Object)tok, (Object)tok.setDelimiterMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setQuoteChar(' '));
        Assertions.assertEquals((Object)tok, (Object)tok.setQuoteMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setIgnoredChar(' '));
        Assertions.assertEquals((Object)tok, (Object)tok.setIgnoredMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setTrimmerMatcher(null));
        Assertions.assertEquals((Object)tok, (Object)tok.setEmptyTokenAsNull(false));
        Assertions.assertEquals((Object)tok, (Object)tok.setIgnoreEmptyTokens(false));
    }

    @Test
    public void testCloneNotSupportedException() {
        Object notCloned = new StringTokenizer(){

            Object cloneReset() throws CloneNotSupportedException {
                throw new CloneNotSupportedException("test");
            }
        }.clone();
        Assertions.assertNull((Object)notCloned);
    }

    @Test
    public void testCloneNull() {
        StringTokenizer tokenizer = new StringTokenizer((char[])null);
        Assertions.assertNull((Object)tokenizer.nextToken());
        tokenizer.reset();
        Assertions.assertNull((Object)tokenizer.nextToken());
        StringTokenizer clonedTokenizer = (StringTokenizer)tokenizer.clone();
        tokenizer.reset();
        Assertions.assertNull((Object)tokenizer.nextToken());
        Assertions.assertNull((Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testCloneReset() {
        char[] input = new char[]{'a'};
        StringTokenizer tokenizer = new StringTokenizer(input);
        Assertions.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        tokenizer.reset(input);
        Assertions.assertEquals((Object)"a", (Object)tokenizer.nextToken());
        StringTokenizer clonedTokenizer = (StringTokenizer)tokenizer.clone();
        input[0] = 98;
        tokenizer.reset(input);
        Assertions.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assertions.assertEquals((Object)"a", (Object)clonedTokenizer.nextToken());
    }

    @Test
    public void testConstructor_charArray() {
        StringTokenizer tok = new StringTokenizer("a b".toCharArray());
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer(ArrayUtils.EMPTY_CHAR_ARRAY);
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((char[])null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char() {
        StringTokenizer tok = new StringTokenizer("a b".toCharArray(), ' ');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch((CharSequence)" ", 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer(ArrayUtils.EMPTY_CHAR_ARRAY, ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((char[])null, ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_charArray_char_char() {
        StringTokenizer tok = new StringTokenizer("a b".toCharArray(), ' ', '\"');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch((CharSequence)" ", 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch((CharSequence)"\"", 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer(ArrayUtils.EMPTY_CHAR_ARRAY, ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((char[])null, ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String() {
        StringTokenizer tok = new StringTokenizer("a b");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer("");
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((String)null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char() {
        StringTokenizer tok = new StringTokenizer("a b", ' ');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch((CharSequence)" ", 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer("", ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((String)null, ' ');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testConstructor_String_char_char() {
        StringTokenizer tok = new StringTokenizer("a b", ' ', '\"');
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch((CharSequence)" ", 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        Assertions.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch((CharSequence)"\"", 0, 0, 1));
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer("", ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
        tok = new StringTokenizer((String)null, ' ', '\"');
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    private void testCSV(String data) {
        this.testXSVAbc(StringTokenizer.getCSVInstance((String)data));
        this.testXSVAbc(StringTokenizer.getCSVInstance((char[])data.toCharArray()));
    }

    @Test
    public void testCSVEmpty() {
        this.testEmpty(StringTokenizer.getCSVInstance());
        this.testEmpty(StringTokenizer.getCSVInstance((String)""));
    }

    @Test
    public void testCSVSimple() {
        this.testCSV(CSV_SIMPLE_FIXTURE);
    }

    @Test
    public void testCSVSimpleNeedsTrim() {
        this.testCSV("   A,b,c");
        this.testCSV("   \n\t  A,b,c");
        this.testCSV("   \n  A,b,c\n\n\r");
    }

    @Test
    public void testDelimMatcher() {
        String input = "a/b\\c";
        StringMatcher delimMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{'/', '\\'});
        StringTokenizer tok = new StringTokenizer("a/b\\c", delimMatcher);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimMatcherQuoteMatcher() {
        String input = "`a`;`b`;`c`";
        StringMatcher delimMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{';'});
        StringMatcher quoteMatcher = StringMatcherFactory.INSTANCE.charSetMatcher(new char[]{'`'});
        StringTokenizer tok = new StringTokenizer("`a`;`b`;`c`", delimMatcher, quoteMatcher);
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testDelimString() {
        String input = "a##b##c";
        StringTokenizer tok = new StringTokenizer("a##b##c", "##");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    void testEmpty(StringTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assertions.assertFalse((boolean)tokenizer.hasNext());
        Assertions.assertFalse((boolean)tokenizer.hasPrevious());
        Assertions.assertNull((Object)tokenizer.nextToken());
        Assertions.assertEquals((int)0, (int)tokenizer.size());
        Assertions.assertThrows(NoSuchElementException.class, () -> tokenizer.next());
    }

    @Test
    public void testGetContent() {
        String input = "a   b c \"d e\" f ";
        StringTokenizer tok = new StringTokenizer("a   b c \"d e\" f ");
        Assertions.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StringTokenizer("a   b c \"d e\" f ".toCharArray());
        Assertions.assertEquals((Object)"a   b c \"d e\" f ", (Object)tok.getContent());
        tok = new StringTokenizer();
        Assertions.assertNull((Object)tok.getContent());
    }

    @Test
    public void testIteration() {
        StringTokenizer tkn = new StringTokenizer("a b c");
        Assertions.assertFalse((boolean)tkn.hasPrevious());
        Assertions.assertThrows(NoSuchElementException.class, () -> tkn.previous());
        Assertions.assertTrue((boolean)tkn.hasNext());
        Assertions.assertEquals((Object)"a", (Object)tkn.next());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> tkn.remove());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> tkn.set("x"));
        Assertions.assertThrows(UnsupportedOperationException.class, () -> tkn.add("y"));
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertTrue((boolean)tkn.hasNext());
        Assertions.assertEquals((Object)"b", (Object)tkn.next());
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertTrue((boolean)tkn.hasNext());
        Assertions.assertEquals((Object)"c", (Object)tkn.next());
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertFalse((boolean)tkn.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> tkn.next());
        Assertions.assertTrue((boolean)tkn.hasPrevious());
        Assertions.assertFalse((boolean)tkn.hasNext());
    }

    @Test
    public void testListArray() {
        String input = "a  b c";
        StringTokenizer tok = new StringTokenizer("a  b c");
        String[] array = tok.getTokenArray();
        List list = tok.getTokenList();
        Assertions.assertEquals(Arrays.asList(array), (Object)list);
        Assertions.assertEquals((int)3, (int)list.size());
    }

    @Test
    public void testPreviousTokenAndSetEmptyTokenAsNull() {
        StringTokenizer strTokenizer = StringTokenizer.getTSVInstance((String)" \t\n\r\f");
        strTokenizer.setEmptyTokenAsNull(true);
        Assertions.assertNull((Object)strTokenizer.previousToken());
    }

    @Test
    public void testReset() {
        StringTokenizer tok = new StringTokenizer("a b c");
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok.reset();
        Assertions.assertEquals((Object)"a", (Object)tok.next());
        Assertions.assertEquals((Object)"b", (Object)tok.next());
        Assertions.assertEquals((Object)"c", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_charArray() {
        StringTokenizer tok = new StringTokenizer("x x x");
        char[] array = new char[]{'a', 'b', 'c'};
        tok.reset(array);
        Assertions.assertEquals((Object)"abc", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok.reset((char[])null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testReset_String() {
        StringTokenizer tok = new StringTokenizer("x x x");
        tok.reset("d e");
        Assertions.assertEquals((Object)"d", (Object)tok.next());
        Assertions.assertEquals((Object)"e", (Object)tok.next());
        Assertions.assertFalse((boolean)tok.hasNext());
        tok.reset((String)null);
        Assertions.assertFalse((boolean)tok.hasNext());
    }

    @Test
    public void testStringTokenizerQuoteMatcher() {
        char[] chars = new char[]{'\'', 'a', 'c', '\'', 'd'};
        StringTokenizer tokens = new StringTokenizer(chars, StringMatcherFactory.INSTANCE.commaMatcher(), StringMatcherFactory.INSTANCE.quoteMatcher());
        Assertions.assertEquals((Object)"acd", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerStringMatcher() {
        char[] chars = new char[]{'a', 'b', 'c', 'd'};
        StringTokenizer tokens = new StringTokenizer(chars, "bc");
        Assertions.assertEquals((Object)"a", (Object)tokens.next());
        Assertions.assertEquals((Object)"d", (Object)tokens.next());
    }

    @Test
    public void testStringTokenizerStrMatcher() {
        char[] chars = new char[]{'a', ',', 'c'};
        StringTokenizer tokens = new StringTokenizer(chars, StringMatcherFactory.INSTANCE.commaMatcher());
        Assertions.assertEquals((Object)"a", (Object)tokens.next());
        Assertions.assertEquals((Object)"c", (Object)tokens.next());
    }

    @Test
    public void testTokenizeSubclassInputChange() {
        StringTokenizer tkn = new StringTokenizer("a b c d e"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                return super.tokenize("w x y z".toCharArray(), 2, 5);
            }
        };
        Assertions.assertEquals((Object)"x", (Object)tkn.next());
        Assertions.assertEquals((Object)"y", (Object)tkn.next());
    }

    @Test
    public void testTokenizeSubclassOutputChange() {
        StringTokenizer tkn = new StringTokenizer("a b c"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                List list = super.tokenize(chars, offset, count);
                Collections.reverse(list);
                return list;
            }
        };
        Assertions.assertEquals((Object)"c", (Object)tkn.next());
        Assertions.assertEquals((Object)"b", (Object)tkn.next());
        Assertions.assertEquals((Object)"a", (Object)tkn.next());
    }

    @Test
    public void testToString() {
        StringTokenizer tkn = new StringTokenizer("a b c d e");
        Assertions.assertEquals((Object)"StringTokenizer[not tokenized yet]", (Object)tkn.toString());
        tkn.next();
        Assertions.assertEquals((Object)"StringTokenizer[a, b, c, d, e]", (Object)tkn.toString());
    }

    @Test
    public void testTSV() {
        this.testXSVAbc(StringTokenizer.getTSVInstance((String)TSV_SIMPLE_FIXTURE));
        this.testXSVAbc(StringTokenizer.getTSVInstance((char[])TSV_SIMPLE_FIXTURE.toCharArray()));
    }

    @Test
    public void testTSVEmpty() {
        this.testEmpty(StringTokenizer.getTSVInstance());
        this.testEmpty(StringTokenizer.getTSVInstance((String)""));
    }

    void testXSVAbc(StringTokenizer tokenizer) {
        this.checkClone(tokenizer);
        Assertions.assertEquals((int)-1, (int)tokenizer.previousIndex());
        Assertions.assertEquals((int)0, (int)tokenizer.nextIndex());
        Assertions.assertNull((Object)tokenizer.previousToken());
        Assertions.assertEquals((Object)"A", (Object)tokenizer.nextToken());
        Assertions.assertEquals((int)1, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"b", (Object)tokenizer.nextToken());
        Assertions.assertEquals((int)2, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"c", (Object)tokenizer.nextToken());
        Assertions.assertEquals((int)3, (int)tokenizer.nextIndex());
        Assertions.assertNull((Object)tokenizer.nextToken());
        Assertions.assertEquals((int)3, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"c", (Object)tokenizer.previousToken());
        Assertions.assertEquals((int)2, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"b", (Object)tokenizer.previousToken());
        Assertions.assertEquals((int)1, (int)tokenizer.nextIndex());
        Assertions.assertEquals((Object)"A", (Object)tokenizer.previousToken());
        Assertions.assertEquals((int)0, (int)tokenizer.nextIndex());
        Assertions.assertNull((Object)tokenizer.previousToken());
        Assertions.assertEquals((int)0, (int)tokenizer.nextIndex());
        Assertions.assertEquals((int)-1, (int)tokenizer.previousIndex());
        Assertions.assertEquals((int)3, (int)tokenizer.size());
    }
}

