/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JaccardDistanceTest {
    private static JaccardDistance classBeingTested;

    @BeforeAll
    public static void setUp() {
        classBeingTested = new JaccardDistance();
    }

    @Test
    public void testGettingJaccardDistance() {
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)""));
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)""));
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.25, (Double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"));
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (Double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.7777777777777778, (Double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.36363636363636365, (Double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.23529411764705888, (Double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.11111111111111116, (Double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.09999999999999998, (Double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.875, (Double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.875, (Double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"));
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (Double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"));
    }

    @Test
    public void testGettingJaccardDistanceNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, null));
    }

    @Test
    public void testGettingJaccardDistanceStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply((CharSequence)" ", null));
    }

    @Test
    public void testGettingJaccardDistanceNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, (CharSequence)"right"));
    }
}

