/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.ResourceBundle;
import org.apache.commons.text.lookup.ResourceBundleStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceBundleStringLookupTest {
    private static final String TEST_RESOURCE_BUNDLE = "org.example.testResourceBundleLookup";

    @Test
    public void testAny() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = "key";
        Assertions.assertEquals((Object)ResourceBundle.getBundle(TEST_RESOURCE_BUNDLE).getString("key"), (Object)ResourceBundleStringLookup.INSTANCE.lookup("org.example.testResourceBundleLookup:key"));
    }

    @Test
    public void testBadKey() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = "bad_key";
        Assertions.assertNull((Object)new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).lookup("bad_key"));
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.lookup("org.example.testResourceBundleLookup:bad_key"));
    }

    @Test
    public void testBadName() {
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.lookup("BAD_RESOURCE_BUNDLE_NAME:KEY"));
    }

    @Test
    public void testMissingKeyInSpec() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        Assertions.assertThrows(IllegalArgumentException.class, () -> ResourceBundleStringLookup.INSTANCE.lookup("org.example.testResourceBundleLookup:"));
    }

    @Test
    public void testNull() {
        Assertions.assertNull((Object)ResourceBundleStringLookup.INSTANCE.lookup(null));
    }

    @Test
    public void testOne() {
        String bundleName = TEST_RESOURCE_BUNDLE;
        String bundleKey = "key";
        Assertions.assertEquals((Object)ResourceBundle.getBundle(TEST_RESOURCE_BUNDLE).getString("key"), (Object)new ResourceBundleStringLookup(TEST_RESOURCE_BUNDLE).lookup("key"));
    }
}

