/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text;

import java.util.Formattable;
import java.util.Formatter;
import org.apache.commons.text.FormattableUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FormattableUtilsTest {
    private Formatter createFormatter() {
        return new Formatter();
    }

    @Test
    public void testPublicConstructorExists() {
        new FormattableUtils();
    }

    @Test
    public void testSimplestFormat() {
        SimplestFormattable formattable = new SimplestFormattable("foo");
        Assertions.assertThat((String)FormattableUtils.toString((Formattable)formattable)).isEqualTo("foo");
    }

    @Test
    public void testDefaultAppend() {
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1).toString()).isEqualTo("foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2).toString()).isEqualTo("fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1).toString()).isEqualTo(" foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1).toString()).isEqualTo("   foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2).toString()).isEqualTo(" fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2).toString()).isEqualTo("   fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1).toString()).isEqualTo("foo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1).toString()).isEqualTo("foo   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2).toString()).isEqualTo("fo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2).toString()).isEqualTo("fo   ");
    }

    @Test
    public void testAlternatePadCharacter() {
        int pad = 95;
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (char)'_').toString()).isEqualTo("foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (char)'_').toString()).isEqualTo("fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (char)'_').toString()).isEqualTo("_foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (char)'_').toString()).isEqualTo("___foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (char)'_').toString()).isEqualTo("_fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (char)'_').toString()).isEqualTo("___fo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (char)'_').toString()).isEqualTo("foo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (char)'_').toString()).isEqualTo("foo___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (char)'_').toString()).isEqualTo("fo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (char)'_').toString()).isEqualTo("fo___");
    }

    @Test
    public void testEllipsis() {
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (CharSequence)"*").toString()).isEqualTo("foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (CharSequence)"*").toString()).isEqualTo("f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (CharSequence)"*").toString()).isEqualTo(" foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (CharSequence)"*").toString()).isEqualTo("   foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (CharSequence)"*").toString()).isEqualTo(" f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (CharSequence)"*").toString()).isEqualTo("   f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (CharSequence)"*").toString()).isEqualTo("foo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (CharSequence)"*").toString()).isEqualTo("foo   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (CharSequence)"*").toString()).isEqualTo("f* ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (CharSequence)"*").toString()).isEqualTo("f*   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (CharSequence)"+*").toString()).isEqualTo("foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (CharSequence)"+*").toString()).isEqualTo("+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (CharSequence)"+*").toString()).isEqualTo(" foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (CharSequence)"+*").toString()).isEqualTo("   foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (CharSequence)"+*").toString()).isEqualTo(" +*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (CharSequence)"+*").toString()).isEqualTo("   +*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (CharSequence)"+*").toString()).isEqualTo("foo ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (CharSequence)"+*").toString()).isEqualTo("foo   ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (CharSequence)"+*").toString()).isEqualTo("+* ");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (CharSequence)"+*").toString()).isEqualTo("+*   ");
    }

    @Test
    public void testIllegalEllipsis() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)1, (CharSequence)"xx"));
    }

    @Test
    public void testAlternatePadCharAndEllipsis() {
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo("foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo("f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo("_foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo("___foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo("_f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo("___f*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo("foo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (char)'_', (CharSequence)"*").toString()).isEqualTo("foo___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo("f*_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (char)'_', (CharSequence)"*").toString()).isEqualTo("f*___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo("foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)-1, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo("+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)4, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo("_foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)6, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo("___foo");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)3, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo("_+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)0, (int)5, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo("___+*");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)4, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo("foo_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)6, (int)-1, (char)'_', (CharSequence)"+*").toString()).isEqualTo("foo___");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)3, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo("+*_");
        Assertions.assertThat((String)FormattableUtils.append((CharSequence)"foo", (Formatter)this.createFormatter(), (int)1, (int)5, (int)2, (char)'_', (CharSequence)"+*").toString()).isEqualTo("+*___");
    }

    @Test
    public void testAppendWithNullFormatterAndIntsThrowsNullPointerException() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> FormattableUtils.append((CharSequence)"", null, (int)0, (int)0, (int)0, (char)'}'));
    }

    static class SimplestFormattable
    implements Formattable {
        private final String text;

        SimplestFormattable(String text) {
            this.text = text;
        }

        @Override
        public void formatTo(Formatter formatter, int flags, int width, int precision) {
            formatter.format(this.text, new Object[0]);
        }
    }
}

