/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.UnicodeUnescaper;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnicodeUnescaperTest {
    @Test
    public void testUPlus() {
        UnicodeUnescaper uu = new UnicodeUnescaper();
        String input = "\\u+0047";
        ((AbstractStringAssert)Assertions.assertThat((String)uu.translate((CharSequence)"\\u+0047")).as("Failed to unescape Unicode characters with 'u+' notation", new Object[0])).isEqualTo((Object)"G");
    }

    @Test
    public void testUuuuu() {
        UnicodeUnescaper uu = new UnicodeUnescaper();
        String input = "\\uuuuuuuu0047";
        String result = uu.translate((CharSequence)"\\uuuuuuuu0047");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to unescape Unicode characters with many 'u' characters", new Object[0])).isEqualTo((Object)"G");
    }

    @Test
    public void testLessThanFour() {
        UnicodeUnescaper uu = new UnicodeUnescaper();
        String input = "\\0047\\u006";
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> uu.translate((CharSequence)"\\0047\\u006"));
    }
}

