/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.NumericEntityUnescaper;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class NumericEntityUnescaperTest {
    @Test
    public void testSupplementaryUnescaping() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        String input = "&#68642;";
        String expected = "\ud803\udc22";
        String result = neu.translate((CharSequence)"&#68642;");
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to unescape numeric entities supplementary characters", new Object[0])).isEqualTo((Object)"\ud803\udc22");
    }

    @Test
    public void testOutOfBounds() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        ((AbstractStringAssert)Assertions.assertThat((String)neu.translate((CharSequence)"Test &")).as("Failed to ignore when last character is &", new Object[0])).isEqualTo((Object)"Test &");
        ((AbstractStringAssert)Assertions.assertThat((String)neu.translate((CharSequence)"Test &#")).as("Failed to ignore when last character is &", new Object[0])).isEqualTo((Object)"Test &#");
        ((AbstractStringAssert)Assertions.assertThat((String)neu.translate((CharSequence)"Test &#x")).as("Failed to ignore when last character is &", new Object[0])).isEqualTo((Object)"Test &#x");
        ((AbstractStringAssert)Assertions.assertThat((String)neu.translate((CharSequence)"Test &#X")).as("Failed to ignore when last character is &", new Object[0])).isEqualTo((Object)"Test &#X");
    }

    @Test
    public void testUnfinishedEntity() {
        NumericEntityUnescaper neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.semiColonOptional});
        String input = "Test &#x30 not test";
        String expected = "Test 0 not test";
        String result = neu.translate((CharSequence)input);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to support unfinished entities (i.e. missing semi-colon)", new Object[0])).isEqualTo((Object)expected);
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]);
        expected = input = "Test &#x30 not test";
        result = neu.translate((CharSequence)input);
        ((AbstractStringAssert)Assertions.assertThat((String)result).as("Failed to ignore unfinished entities (i.e. missing semi-colon)", new Object[0])).isEqualTo((Object)expected);
        neu = new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[]{NumericEntityUnescaper.OPTION.errorIfNoSemiColon});
        input = "Test &#x30 not test";
        try {
            result = neu.translate((CharSequence)input);
            Assertions.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCreatesNumericEntityUnescaperOne() {
        NumericEntityUnescaper.OPTION[] numericEntityUnescaperOPTIONArray = new NumericEntityUnescaper.OPTION[]{};
        NumericEntityUnescaper numericEntityUnescaper = new NumericEntityUnescaper(numericEntityUnescaperOPTIONArray);
        Assertions.assertThat((String)numericEntityUnescaper.translate((CharSequence)"2|y|O7y`&#uVWj")).isEqualTo((Object)"2|y|O7y`&#uVWj");
    }

    @Test
    public void testCreatesNumericEntityUnescaperTwo() {
        NumericEntityUnescaper.OPTION[] numericEntityUnescaperOPTIONArray = new NumericEntityUnescaper.OPTION[]{};
        NumericEntityUnescaper numericEntityUnescaper = new NumericEntityUnescaper(numericEntityUnescaperOPTIONArray);
        Assertions.assertThat((String)numericEntityUnescaper.translate((CharSequence)"Ws2v8|O=7NR&#cB")).isEqualTo((Object)"Ws2v8|O=7NR&#cB");
    }
}

