/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.lookup;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.lookup.Base64DecoderStringLookup;
import org.apache.commons.text.lookup.Base64EncoderStringLookup;
import org.apache.commons.text.lookup.ConstantStringLookup;
import org.apache.commons.text.lookup.DateStringLookup;
import org.apache.commons.text.lookup.EnvironmentVariableStringLookup;
import org.apache.commons.text.lookup.InterpolatorStringLookup;
import org.apache.commons.text.lookup.JavaPlatformStringLookup;
import org.apache.commons.text.lookup.LocalHostStringLookup;
import org.apache.commons.text.lookup.NullStringLookup;
import org.apache.commons.text.lookup.ResourceBundleStringLookup;
import org.apache.commons.text.lookup.ScriptStringLookup;
import org.apache.commons.text.lookup.StringLookup;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.apache.commons.text.lookup.SystemPropertyStringLookup;
import org.apache.commons.text.lookup.UrlDecoderStringLookup;
import org.apache.commons.text.lookup.UrlEncoderStringLookup;
import org.apache.commons.text.lookup.UrlStringLookup;
import org.apache.commons.text.lookup.XmlStringLookup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringLookupFactoryTest {
    public static void assertDefaultKeys(Map<String, StringLookup> stringLookupMap) {
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("base64Decoder"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("base64Encoder"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("const"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("date"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("env"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("file"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("java"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("localhost"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("properties"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("resourceBundle"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("script"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("sys"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("url"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("urlDecoder"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("urlEncoder"));
        Assertions.assertTrue((boolean)stringLookupMap.containsKey("xml"));
    }

    @Test
    public void addDefaultStringLookupsMap() {
        HashMap<String, StringLookup> stringLookupMap = new HashMap<String, StringLookup>();
        StringLookupFactory.INSTANCE.addDefaultStringLookups(stringLookupMap);
        StringLookupFactoryTest.assertDefaultKeys(stringLookupMap);
    }

    @Test
    public void addDefaultStringLookupsNull() {
        StringLookupFactory.INSTANCE.addDefaultStringLookups(null);
    }

    @Test
    public void testSingletons() {
        StringLookupFactory stringLookupFactory = StringLookupFactory.INSTANCE;
        Assertions.assertSame((Object)Base64DecoderStringLookup.INSTANCE, (Object)stringLookupFactory.base64DecoderStringLookup());
        Assertions.assertSame((Object)Base64EncoderStringLookup.INSTANCE, (Object)stringLookupFactory.base64EncoderStringLookup());
        Assertions.assertSame((Object)ConstantStringLookup.INSTANCE, (Object)stringLookupFactory.constantStringLookup());
        Assertions.assertSame((Object)DateStringLookup.INSTANCE, (Object)stringLookupFactory.dateStringLookup());
        Assertions.assertSame((Object)EnvironmentVariableStringLookup.INSTANCE, (Object)stringLookupFactory.environmentVariableStringLookup());
        Assertions.assertSame((Object)InterpolatorStringLookup.INSTANCE, (Object)stringLookupFactory.interpolatorStringLookup());
        Assertions.assertSame((Object)JavaPlatformStringLookup.INSTANCE, (Object)stringLookupFactory.javaPlatformStringLookup());
        Assertions.assertSame((Object)LocalHostStringLookup.INSTANCE, (Object)stringLookupFactory.localHostStringLookup());
        Assertions.assertSame((Object)NullStringLookup.INSTANCE, (Object)stringLookupFactory.nullStringLookup());
        Assertions.assertSame((Object)ResourceBundleStringLookup.INSTANCE, (Object)stringLookupFactory.resourceBundleStringLookup());
        Assertions.assertSame((Object)ScriptStringLookup.INSTANCE, (Object)stringLookupFactory.scriptStringLookup());
        Assertions.assertSame((Object)SystemPropertyStringLookup.INSTANCE, (Object)stringLookupFactory.systemPropertyStringLookup());
        Assertions.assertSame((Object)UrlDecoderStringLookup.INSTANCE, (Object)stringLookupFactory.urlDecoderStringLookup());
        Assertions.assertSame((Object)UrlEncoderStringLookup.INSTANCE, (Object)stringLookupFactory.urlEncoderStringLookup());
        Assertions.assertSame((Object)UrlStringLookup.INSTANCE, (Object)stringLookupFactory.urlStringLookup());
        Assertions.assertSame((Object)XmlStringLookup.INSTANCE, (Object)stringLookupFactory.xmlStringLookup());
    }
}

