/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import org.apache.commons.text.translate.NumericEntityEscaper;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class NumericEntityEscaperTest {
    @Test
    public void testBelow() {
        NumericEntityEscaper nee = NumericEntityEscaper.below((int)70);
        String input = "ADFGZ";
        String result = nee.translate((CharSequence)"ADFGZ");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).as("Failed to escape numeric entities via the below method", new Object[0])).isEqualTo((Object)"&#65;&#68;FGZ");
    }

    @Test
    public void testBetween() {
        NumericEntityEscaper nee = NumericEntityEscaper.between((int)70, (int)76);
        String input = "ADFGZ";
        String result = nee.translate((CharSequence)"ADFGZ");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).as("Failed to escape numeric entities via the between method", new Object[0])).isEqualTo((Object)"AD&#70;&#71;Z");
    }

    @Test
    public void testAbove() {
        NumericEntityEscaper nee = NumericEntityEscaper.above((int)70);
        String input = "ADFGZ";
        String result = nee.translate((CharSequence)"ADFGZ");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).as("Failed to escape numeric entities via the above method", new Object[0])).isEqualTo((Object)"ADF&#71;&#90;");
    }

    @Test
    public void testSupplementary() {
        NumericEntityEscaper nee = new NumericEntityEscaper();
        String input = "\ud803\udc22";
        String expected = "&#68642;";
        String result = nee.translate((CharSequence)"\ud803\udc22");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)result).as("Failed to escape numeric entities supplementary characters", new Object[0])).isEqualTo((Object)"&#68642;");
    }
}

