/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedLevenshteinDistanceTest {
    private final Integer distance;
    private final CharSequence left;
    private final CharSequence right;
    private final Integer threshold;

    public ParameterizedLevenshteinDistanceTest(Integer threshold, CharSequence left, CharSequence right, Integer distance) {
        this.threshold = threshold;
        this.left = left;
        this.right = right;
        this.distance = distance;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> parameters() {
        return Arrays.asList({0, "", "", 0}, {8, "aaapppp", "", 7}, {7, "aaapppp", "", 7}, {6, "aaapppp", "", -1}, {0, "b", "a", -1}, {0, "a", "b", -1}, {0, "aa", "aa", 0}, {2, "aa", "aa", 0}, {2, "aaa", "bbb", -1}, {3, "aaa", "bbb", 3}, {10, "aaaaaa", "b", 6}, {8, "aaapppp", "b", 7}, {4, "a", "bbb", 3}, {7, "aaapppp", "b", 7}, {3, "a", "bbb", 3}, {2, "a", "bbb", -1}, {2, "bbb", "a", -1}, {6, "aaapppp", "b", -1}, {1, "a", "bbb", -1}, {1, "bbb", "a", -1}, {1, "12345", "1234567", -1}, {1, "1234567", "12345", -1}, {1, "frog", "fog", 1}, {3, "fly", "ant", 3}, {7, "elephant", "hippo", 7}, {6, "elephant", "hippo", -1}, {7, "hippo", "elephant", 7}, {6, "hippo", "elephant", -1}, {8, "hippo", "zzzzzzzz", 8}, {8, "zzzzzzzz", "hippo", 8}, {1, "hello", "hallo", 1}, {Integer.MAX_VALUE, "frog", "fog", 1}, {Integer.MAX_VALUE, "fly", "ant", 3}, {Integer.MAX_VALUE, "elephant", "hippo", 7}, {Integer.MAX_VALUE, "hippo", "elephant", 7}, {Integer.MAX_VALUE, "hippo", "zzzzzzzz", 8}, {Integer.MAX_VALUE, "zzzzzzzz", "hippo", 8}, {Integer.MAX_VALUE, "hello", "hallo", 1});
    }

    @Test
    public void test() {
        LevenshteinDistance metric = new LevenshteinDistance(this.threshold);
        Assert.assertThat((Object)metric.apply(this.left, this.right), (Matcher)IsEqual.equalTo((Object)this.distance));
    }
}

