/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.TextStringBuilder;
import org.apache.commons.text.similarity.LevenshteinDetailedDistance;
import org.apache.commons.text.similarity.LevenshteinResults;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class LevenshteinDetailedDistanceTest {
    private static final LevenshteinDetailedDistance UNLIMITED_DISTANCE = new LevenshteinDetailedDistance();

    @Test
    public void testGetLevenshteinDetailedDistance_StringString() {
        LevenshteinResults result = UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"a");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"frog", (CharSequence)"fog");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"fly", (CharSequence)"ant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(3);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(8);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(5);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(8);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(5);
        result = UNLIMITED_DISTANCE.apply((CharSequence)"hello", (CharSequence)"hallo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
    }

    @Test
    public void testEquals() {
        LevenshteinDetailedDistance classBeingTested = new LevenshteinDetailedDistance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"hello", (CharSequence)"hallo");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        Assertions.assertThat((Object)expectedResult).isEqualTo((Object)actualResult);
        actualResult = classBeingTested.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        expectedResult = new LevenshteinResults(Integer.valueOf(8), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(5));
        Assertions.assertThat((Object)expectedResult).isEqualTo((Object)actualResult);
        Assertions.assertThat((Object)actualResult).isEqualTo((Object)actualResult);
        actualResult = classBeingTested.apply((CharSequence)"", (CharSequence)"");
        expectedResult = new LevenshteinResults(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0));
        Assertions.assertThat((Object)expectedResult).isEqualTo((Object)actualResult);
    }

    @Test
    public void testHashCode() {
        LevenshteinDetailedDistance classBeingTested = new LevenshteinDetailedDistance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"aaapppp", (CharSequence)"");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(7), Integer.valueOf(0));
        Assertions.assertThat((int)expectedResult.hashCode()).isEqualTo(actualResult.hashCode());
        actualResult = classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog");
        expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(0));
        Assertions.assertThat((int)expectedResult.hashCode()).isEqualTo(actualResult.hashCode());
        actualResult = classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo");
        expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(0), Integer.valueOf(3), Integer.valueOf(4));
        Assertions.assertThat((int)expectedResult.hashCode()).isEqualTo(actualResult.hashCode());
    }

    @Test
    public void testToString() {
        LevenshteinDetailedDistance classBeingTested = new LevenshteinDetailedDistance();
        LevenshteinResults actualResult = classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant");
        LevenshteinResults expectedResult = new LevenshteinResults(Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(3));
        Assertions.assertThat((String)expectedResult.toString()).isEqualTo((Object)actualResult.toString());
        actualResult = classBeingTested.apply((CharSequence)"hippo", (CharSequence)"elephant");
        expectedResult = new LevenshteinResults(Integer.valueOf(7), Integer.valueOf(3), Integer.valueOf(0), Integer.valueOf(4));
        Assertions.assertThat((String)expectedResult.toString()).isEqualTo((Object)actualResult.toString());
        actualResult = classBeingTested.apply((CharSequence)"", (CharSequence)"a");
        expectedResult = new LevenshteinResults(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0));
        Assertions.assertThat((String)expectedResult.toString()).isEqualTo((Object)actualResult.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_NullString() {
        UNLIMITED_DISTANCE.apply((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_StringNull() {
        UNLIMITED_DISTANCE.apply(null, (CharSequence)"a");
    }

    @Test
    public void testGetLevenshteinDetailedDistance_StringStringInt() {
        LevenshteinResults result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"", (CharSequence)"");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"b", (CharSequence)"a");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"a", (CharSequence)"b");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(0)).apply((CharSequence)"aa", (CharSequence)"aa");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"aa", (CharSequence)"aa");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"aaa", (CharSequence)"bbb");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"aaa", (CharSequence)"bbb");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(3);
        result = new LevenshteinDetailedDistance(Integer.valueOf(10)).apply((CharSequence)"aaaaaa", (CharSequence)"b");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(6);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(5);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(6);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
        result = new LevenshteinDetailedDistance(Integer.valueOf(4)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(2);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(6);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(2);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(2)).apply((CharSequence)"bbb", (CharSequence)"a");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"b");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"a", (CharSequence)"bbb");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"bbb", (CharSequence)"a");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"12345", (CharSequence)"1234567");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"1234567", (CharSequence)"12345");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"frog", (CharSequence)"fog");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(3)).apply((CharSequence)"fly", (CharSequence)"ant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(3);
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = new LevenshteinDetailedDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = new LevenshteinDetailedDistance(Integer.valueOf(6)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(-1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(8);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(5);
        result = new LevenshteinDetailedDistance(Integer.valueOf(8)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(8);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(5);
        result = new LevenshteinDetailedDistance(Integer.valueOf(1)).apply((CharSequence)"hello", (CharSequence)"hallo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"frog", (CharSequence)"fog");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(0);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"fly", (CharSequence)"ant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(3);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"elephant", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"elephant");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(7);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(4);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(8);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(5);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(8);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(3);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(5);
        result = new LevenshteinDetailedDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hello", (CharSequence)"hallo");
        Assertions.assertThat((Integer)result.getDistance()).isEqualTo(1);
        Assertions.assertThat((Integer)result.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)result.getSubstituteCount()).isEqualTo(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_NullStringInt() {
        UNLIMITED_DISTANCE.apply(null, (CharSequence)"a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetLevenshteinDetailedDistance_StringNullInt() {
        UNLIMITED_DISTANCE.apply((CharSequence)"a", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstructorWithNegativeThreshold() {
        new LevenshteinDetailedDistance(Integer.valueOf(-1));
    }

    @Test
    public void testGetDefaultInstanceOne() {
        LevenshteinDetailedDistance levenshteinDetailedDistance = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults levenshteinResults = levenshteinDetailedDistance.apply((CharSequence)"Distance: -2147483643, Insert: 0, Delete: 0, Substitute: 0", (CharSequence)"Distance: 0, Insert: 2147483536, Delete: 0, Substitute: 0");
        Assertions.assertThat((Integer)levenshteinResults.getDistance()).isEqualTo(21);
    }

    @Test
    public void testGetDefaultInstanceTwo() {
        LevenshteinDetailedDistance levenshteinDetailedDistance = LevenshteinDetailedDistance.getDefaultInstance();
        LevenshteinResults levenshteinResults = levenshteinDetailedDistance.apply((CharSequence)"Distance: 2147483647, Insert: 0, Delete: 0, Substitute: 0", (CharSequence)"Distance: 0, Insert: 2147483647, Delete: 0, Substitute: 0");
        Assertions.assertThat((Integer)levenshteinResults.getDistance()).isEqualTo(20);
    }

    @Test
    public void testCreatesLevenshteinDetailedDistanceTakingInteger6() {
        LevenshteinDetailedDistance levenshteinDetailedDistance = new LevenshteinDetailedDistance(Integer.valueOf(0));
        LevenshteinResults levenshteinResults = levenshteinDetailedDistance.apply((CharSequence)"", (CharSequence)"Distance: 38, Insert: 0, Delete: 0, Substitute: 0");
        Assertions.assertThat((Integer)levenshteinResults.getSubstituteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)levenshteinResults.getDeleteCount()).isEqualTo(0);
        Assertions.assertThat((Integer)levenshteinResults.getInsertCount()).isEqualTo(0);
        Assertions.assertThat((Integer)levenshteinResults.getDistance()).isEqualTo(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testApplyThrowsIllegalArgumentExceptionAndCreatesLevenshteinDetailedDistanceTakingInteger() {
        LevenshteinDetailedDistance levenshteinDetailedDistance = new LevenshteinDetailedDistance(Integer.valueOf(0));
        TextStringBuilder charSequence = new TextStringBuilder();
        levenshteinDetailedDistance.apply((CharSequence)charSequence, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testApplyWithNull() {
        new LevenshteinDetailedDistance(Integer.valueOf(0)).apply(null, null);
    }

    @Test
    public void testGetThreshold() {
        LevenshteinDetailedDistance levenshteinDetailedDistance = new LevenshteinDetailedDistance(Integer.valueOf(0));
        Assertions.assertThat((Integer)levenshteinDetailedDistance.getThreshold()).isEqualTo(0);
    }
}

