/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JaroWinklerDistanceTest {
    private static JaroWinklerDistance distance;

    @BeforeClass
    public static void setUp() {
        distance = new JaroWinklerDistance();
    }

    @Test
    public void testGetJaroWinklerDistance_StringString() {
        Assert.assertEquals((double)0.92499, (double)distance.apply((CharSequence)"frog", (CharSequence)"fog"), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)distance.apply((CharSequence)"fly", (CharSequence)"ant"), (double)0.0);
        Assert.assertEquals((double)0.44166, (double)distance.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)1.0E-5);
        Assert.assertEquals((double)0.9274, (double)distance.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)1.0E-5);
        Assert.assertEquals((double)0.9458, (double)distance.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-5);
        Assert.assertEquals((double)0.921458, (double)distance.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-5);
        Assert.assertEquals((double)0.882329, (double)distance.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)1.0E-5);
        Assert.assertEquals((double)0.996598, (double)distance.apply((CharSequence)"/opt/software1", (CharSequence)"/opt/software2"), (double)1.0E-5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_NullNull() {
        distance.apply(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_StringNull() {
        distance.apply((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetJaroWinklerDistance_NullString() {
        distance.apply(null, (CharSequence)"clear");
    }
}

