/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardDistance;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JaccardDistanceTest {
    private static JaccardDistance classBeingTested;

    @BeforeClass
    public static void setUp() {
        classBeingTested = new JaccardDistance();
    }

    @Test
    public void testGettingJaccardDistance() {
        Assert.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"", (CharSequence)""), (double)0.0);
        Assert.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"left", (CharSequence)""), (double)0.0);
        Assert.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"), (double)0.0);
        Assert.assertEquals((double)0.25, (double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"), (double)0.0);
        Assert.assertEquals((double)0.78, (double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)0.0);
        Assert.assertEquals((double)0.36, (double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)0.0);
        Assert.assertEquals((double)0.24, (double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)0.0);
        Assert.assertEquals((double)0.11, (double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)0.0);
        Assert.assertEquals((double)0.1, (double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)0.0);
        Assert.assertEquals((double)0.87, (double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"), (double)0.0);
        Assert.assertEquals((double)0.87, (double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingJaccardDistanceNullNull() {
        classBeingTested.apply(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingJaccardDistanceStringNull() {
        classBeingTested.apply((CharSequence)" ", null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGettingJaccardDistanceNullString() {
        classBeingTested.apply(null, (CharSequence)"right");
    }
}

